/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.internal.util;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.query.conditions.eobjects.TypeRelation;
import org.eclipse.emf.query.internal.EMFQueryPlugin;

public abstract class TypeRelationChecker {
    private static final Map typesRelationsMaps = new WeakHashMap();
    private EClass type;
    private TypeRelation relationKind;
    private Map typeRelationsCache;
    static /* synthetic */ Class class$0;

    private static Map getTypeRelationsCacheMap(EClass type, TypeRelation relationKind) {
        return TypeRelationChecker.getTypeMap(typesRelationsMaps, type, relationKind);
    }

    private static Map getTypeMap(Map typesMaps, EClass type, TypeRelation relationKind) {
        WeakHashMap map = null;
        WeakHashMap maps = (WeakHashMap)typesMaps.get(type);
        if (maps == null) {
            maps = new WeakHashMap();
            typesMaps.put(type, maps);
            map = new WeakHashMap();
            maps.put(relationKind, map);
        } else {
            map = (WeakHashMap)maps.get((Object)relationKind);
            if (map == null) {
                map = new WeakHashMap();
                maps.put(relationKind, map);
            }
        }
        return map;
    }

    private TypeRelationChecker(EClass type, TypeRelation relationKind) {
        if (type == null || relationKind == null) {
            IllegalArgumentException exception = new IllegalArgumentException("passing null ctor argument");
            EMFQueryPlugin.throwing(this.getClass(), "TypeRelationChecker", exception);
            throw exception;
        }
        this.type = type;
        this.relationKind = relationKind;
        this.typeRelationsCache = TypeRelationChecker.getTypeRelationsCacheMap(type, relationKind);
    }

    protected final Map getRelationsCache() {
        return this.typeRelationsCache;
    }

    public final EClass getType() {
        return this.type;
    }

    public final TypeRelation getTypeRelation() {
        return this.relationKind;
    }

    public boolean isTypeRelationOK(EClass eClass) {
        Boolean checked = (Boolean)this.getRelationsCache().get(eClass);
        if (checked == null) {
            boolean result = this.checkRelation(eClass);
            this.getRelationsCache().put(eClass, result ? Boolean.TRUE : Boolean.FALSE);
            return result;
        }
        return checked;
    }

    protected abstract boolean checkRelation(EClass var1);

    public static TypeRelationChecker getTypeRelationChecker(EClass type, TypeRelation relationKind) {
        if (relationKind == TypeRelation.SAMETYPE_LITERAL) {
            return new SameTypeRelationChecker(type);
        }
        if (relationKind == TypeRelation.BASETYPE_LITERAL) {
            return new BaseTypeRelationChecker(type);
        }
        if (relationKind == TypeRelation.DIRECT_BASETYPE_LITERAL) {
            return new DirectBaseTypeRelationChecker(type);
        }
        if (relationKind == TypeRelation.SUBTYPE_LITERAL) {
            return new SubTypeRelationChecker(type);
        }
        if (relationKind == TypeRelation.DIRECT_SUBTYPE_LITERAL) {
            return new DirectSubTypeRelationChecker(type);
        }
        if (relationKind == TypeRelation.SAMETYPE_OR_DIRECT_SUBTYPE_LITERAL) {
            return new ORedTypeRelationChecker(type, relationKind, new TypeRelationChecker[]{new SameTypeRelationChecker(type), new DirectSubTypeRelationChecker(type)});
        }
        if (relationKind == TypeRelation.SAMETYPE_OR_DIRECT_BASETYPE_LITERAL) {
            return new ORedTypeRelationChecker(type, relationKind, new TypeRelationChecker[]{new SameTypeRelationChecker(type), new DirectBaseTypeRelationChecker(type)});
        }
        if (relationKind == TypeRelation.SAMETYPE_OR_SUBTYPE_LITERAL) {
            return new ORedTypeRelationChecker(type, relationKind, new TypeRelationChecker[]{new SameTypeRelationChecker(type), new SubTypeRelationChecker(type)});
        }
        if (relationKind == TypeRelation.SAMETYPE_OR_BASETYPE_LITERAL) {
            return new ORedTypeRelationChecker(type, relationKind, new TypeRelationChecker[]{new SameTypeRelationChecker(type), new BaseTypeRelationChecker(type)});
        }
        if (relationKind == TypeRelation.UNRELATED_TYPE_LITERAL) {
            return new UnrelatedTypeRelationChecker(type);
        }
        if (relationKind == TypeRelation.RELATED_TYPE_LITERAL) {
            return new RelatedTypeRelationChecker(type);
        }
        IllegalArgumentException ex = new IllegalArgumentException("Invalid TypeRelation");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.query.internal.util.TypeRelationChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EMFQueryPlugin.throwing(clazz, "getTypeRelationChecker", ex);
        throw ex;
    }

    /* synthetic */ TypeRelationChecker(EClass eClass, TypeRelation typeRelation, TypeRelationChecker typeRelationChecker) {
        this(eClass, typeRelation);
    }

    private static class BaseTypeRelationChecker
    extends TypeRelationChecker {
        private List allSuperTypes;

        BaseTypeRelationChecker(EClass type) {
            super(type, TypeRelation.BASETYPE_LITERAL, null);
            this.allSuperTypes = type.getEAllSuperTypes();
        }

        protected boolean checkRelation(EClass type) {
            return this.allSuperTypes.contains(type);
        }
    }

    private static class DirectBaseTypeRelationChecker
    extends TypeRelationChecker {
        private List directSuperTypes;

        DirectBaseTypeRelationChecker(EClass type) {
            super(type, TypeRelation.DIRECT_BASETYPE_LITERAL, null);
            this.directSuperTypes = type.getESuperTypes();
        }

        protected boolean checkRelation(EClass type) {
            return this.directSuperTypes.contains(type);
        }
    }

    private static class DirectSubTypeRelationChecker
    extends TypeRelationChecker {
        DirectSubTypeRelationChecker(EClass type) {
            super(type, TypeRelation.DIRECT_SUBTYPE_LITERAL, null);
        }

        protected boolean checkRelation(EClass type) {
            return type.getESuperTypes().contains((Object)this.getType());
        }
    }

    private static class SameTypeRelationChecker
    extends TypeRelationChecker {
        SameTypeRelationChecker(EClass type) {
            super(type, TypeRelation.SAMETYPE_LITERAL, null);
        }

        protected boolean checkRelation(EClass type) {
            return this.getType().equals(type);
        }
    }

    private static class SubTypeRelationChecker
    extends TypeRelationChecker {
        SubTypeRelationChecker(EClass type) {
            super(type, TypeRelation.SUBTYPE_LITERAL, null);
        }

        protected boolean checkRelation(EClass type) {
            return type.getEAllSuperTypes().contains((Object)this.getType());
        }
    }

    private static class ORedTypeRelationChecker
    extends TypeRelationChecker {
        private TypeRelationChecker[] typeRelationCheckers;

        ORedTypeRelationChecker(EClass type, TypeRelation relationKind, TypeRelationChecker[] typeRelationCheckers) {
            super(type, relationKind, null);
            this.typeRelationCheckers = typeRelationCheckers;
        }

        protected boolean checkRelation(EClass type) {
            int i = 0;
            while (i < this.typeRelationCheckers.length) {
                if (this.typeRelationCheckers[i].isTypeRelationOK(type)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static class RelatedTypeRelationChecker
    extends ORedTypeRelationChecker {
        RelatedTypeRelationChecker(EClass type) {
            super(type, TypeRelation.RELATED_TYPE_LITERAL, new TypeRelationChecker[]{new SameTypeRelationChecker(type), new BaseTypeRelationChecker(type), new SubTypeRelationChecker(type)});
        }
    }

    private static class UnrelatedTypeRelationChecker
    extends TypeRelationChecker {
        private RelatedTypeRelationChecker checker;

        UnrelatedTypeRelationChecker(EClass type) {
            super(type, TypeRelation.UNRELATED_TYPE_LITERAL, null);
            this.checker = new RelatedTypeRelationChecker(type);
        }

        protected boolean checkRelation(EClass type) {
            return !this.checker.checkRelation(type);
        }
    }
}

