/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class EMFEventType
implements Serializable {
    private static final long serialVersionUID = 5785536193334824240L;
    private static int nextOrdinal = 0;
    public static final EMFEventType ADD = new EMFEventType("Add", true, 3);
    public static final EMFEventType ADD_MANY = new EMFEventType("Add Many", true, 5);
    public static final EMFEventType MOVE = new EMFEventType("Move", true, 7);
    public static final EMFEventType REMOVE = new EMFEventType("Remove", true, 4);
    public static final EMFEventType REMOVE_MANY = new EMFEventType("Remove Many", true, 6);
    public static final EMFEventType SET = new EMFEventType("Set", true, 1);
    public static final EMFEventType UNSET = new EMFEventType("Unset", true, 2);
    public static final EMFEventType RESOLVE = new EMFEventType("Resolve", true, 9);
    public static final EMFEventType REMOVING_ADAPTER = new EMFEventType("Removing Adapter", false, 8);
    public static final EMFEventType CREATE = new EMFEventType("Create", true, 0);
    public static final EMFEventType NULL = new EMFEventType("none", false, -1);
    private static final List instances = Collections.unmodifiableList(Arrays.asList(ADD, ADD_MANY, MOVE, REMOVE, REMOVE_MANY, SET, UNSET, RESOLVE, REMOVING_ADAPTER, CREATE, NULL));
    private final String name;
    private final boolean featureSpecific;
    private final int ordinal;
    private final int notificationTypeCode;

    private EMFEventType(String name, boolean featureSpecific, int notificationTypeCode) {
        this.name = name;
        this.featureSpecific = featureSpecific;
        this.ordinal = nextOrdinal++;
        this.notificationTypeCode = notificationTypeCode;
    }

    public static EMFEventType getInstance(String name) {
        EMFEventType result = NULL;
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            EMFEventType next = (EMFEventType)iter.next();
            if (!next.getName().equalsIgnoreCase(name)) continue;
            result = next;
            break;
        }
        return result;
    }

    public static EMFEventType getInstance(int code) {
        EMFEventType result = NULL;
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            EMFEventType next = (EMFEventType)iter.next();
            if (next.toNotificationType() != code) continue;
            result = next;
            break;
        }
        return result;
    }

    public static final List getAllInstances() {
        return instances;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isFeatureSpecific() {
        return this.featureSpecific;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public int toNotificationType() {
        return this.notificationTypeCode;
    }

    public String toString() {
        return this.getName();
    }

    private Object readResolve() {
        return EMFEventType.getAllInstances().get(this.ordinal);
    }
}

