/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.EMFModelValidationDebugOptions;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.internal.service.AbstractValidationContext;
import org.eclipse.emf.validation.internal.service.ClientContextManager;
import org.eclipse.emf.validation.internal.service.IProviderOperation;
import org.eclipse.emf.validation.internal.util.TextUtils;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.util.FilteredCollection;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractValidationContext
implements IValidationContext {
    private final IProviderOperation operation;
    private final ConstraintIgnorement ignoredConstraints = new ConstraintIgnorement();
    private ConstraintFilter filter;
    private final Map constraintData = new HashMap();
    private IModelConstraint currentConstraint = null;
    private IConstraintDescriptor currentDescriptor = null;
    private Set resultLocus = new HashSet();
    private boolean reportSuccesses = false;
    private Collection clientContexts = Collections.EMPTY_SET;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.validation.internal.service.AbstractValidationContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected AbstractValidationContext(IProviderOperation operation) {
        this.operation = operation;
    }

    protected final IProviderOperation getOperation() {
        return this.operation;
    }

    public EMFEventType getEventType() {
        return EMFEventType.NULL;
    }

    public List getAllEvents() {
        return Collections.EMPTY_LIST;
    }

    public EStructuralFeature getFeature() {
        return null;
    }

    public Object getFeatureNewValue() {
        return null;
    }

    public void disableCurrentConstraint(Throwable exception) {
        if (!$assertionsDisabled && exception == null) {
            throw new AssertionError();
        }
        this.getDescriptor().setError(exception);
    }

    public void skipCurrentConstraintFor(EObject eObject) {
        this.ignoredConstraints.ignore(eObject, this.getDescriptor());
    }

    public void skipCurrentConstraintForAll(Collection eObjects) {
        Iterator iter = eObjects.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (!(next instanceof EObject)) continue;
            this.skipCurrentConstraintFor((EObject)next);
        }
    }

    public FilteredCollection.Filter getConstraintFilter() {
        if (this.filter == null) {
            this.filter = new ConstraintFilter();
        }
        return this.filter;
    }

    public boolean isDisabled() {
        return !this.getDescriptor().isEnabled();
    }

    public final Object getCurrentConstraintData() {
        return this.constraintData.get(this.getConstraint());
    }

    public final Object putCurrentConstraintData(Object newData) {
        return this.constraintData.put(this.getConstraint(), newData);
    }

    public Notification getNotification() {
        return null;
    }

    void initializeResultLocus() {
        this.resultLocus.clear();
        this.resultLocus.add(this.getTarget());
    }

    public void addResult(EObject eObject) {
        if (!$assertionsDisabled && eObject == null) {
            throw new AssertionError();
        }
        this.resultLocus.add(eObject);
    }

    public void addResults(Collection eObjects) {
        if (!$assertionsDisabled && eObjects == null) {
            throw new AssertionError();
        }
        Iterator iter = eObjects.iterator();
        while (iter.hasNext()) {
            this.addResult((EObject)iter.next());
        }
    }

    public Set getResultLocus() {
        return Collections.unmodifiableSet(this.resultLocus);
    }

    public final String getCurrentConstraintId() {
        return this.getConstraint().getDescriptor().getId();
    }

    final IModelConstraint getConstraint() {
        return this.currentConstraint;
    }

    final IConstraintDescriptor getDescriptor() {
        return this.currentDescriptor;
    }

    private void setConstraint(IModelConstraint constraint) {
        this.currentConstraint = constraint;
        this.currentDescriptor = constraint.getDescriptor();
    }

    public final EObject getTarget() {
        return this.getOperation().getEObject();
    }

    public boolean isReportSuccesses() {
        return this.reportSuccesses;
    }

    void setReportSuccesses(boolean b) {
        this.reportSuccesses = b;
    }

    public IStatus createSuccessStatus() {
        if (Trace.shouldTrace(EMFModelValidationDebugOptions.CONSTRAINTS_EVALUATION)) {
            Trace.trace(EMFModelValidationDebugOptions.CONSTRAINTS_EVALUATION, "Constraint " + this.getCurrentConstraintId() + " passed.");
        }
        return this.isReportSuccesses() ? new SuccessStatus(this.getTarget(), this.getConstraint()) : Status.OK_STATUS;
    }

    public IStatus createFailureStatus(Object[] messageArgs) {
        String message = this.formatMessage(messageArgs == null ? new Object[]{} : messageArgs);
        if (Trace.shouldTrace(EMFModelValidationDebugOptions.CONSTRAINTS_EVALUATION)) {
            Trace.trace(EMFModelValidationDebugOptions.CONSTRAINTS_EVALUATION, "Constraint " + this.getCurrentConstraintId() + " failed: " + message);
        }
        return new ConstraintStatus(this.getConstraint(), this.getTarget(), message, this.getResultLocus());
    }

    private String formatMessage(Object[] inputArgs) {
        Object[] args = new Object[inputArgs.length];
        int i = 0;
        while (i < args.length) {
            Object inputArg = inputArgs[i];
            inputArg = inputArg instanceof Collection ? this.formatMultiValue((Collection)inputArg) : (inputArg instanceof Object[] ? this.formatMultiValue(Arrays.asList((Object[])inputArg)) : this.formatScalarValue(inputArg));
            args[i] = inputArg;
            ++i;
        }
        return NLS.bind((String)this.getDescriptor().getMessagePattern(), (Object[])args);
    }

    private String formatMultiValue(Collection multiValuedArg) {
        ArrayList args = new ArrayList(multiValuedArg);
        ListIterator<String> iter = args.listIterator();
        while (iter.hasNext()) {
            iter.set(this.formatScalarValue(iter.next()));
        }
        return EMFModelValidationPlugin.formatList(args);
    }

    private String formatScalarValue(Object value) {
        if (value instanceof EObject) {
            return TextUtils.getText((EObject)value);
        }
        return String.valueOf(value);
    }

    final Collection getConstraints() {
        final Collection delegate = ClientContextManager.getInstance().getBindings(this.clientContexts, this.getOperation().getConstraints());
        return new AbstractCollection(){

            public Iterator iterator() {
                class ConstraintsIterator
                implements Iterator {
                    private final Iterator delegateIterator;
                    final /* synthetic */ AbstractValidationContext this$0;

                    ConstraintsIterator(AbstractValidationContext abstractValidationContext, Collection delegateCollection) {
                        this.this$0 = abstractValidationContext;
                        this.delegateIterator = delegateCollection.iterator();
                    }

                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        E result = this.delegateIterator.next();
                        AbstractValidationContext.access$1(this.this$0, (IModelConstraint)result);
                        this.this$0.initializeResultLocus();
                        return result;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                }
                return new ConstraintsIterator(AbstractValidationContext.this, delegate);
            }

            public int size() {
                return delegate.size();
            }
        };
    }

    final void setClientContexts(Collection clientContexts) {
        if (clientContexts == null) {
            clientContexts = Collections.EMPTY_SET;
        }
        this.clientContexts = clientContexts;
    }

    final Collection getClientContexts() {
        return this.clientContexts;
    }

    static /* synthetic */ void access$1(AbstractValidationContext abstractValidationContext, IModelConstraint iModelConstraint) {
        abstractValidationContext.setConstraint(iModelConstraint);
    }

    private class ConstraintFilter
    implements FilteredCollection.Filter {
        ConstraintFilter() {
        }

        public boolean accept(Object constraint) {
            IConstraintDescriptor desc = ((IModelConstraint)constraint).getDescriptor();
            return desc.isEnabled() && !this.isIgnored(desc);
        }

        private boolean isIgnored(IConstraintDescriptor desc) {
            return AbstractValidationContext.this.ignoredConstraints.isIgnored(AbstractValidationContext.this.getTarget(), desc);
        }
    }

    private class ConstraintIgnorement {
        private final Map ignoreMap = new HashMap();

        private ConstraintIgnorement() {
        }

        void ignore(EObject eObject, IConstraintDescriptor constraint) {
            Collection ignored = this.getIgnoredConstraints(eObject);
            if (ignored == null) {
                ignored = this.initIgnoredConstraints(eObject);
            }
            ignored.add(constraint);
        }

        boolean isIgnored(EObject eObject, IConstraintDescriptor constraint) {
            Collection ignored = this.getIgnoredConstraints(eObject);
            return ignored != null && ignored.contains(constraint);
        }

        private Collection getIgnoredConstraints(EObject target) {
            return (Collection)this.ignoreMap.get(target);
        }

        private Collection initIgnoredConstraints(EObject target) {
            HashSet result = new HashSet();
            this.ignoreMap.put(target, result);
            return result;
        }
    }

    private static class SuccessStatus
    extends Status
    implements IConstraintStatus {
        private final EObject target;
        private final IModelConstraint constraint;

        SuccessStatus(EObject target, IModelConstraint constraint) {
            super(0, EMFModelValidationPlugin.getPluginId(), 0, EMFModelValidationStatusCodes.CONSTRAINT_SUCCESS_MSG, null);
            this.target = target;
            this.constraint = constraint;
        }

        public IModelConstraint getConstraint() {
            return this.constraint;
        }

        public EObject getTarget() {
            return this.target;
        }

        public Set getResultLocus() {
            return Collections.EMPTY_SET;
        }
    }
}

