/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.internal.EMFModelValidationDebugOptions;
import org.eclipse.emf.validation.internal.service.AbstractValidationContext;
import org.eclipse.emf.validation.internal.service.AbstractValidator;
import org.eclipse.emf.validation.internal.service.ClientContextManager;
import org.eclipse.emf.validation.internal.service.GetBatchConstraintsOperation;
import org.eclipse.emf.validation.internal.service.IProviderOperationExecutor;
import org.eclipse.emf.validation.internal.service.TraversalStrategyManager;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;

public class BatchValidator
extends AbstractValidator
implements IBatchValidator {
    private boolean includeLiveConstraints = false;
    private IProgressMonitor progressMonitor = null;
    private ITraversalStrategy traversalStrategy = new DefaultRecursiveTraversalStrategy();

    public BatchValidator(IProviderOperationExecutor executor) {
        super(EvaluationMode.BATCH, executor);
    }

    public boolean isIncludeLiveConstraints() {
        return this.includeLiveConstraints;
    }

    public void setIncludeLiveConstraints(boolean includeLiveConstraints) {
        this.includeLiveConstraints = includeLiveConstraints;
    }

    public ITraversalStrategy getDefaultTraversalStrategy() {
        return new DefaultRecursiveTraversalStrategy();
    }

    public ITraversalStrategy getTraversalStrategy() {
        return this.traversalStrategy;
    }

    public void setTraversalStrategy(ITraversalStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("strategy is null");
        }
        this.traversalStrategy = strategy;
    }

    public IStatus validate(EObject eObject, IProgressMonitor monitor) {
        this.progressMonitor = monitor;
        IStatus result = this.validate(eObject);
        return result;
    }

    public IStatus validate(Collection objects, IProgressMonitor monitor) {
        this.progressMonitor = monitor;
        IStatus result = this.validate(objects);
        return result;
    }

    protected Collection doValidate(Collection objects, Set clientContexts) {
        ArrayList result = new ArrayList(64);
        GetBatchConstraintsOperation operation = new GetBatchConstraintsOperation(!this.isIncludeLiveConstraints());
        AbstractValidationContext ctx = operation.getContext();
        ctx.setReportSuccesses(this.isReportSuccesses());
        this.validate(this.getTraversalStrategy(), result, ctx, objects, operation, clientContexts);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validate(ITraversalStrategy traversal, List evaluationResults, AbstractValidationContext ctx, Collection objects, GetBatchConstraintsOperation operation, Set clientContexts) {
        IProgressMonitor monitor = this.progressMonitor;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        traversal.startTraversal(objects, monitor);
        boolean firstElement = true;
        try {
            try {
                while (traversal.hasNext() && !monitor.isCanceled()) {
                    boolean recomputeClients = firstElement || traversal.isClientContextChanged();
                    EObject next = traversal.next();
                    if (recomputeClients) {
                        Collection contexts = ClientContextManager.getInstance().getClientContextsFor(next);
                        ctx.setClientContexts(contexts);
                        clientContexts.addAll(contexts);
                    }
                    traversal.elementValidated(next, this.validate(ctx, next, operation, evaluationResults));
                    firstElement = false;
                }
            }
            catch (OperationCanceledException e) {
                monitor.setCanceled(true);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (!monitor.isCanceled()) {
                monitor.done();
            }
            this.progressMonitor = null;
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        if (!monitor.isCanceled()) {
            monitor.done();
        }
        this.progressMonitor = null;
    }

    private IStatus validate(AbstractValidationContext ctx, EObject eObject, GetBatchConstraintsOperation operation, List results) {
        if (Trace.shouldTraceEntering(EMFModelValidationDebugOptions.PROVIDERS)) {
            Trace.entering(this.getClass(), "validate", new Object[]{eObject});
        }
        operation.setTarget(eObject);
        this.execute(operation);
        IStatus result = this.evaluateConstraints(ctx, results);
        if (Trace.shouldTraceExiting(EMFModelValidationDebugOptions.PROVIDERS)) {
            Trace.exiting(this.getClass(), "validate", result);
        }
        return result;
    }

    private static class DefaultRecursiveTraversalStrategy
    implements ITraversalStrategy {
        private Map delegates;
        private Iterator delegateIterator;
        private ITraversalStrategy current;

        private DefaultRecursiveTraversalStrategy() {
        }

        public void startTraversal(Collection traversalRoots, IProgressMonitor monitor) {
            this.delegates = this.initDelegates(traversalRoots);
            monitor.beginTask("", this.delegates.size() * 1024);
            Iterator iter = this.delegates.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry next = iter.next();
                SubProgressMonitor sub = new SubProgressMonitor(monitor, 1024, 2);
                ((ITraversalStrategy)next.getKey()).startTraversal((Collection)next.getValue(), (IProgressMonitor)sub);
                next.setValue(sub);
            }
            this.delegateIterator = this.delegates.keySet().iterator();
        }

        public boolean hasNext() {
            if (this.current == null && this.delegateIterator.hasNext()) {
                this.current = (ITraversalStrategy)this.delegateIterator.next();
            }
            if (this.current == null) {
                return false;
            }
            if (!this.current.hasNext()) {
                ((IProgressMonitor)this.delegates.get(this.current)).done();
                this.current = null;
                return this.hasNext();
            }
            return true;
        }

        public EObject next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.next();
        }

        public boolean isClientContextChanged() {
            if (this.current != null) {
                return this.current.isClientContextChanged();
            }
            return false;
        }

        public void elementValidated(EObject element, IStatus status) {
            this.current.elementValidated(element, status);
        }

        private Map initDelegates(Collection traversalRoots) {
            HashMap<ITraversalStrategy, LinkedList<EObject>> result = new HashMap<ITraversalStrategy, LinkedList<EObject>>();
            Iterator iter = traversalRoots.iterator();
            while (iter.hasNext()) {
                EObject next = (EObject)iter.next();
                ITraversalStrategy delegate = TraversalStrategyManager.getInstance().getTraversalStrategy(next);
                LinkedList<EObject> delegateRoots = (LinkedList<EObject>)result.get(delegate);
                if (delegateRoots == null) {
                    delegateRoots = new LinkedList<EObject>();
                    result.put(delegate, delegateRoots);
                }
                delegateRoots.add(next);
            }
            return result;
        }
    }
}

