/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.xml.ConstraintParserException;
import org.eclipse.emf.validation.xml.IXmlConstraintDescriptor;
import org.eclipse.emf.validation.xml.IXmlConstraintParser;
import org.osgi.framework.Bundle;

public class JavaConstraintParser
implements IXmlConstraintParser {
    private static final Map constraintImplementationMap = new HashMap();
    static /* synthetic */ Class class$0;

    public IModelConstraint parseConstraint(IXmlConstraintDescriptor descriptor) throws ConstraintParserException {
        String className = descriptor.getConfig().getAttribute("class");
        if (className == null) {
            ConstraintParserException cpe = new ConstraintParserException("No class name.");
            Trace.throwing(this.getClass(), "parseConstraint", cpe);
            throw cpe;
        }
        return this.createCustomConstraint(className, descriptor);
    }

    private IModelConstraint createCustomConstraint(String className, IXmlConstraintDescriptor descriptor) throws ConstraintParserException {
        ConstraintAdapter result = null;
        ReflectiveOperationException pendingException = null;
        String pendingMessage = null;
        Bundle bundle = Platform.getBundle((String)descriptor.getConfig().getDeclaringExtension().getNamespaceIdentifier());
        try {
            Class resultType = bundle.loadClass(className);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.validation.AbstractModelConstraint");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(resultType)) {
                result = new ConstraintAdapter(descriptor, (AbstractModelConstraint)JavaConstraintParser.getInstance(resultType));
            }
        }
        catch (ClassNotFoundException e) {
            pendingException = e;
            pendingMessage = EMFModelValidationPlugin.getMessage(EMFModelValidationStatusCodes.DELEGATE_CLASS_NOT_FOUND_MSG, new Object[]{descriptor.getId(), className});
        }
        catch (InstantiationException e) {
            pendingException = e;
            pendingMessage = EMFModelValidationPlugin.getMessage(EMFModelValidationStatusCodes.DELEGATE_INSTANTIATION_MSG, new Object[]{descriptor.getId(), className});
        }
        catch (IllegalAccessException e) {
            pendingException = e;
            Object[] objectArray = new Object[3];
            objectArray[0] = descriptor.getId();
            objectArray[1] = className;
            pendingMessage = EMFModelValidationPlugin.getMessage(EMFModelValidationStatusCodes.DELEGATE_METHOD_INACCESSIBLE_MSG, objectArray);
        }
        if (pendingException != null) {
            Trace.catching(this.getClass(), "createCustomConstraint", pendingException);
            Log.error(70, pendingMessage, pendingException);
            ConstraintParserException cpe = new ConstraintParserException(pendingException.getLocalizedMessage(), pendingException);
            Trace.throwing(this.getClass(), "createCustomConstraint", cpe);
            throw cpe;
        }
        return result;
    }

    static Object getInstance(Class constraintClass) throws InstantiationException, IllegalAccessException {
        Object result = constraintImplementationMap.get(constraintClass);
        if (result == null) {
            result = constraintClass.newInstance();
            constraintImplementationMap.put(constraintClass, result);
        }
        return result;
    }

    private static class ConstraintAdapter
    implements IModelConstraint {
        private final AbstractModelConstraint delegate;
        private final IConstraintDescriptor descriptor;

        ConstraintAdapter(IConstraintDescriptor descriptor, AbstractModelConstraint delegate) {
            this.descriptor = descriptor;
            this.delegate = delegate;
        }

        public IStatus validate(IValidationContext ctx) {
            return this.delegate.validate(ctx);
        }

        public IConstraintDescriptor getDescriptor() {
            return this.descriptor;
        }
    }
}

