/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.util;

import com.ibm.icu.lang.UCharacter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.validation.internal.EMFModelValidationDebugOptions;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.internal.util.DisabledConstraint;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintFactory;
import org.eclipse.emf.validation.xml.ConstraintParserException;
import org.eclipse.emf.validation.xml.IXmlConstraintDescriptor;
import org.eclipse.emf.validation.xml.IXmlConstraintParser;

public class XmlConstraintFactory
extends ConstraintFactory {
    private static final String CONSTRAINT_PARSERS_EXT_P_NAME = "constraintParsers";
    private final Map parserMap = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.validation.internal.util.XmlConstraintFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public XmlConstraintFactory() {
        this.initializeParsers();
    }

    protected IModelConstraint createConstraint(IXmlConstraintDescriptor desc) {
        IConfigurationElement config = desc.getConfig();
        String lang = config.getAttribute("lang");
        IXmlConstraintParser parser = this.getParser(lang);
        try {
            if (parser != null) {
                return parser.parseConstraint(desc);
            }
            Trace.trace(EMFModelValidationDebugOptions.CONSTRAINTS_DISABLED, "Constraint is disabled: " + desc.getId() + ".  See log for details.");
            ConstraintParserException e = new ConstraintParserException(EMFModelValidationPlugin.getMessage(EMFModelValidationStatusCodes.CONSTRAINT_PARSER_MISSING_MSG, new Object[]{lang}));
            Log.warning(73, e.getMessage());
            return new DisabledConstraint(desc, e);
        }
        catch (ConstraintParserException e) {
            return new DisabledConstraint(desc, e);
        }
    }

    void registerParser(IConfigurationElement config) {
        if (!$assertionsDisabled && config == null) {
            throw new AssertionError();
        }
        String language = config.getAttribute("lang");
        String className = config.getAttribute("class");
        try {
            Object parser = config.createExecutableExtension("class");
            if (parser instanceof IXmlConstraintParser) {
                this.parserMap.put(UCharacter.toLowerCase((String)language), parser);
                Trace.trace(EMFModelValidationDebugOptions.PARSERS, "Initialized parser for constraint language: " + language);
            } else {
                Trace.trace(EMFModelValidationDebugOptions.PARSERS, "Parser could not be initialized for constraint language: " + language);
                Log.warningMessage(72, EMFModelValidationStatusCodes.CONSTRAINT_PARSER_TYPE_MSG, new Object[]{className, language});
            }
        }
        catch (Exception e) {
            Trace.catching(this.getClass(), "registerParser", e);
            Log.warningMessage(71, EMFModelValidationStatusCodes.CONSTRAINT_PARSER_NOT_INITED_MSG, new Object[]{className, language}, e);
        }
    }

    private IXmlConstraintParser getParser(String language) {
        return (IXmlConstraintParser)this.parserMap.get(UCharacter.toLowerCase((String)language));
    }

    private void initializeParsers() {
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EMFModelValidationPlugin.getPluginId(), CONSTRAINT_PARSERS_EXT_P_NAME);
        int i = 0;
        while (i < configs.length) {
            IConfigurationElement config = configs[i];
            this.registerParser(config);
            ++i;
        }
    }
}

