/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.marker;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.marker.IMarkerConfigurator;
import org.eclipse.emf.validation.model.IConstraintStatus;

public final class MarkerUtil {
    public static final String VALIDATION_MARKER_TYPE = "org.eclipse.emf.validation.problem";
    public static final String RULE_ATTRIBUTE = "rule";
    private static final String PLATFORM_SCHEME = "platform";
    private static final String FILE_SCHEME = "file";
    private static final String RESOURCE_SEGMENT = "resource";

    public static void createMarkers(IStatus validationStatus) throws CoreException {
        MarkerUtil.createMarkers(validationStatus, VALIDATION_MARKER_TYPE, null);
    }

    public static void createMarkers(final IStatus validationStatus, final String markerType, final IMarkerConfigurator configurator) throws CoreException {
        if (validationStatus.isOK()) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor m) throws CoreException {
                HashMap visitedResources = new HashMap();
                if (validationStatus.isMultiStatus()) {
                    IStatus[] children = validationStatus.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        if (children[i] instanceof IConstraintStatus) {
                            MarkerUtil.createMarker((IConstraintStatus)children[i], markerType, configurator, visitedResources);
                        }
                        ++i;
                    }
                } else if (validationStatus instanceof IConstraintStatus) {
                    MarkerUtil.createMarker((IConstraintStatus)validationStatus, markerType, configurator, visitedResources);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
    }

    private static void createMarker(IConstraintStatus status, String markerType, IMarkerConfigurator configurator, Map visitedResources) throws CoreException {
        Resource r = status.getTarget().eResource();
        URI uri = r.getURI();
        uri = r.getResourceSet().getURIConverter().normalize(uri);
        IFile file = (IFile)visitedResources.get(uri);
        if (file == null) {
            if (PLATFORM_SCHEME.equals(uri.scheme()) && uri.segmentCount() > 1 && RESOURCE_SEGMENT.equals(uri.segment(0))) {
                StringBuffer platformResourcePath = new StringBuffer();
                int j = 1;
                int size = uri.segmentCount();
                while (j < size) {
                    platformResourcePath.append('/');
                    platformResourcePath.append(uri.segment(j));
                    ++j;
                }
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
            } else if (FILE_SCHEME.equals(uri.scheme())) {
                StringBuffer fileResourcePath = new StringBuffer();
                int j = 1;
                int size = uri.segmentCount();
                while (j < size) {
                    fileResourcePath.append('/');
                    fileResourcePath.append(uri.segment(j));
                    ++j;
                }
                file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileResourcePath.toString()));
            }
            if (file != null) {
                file.deleteMarkers(VALIDATION_MARKER_TYPE, true, 0);
                visitedResources.put(uri, file);
            }
        }
        if (file != null) {
            if (!status.matches(14)) {
                return;
            }
            IMarker marker = file.createMarker(markerType);
            switch (status.getSeverity()) {
                case 2: {
                    marker.setAttribute("severity", 1);
                    marker.setAttribute("priority", 1);
                }
                case 4: 
                case 8: {
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("priority", 2);
                }
            }
            marker.setAttribute("message", (Object)status.getMessage());
            marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)status.getTarget()).toString());
            marker.setAttribute(RULE_ATTRIBUTE, (Object)status.getConstraint().getDescriptor().getId());
            if (configurator != null) {
                configurator.appendMarkerConfiguration(marker, status);
            }
        }
    }
}

