/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.validation.internal.l10n.ValidationMessages;

public final class EvaluationMode
implements Serializable {
    private static final long serialVersionUID = -2088295328444150344L;
    static final String LIVE_MODE = ValidationMessages.mode_live;
    static final String BATCH_MODE = ValidationMessages.mode_batch;
    static final String NULL_MODE = ValidationMessages.mode_unknown;
    private static int nextOrdinal = 0;
    public static final EvaluationMode LIVE = new EvaluationMode("Live", LIVE_MODE);
    public static final EvaluationMode BATCH = new EvaluationMode("Batch", BATCH_MODE);
    public static final EvaluationMode NULL = new EvaluationMode("none", NULL_MODE);
    private static final List instances = Collections.unmodifiableList(Arrays.asList(LIVE, BATCH, NULL));
    private final String name;
    private final int ordinal;
    private final String localizedName;

    private EvaluationMode(String name, String localizedName) {
        this.name = name;
        this.ordinal = nextOrdinal++;
        this.localizedName = localizedName;
    }

    public static EvaluationMode getInstance(String name) {
        EvaluationMode result = NULL;
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            EvaluationMode next = (EvaluationMode)iter.next();
            if (!next.getName().equalsIgnoreCase(name)) continue;
            result = next;
            break;
        }
        return result;
    }

    public static final List getAllInstances() {
        return instances;
    }

    public final String getName() {
        return this.name;
    }

    public final String getLocalizedName() {
        return this.localizedName;
    }

    public boolean isNull() {
        return this == NULL;
    }

    public boolean isLive() {
        return this == LIVE;
    }

    public boolean isBatch() {
        return this.isBatchOnly() || this.isLive();
    }

    public boolean isBatchOnly() {
        return this == BATCH;
    }

    public String toString() {
        return this.getName();
    }

    private Object readResolve() {
        return EvaluationMode.getAllInstances().get(this.ordinal);
    }
}

