/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.EMFModelValidationDebugOptions;
import org.eclipse.emf.validation.internal.EMFModelValidationPlugin;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.internal.l10n.ValidationMessages;
import org.eclipse.emf.validation.internal.util.DisabledConstraint;
import org.eclipse.emf.validation.internal.util.Log;
import org.eclipse.emf.validation.internal.util.Trace;
import org.eclipse.emf.validation.internal.util.XmlConfigurationElement;
import org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.AbstractConstraintProvider;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.ConstraintFactory;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.util.XmlConfig;
import org.eclipse.emf.validation.xml.IXmlConstraintDescriptor;

public class XmlConstraintProvider
extends AbstractConstraintProvider
implements IExecutableExtension {
    static final String NO_NAME;
    static final String REASON_NO_ID;
    static final String UNKNOWN_FILE;
    private List myConstraints = Collections.EMPTY_LIST;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.validation.xml.XmlConstraintProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        NO_NAME = ValidationMessages.constraint_not_init_name;
        REASON_NO_ID = ValidationMessages.constraint_reason_no_id;
        UNKNOWN_FILE = ValidationMessages.xml_unknown_file;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        IConfigurationElement[] constraintses = config.getChildren("constraints");
        this.myConstraints = new ArrayList();
        int i = 0;
        while (i < constraintses.length) {
            IConfigurationElement next = XmlConfig.parseConstraintsWithIncludes(constraintses[i]);
            IConfigurationElement[] configs = next.getChildren();
            int j = 0;
            while (j < configs.length) {
                this.addConstraint(configs[j]);
                ++j;
            }
            ++i;
        }
        XmlConfig.flushResourceBundles();
    }

    public Collection getLiveConstraints(Notification notification, Collection constraints) {
        ArrayList<IModelConstraint> result;
        if (!$assertionsDisabled && notification == null) {
            throw new AssertionError();
        }
        if (Trace.shouldTraceEntering(EMFModelValidationDebugOptions.PROVIDERS)) {
            Trace.entering(this.getClass(), "getLiveConstraints");
        }
        if ((result = constraints) == null) {
            result = new ArrayList<IModelConstraint>();
        }
        if (notification.getNotifier() instanceof EObject) {
            EObject eObject = (EObject)notification.getNotifier();
            Iterator iter = this.getConstraints().iterator();
            while (iter.hasNext()) {
                IModelConstraint next = (IModelConstraint)iter.next();
                IConstraintDescriptor desc = next.getDescriptor();
                if (!desc.isLive() || !desc.targetsTypeOf(eObject) || !desc.targetsEvent(notification)) continue;
                result.add(next);
            }
        }
        if (Trace.shouldTraceExiting(EMFModelValidationDebugOptions.PROVIDERS)) {
            Trace.exiting(this.getClass(), "getLiveConstraints");
        }
        return result;
    }

    public Collection getBatchConstraints(EObject eObject, Collection constraints) {
        ArrayList<IModelConstraint> result;
        if (Trace.shouldTraceEntering(EMFModelValidationDebugOptions.PROVIDERS)) {
            Trace.entering(this.getClass(), "getBatchConstraints");
        }
        if ((result = constraints) == null) {
            result = new ArrayList<IModelConstraint>();
        }
        Iterator iter = this.getConstraints().iterator();
        while (iter.hasNext()) {
            IModelConstraint next = (IModelConstraint)iter.next();
            IConstraintDescriptor desc = next.getDescriptor();
            if (!desc.isBatch() || !desc.targetsTypeOf(eObject)) continue;
            result.add(next);
        }
        if (Trace.shouldTraceExiting(EMFModelValidationDebugOptions.PROVIDERS)) {
            Trace.exiting(this.getClass(), "getBatchConstraints");
        }
        return result;
    }

    protected List getConstraints() {
        return this.myConstraints;
    }

    private void addConstraint(IConfigurationElement config) {
        String contributorId = config.getDeclaringExtension().getNamespaceIdentifier();
        String id = config.getAttribute("id");
        if (id == null) {
            String name = config.getAttribute("name");
            if (name == null) {
                String fileName = config instanceof XmlConfigurationElement ? ((XmlConfigurationElement)config).getFileName() : UNKNOWN_FILE;
                name = EMFModelValidationPlugin.getMessage(NO_NAME, new Object[]{fileName});
            }
            Log.warningMessage(70, EMFModelValidationStatusCodes.CONSTRAINT_NOT_INITED_MSG, new Object[]{name, REASON_NO_ID});
        } else {
            IConstraintDescriptor constraint = ConstraintRegistry.getInstance().getDescriptor(contributorId, id);
            if (constraint == null) {
                try {
                    constraint = new XmlConstraintDescriptor(config);
                }
                catch (ConstraintExistsException constraintExistsException) {}
            }
            if (constraint instanceof IXmlConstraintDescriptor) {
                IXmlConstraintDescriptor xmlConstraint = (IXmlConstraintDescriptor)constraint;
                xmlConstraint.resolveTargetTypes(this.getNamespaceUris());
                ConstraintProxy proxy = new ConstraintProxy(xmlConstraint);
                this.getConstraints().add(proxy);
                Trace.trace(EMFModelValidationDebugOptions.PROVIDERS, "Added constraint proxy: " + constraint);
            }
        }
    }

    private class ConstraintProxy
    implements IModelConstraint {
        private final IXmlConstraintDescriptor descriptor;
        private IModelConstraint delegate = null;

        ConstraintProxy(IXmlConstraintDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public IConstraintDescriptor getDescriptor() {
            return this.descriptor;
        }

        public IStatus validate(IValidationContext ctx) {
            IStatus result;
            if (this.delegate == null) {
                if (Trace.shouldTrace(EMFModelValidationDebugOptions.CONSTRAINTS)) {
                    Trace.trace(EMFModelValidationDebugOptions.CONSTRAINTS, "Initializing constraint delegate: " + this.descriptor);
                }
                this.delegate = ConstraintFactory.getInstance().newConstraint(this.descriptor);
            }
            try {
                if (Trace.shouldTrace(EMFModelValidationDebugOptions.CONSTRAINTS_EVALUATION)) {
                    Trace.trace(EMFModelValidationDebugOptions.CONSTRAINTS_EVALUATION, "Delegating validate() method to: " + this.delegate + " for: " + this.descriptor);
                }
                result = this.delegate.validate(ctx);
            }
            catch (RuntimeException e) {
                Trace.catching(this.getClass(), "validate()", e);
                Trace.trace(EMFModelValidationDebugOptions.CONSTRAINTS_DISABLED, "Constraint is disabled: " + this.descriptor);
                this.delegate = new DisabledConstraint(this.descriptor, e);
                result = this.delegate.validate(ctx);
            }
            ListIterator<IModelConstraint> iter = XmlConstraintProvider.this.getConstraints().listIterator();
            while (iter.hasNext()) {
                if (iter.next() != this) continue;
                iter.set(this.delegate);
                break;
            }
            ModelValidationService.getInstance().replaceInCache(this, this.delegate);
            return result;
        }
    }
}

