/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.resolver;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

public class ContainmentClosure {
    private static WeakReference rootRef;
    private static WeakReference scopeRef;
    private static WeakReference closureRef;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.resolver.ContainmentClosure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        rootRef = new WeakReference<Object>(null);
        scopeRef = new WeakReference<Object>(null);
        closureRef = new WeakReference<Object>(null);
    }

    private ContainmentClosure() {
    }

    public static synchronized boolean contains(EClass root, EClass type, EPackage scope) {
        if (!$assertionsDisabled && root == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && scope == null) {
            throw new AssertionError();
        }
        Set closure = (Set)closureRef.get();
        if (rootRef.get() != root || scopeRef.get() != scope || closure == null) {
            closure = ContainmentClosure.build(root, scope);
            rootRef = new WeakReference<EClass>(root);
            scopeRef = new WeakReference<EPackage>(scope);
            closureRef = new WeakReference<Set>(closure);
        }
        return closure.contains(type);
    }

    private static Set build(EClass type, EPackage scope) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        HashSet<EClass> closure = new HashSet<EClass>();
        HashSet<EClass> roots = new HashSet<EClass>();
        roots.add(type);
        while (!roots.isEmpty()) {
            HashSet<EClass> localRoots = roots;
            roots = new HashSet();
            Iterator it = localRoots.iterator();
            while (it.hasNext()) {
                EClass root = (EClass)it.next();
                Iterator it1 = root.getEAllContainments().iterator();
                while (it1.hasNext()) {
                    EClass refType = ((EReference)it1.next()).getEReferenceType();
                    if (closure.contains(refType)) continue;
                    closure.add(refType);
                    roots.add(refType);
                    Collection subtypes = ContainmentClosure.getSubtypes(refType, scope);
                    if (subtypes == null) continue;
                    Iterator it2 = subtypes.iterator();
                    while (it2.hasNext()) {
                        EClass subtype = (EClass)it2.next();
                        if (closure.contains(subtype)) continue;
                        closure.add(subtype);
                        roots.add(subtype);
                    }
                }
            }
        }
        return closure;
    }

    private static Collection getSubtypes(EClass type, EPackage scope) {
        HashSet<EClass> subtypes = null;
        TreeIterator it = scope.eAllContents();
        while (it.hasNext()) {
            EClass nextType;
            Object next = it.next();
            if (!(next instanceof EClass) || type == (nextType = (EClass)next) || !type.isSuperTypeOf(nextType)) continue;
            if (subtypes == null) {
                subtypes = new HashSet<EClass>();
            }
            subtypes.add(nextType);
        }
        return subtypes;
    }
}

