/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.provider.GMFGraphItemProviderAdapterFactory;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.pages.CreateToolDef;
import org.eclipse.gmf.internal.bridge.wizards.pages.MapDefFeeder;
import org.eclipse.gmf.internal.bridge.wizards.pages.Messages;
import org.eclipse.gmf.internal.bridge.wizards.pages.ToolDefLookup;
import org.eclipse.gmf.internal.bridge.wizards.pages.ToolDefSupplier;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.mappings.provider.GMFMapItemProviderAdapterFactory;
import org.eclipse.gmf.tooldef.GMFToolFactory;
import org.eclipse.gmf.tooldef.ToolRegistry;
import org.eclipse.gmf.tooldef.provider.GMFToolItemProviderAdapterFactory;

public class WizardInput {
    public static final String TOOLDEF_FILE_EXT = "gmftool";
    public static final String GRAPHDEF_FILE_EXT = "gmfgraph";
    public static final String ECORE_FILE_EXT = "ecore";
    private EPackage myDomainModel;
    private Canvas myCanvas;
    private ToolRegistry myRegistry;
    private Mapping mapInstance;
    private EditingDomain myEditingDomain;
    private AdapterFactory myAdapterFactory;
    private IFile myResultFile = null;
    private MapDefFeeder myFeeder;
    private String initialECoreFile = null;
    private String initialGraphFile = null;
    private String initialToolFile = null;
    private boolean myIsBlankToolDef = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.wizards.pages.WizardInput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public AdapterFactory getAdapterFactory() {
        if (this.myAdapterFactory == null) {
            ArrayList<Object> factories = new ArrayList<Object>();
            factories.add(new ResourceItemProviderAdapterFactory());
            factories.add(new GMFMapItemProviderAdapterFactory());
            factories.add(new GMFGraphItemProviderAdapterFactory());
            factories.add(new GMFToolItemProviderAdapterFactory());
            factories.add(new ReflectiveItemProviderAdapterFactory());
            this.myAdapterFactory = new ComposedAdapterFactory(factories);
        }
        return this.myAdapterFactory;
    }

    public EditingDomain getEditingDomain() {
        if (this.myEditingDomain == null) {
            this.myEditingDomain = new AdapterFactoryEditingDomain(this.getAdapterFactory(), (CommandStack)new BasicCommandStack());
        }
        return this.myEditingDomain;
    }

    public ResourceSet getResourceSet() {
        return this.getEditingDomain().getResourceSet();
    }

    public void setDomainModel(EPackage aPackage) {
        this.checkUnload((EObject)this.myDomainModel);
        this.myDomainModel = aPackage;
    }

    public void setGraphDef(Canvas canvas) {
        this.checkUnload((EObject)this.myCanvas);
        this.myCanvas = canvas;
    }

    public Canvas getCanvasDef() {
        return this.myCanvas;
    }

    public boolean isNewBlankToolDef() {
        return this.myIsBlankToolDef;
    }

    public URI createBlankToolDef() {
        this.checkUnload((EObject)this.myRegistry);
        this.myRegistry = null;
        IPath toolDefFile = this.getMappingFile().getFullPath().removeFileExtension().addFileExtension(TOOLDEF_FILE_EXT);
        String baseName = this.getMappingFile().getFullPath().removeFileExtension().lastSegment();
        int i = 1;
        IWorkspace wr = this.getMappingFile().getProject().getWorkspace();
        while (wr.getRoot().findMember(toolDefFile) != null) {
            toolDefFile = toolDefFile.removeLastSegments(1).append(String.valueOf(baseName) + i).addFileExtension(TOOLDEF_FILE_EXT);
            ++i;
        }
        URI toolDefURI = URI.createPlatformResourceURI((String)toolDefFile.toString());
        this.myRegistry = GMFToolFactory.eINSTANCE.createToolRegistry();
        this.myRegistry.setPalette(GMFToolFactory.eINSTANCE.createPalette());
        this.getResourceSet().createResource(toolDefURI).getContents().add((Object)this.myRegistry);
        this.myIsBlankToolDef = true;
        return toolDefURI;
    }

    public void setToolDef(ToolRegistry registry) {
        this.checkUnload((EObject)this.myRegistry);
        this.myRegistry = registry;
        this.myIsBlankToolDef = false;
    }

    public ToolRegistry getToolDef() {
        return this.myRegistry;
    }

    public void setMappingFile(IFile resultFile) {
        this.myResultFile = resultFile;
    }

    public IFile getMappingFile() {
        return this.myResultFile;
    }

    public Mapping getMapping() {
        if (this.mapInstance == null) {
            this.mapInstance = GMFMapFactory.eINSTANCE.createMapping();
            URI res = URI.createPlatformResourceURI((String)this.getMappingFile().getFullPath().toString());
            this.getResourceSet().createResource(res).getContents().add((Object)this.mapInstance);
        }
        return this.mapInstance;
    }

    public IStatus isReady2Go() {
        if (this.myDomainModel != null && this.myCanvas != null && this.myRegistry != null) {
            return Status.OK_STATUS;
        }
        if (this.myDomainModel == null) {
            return new Status(2, Plugin.getPluginID(), 2, Messages.inputNeedDomain, null);
        }
        if (this.myCanvas == null) {
            return new Status(2, Plugin.getPluginID(), 2, Messages.inputNeedCanvas, null);
        }
        return new Status(2, Plugin.getPluginID(), 2, Messages.inputNeedToolDef, null);
    }

    private void checkUnload(EObject eobj) {
        if (eobj == null) {
            return;
        }
        if (eobj.eResource().getResourceSet() == this.getResourceSet() && eobj.eResource().isLoaded()) {
            eobj.eResource().unload();
        }
    }

    public List getCanvasElementCandidates() {
        UniqueEList rv = new UniqueEList();
        Iterator it = this.myDomainModel.getEClassifiers().iterator();
        while (it.hasNext()) {
            EClass eClass;
            Object next = it.next();
            if (!(next instanceof EClass) || (eClass = (EClass)next).isAbstract() || eClass.isInterface() || eClass.getEAllContainments().isEmpty()) continue;
            rv.add((Object)eClass);
        }
        return rv;
    }

    public void selectCanvasElement(EClass eClass) {
        CanvasMapping cm;
        if (!$assertionsDisabled && eClass.getEPackage() != this.myDomainModel) {
            throw new AssertionError();
        }
        if (this.getMapping().getDiagram() == null) {
            cm = GMFMapFactory.eINSTANCE.createCanvasMapping();
            cm.setDiagramCanvas(this.myCanvas);
        } else {
            cm = this.getMapping().getDiagram();
        }
        cm.setDomainMetaElement(eClass);
        cm.setDomainModel(eClass.getEPackage());
        this.getMapping().setDiagram(cm);
    }

    public void feedDefaultMapping() {
        this.myFeeder = new MapDefFeeder(this, this.createToolDefSupplier());
        this.myFeeder.feedDefaultMapping();
    }

    private ToolDefSupplier createToolDefSupplier() {
        if (this.isNewBlankToolDef()) {
            return new CreateToolDef(this.getToolDef());
        }
        return new ToolDefLookup(this.getToolDef());
    }

    public NodeReference[] nodeCandidates() {
        return this.myFeeder.getInitialNodes();
    }

    public LinkMapping[] linkCandidates() {
        return this.myFeeder.getInitialLinks();
    }

    public String getInitialECoreFile() {
        return this.initialECoreFile;
    }

    public void setInitialECoreFile(String initialECoreFile) {
        this.initialECoreFile = initialECoreFile;
    }

    public String getInitialGraphFile() {
        return this.initialGraphFile;
    }

    public void setInitialGraphFile(String initialGraphFile) {
        this.initialGraphFile = initialGraphFile;
    }

    public String getInitialToolFile() {
        return this.initialToolFile;
    }

    public void setInitialToolFile(String initialToolFile) {
        this.initialToolFile = initialToolFile;
    }
}

