/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.tooldef;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.codegen.gmfgen.EntryBase;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.ToolEntry;
import org.eclipse.gmf.codegen.gmfgen.ToolGroupItem;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooldef.BundleImage;
import org.eclipse.gmf.tooldef.CreationTool;
import org.eclipse.gmf.tooldef.GenericTool;
import org.eclipse.gmf.tooldef.Palette;
import org.eclipse.gmf.tooldef.PaletteSeparator;
import org.eclipse.gmf.tooldef.StandardTool;
import org.eclipse.gmf.tooldef.ToolContainer;
import org.eclipse.gmf.tooldef.ToolGroup;
import org.eclipse.gmf.tooldef.util.GMFToolSwitch;
import org.osgi.framework.Bundle;

public class PaletteHandler {
    private final HashMap myToolHistory = new HashMap();
    private org.eclipse.gmf.codegen.gmfgen.Palette myGenPalette;
    private org.eclipse.gmf.codegen.gmfgen.ToolGroup myMisreferencedTools;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.tooldef.PaletteHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void initialize(org.eclipse.gmf.codegen.gmfgen.Palette genPalette) {
        if (!$assertionsDisabled && genPalette == null) {
            throw new AssertionError();
        }
        this.myGenPalette = genPalette;
        this.myToolHistory.clear();
    }

    protected final org.eclipse.gmf.codegen.gmfgen.Palette getGenPalette() {
        if (!$assertionsDisabled && !this.isInitialized()) {
            throw new AssertionError();
        }
        return this.myGenPalette;
    }

    protected final boolean isInitialized() {
        return this.myGenPalette != null;
    }

    public void process(Palette palette) {
        if (!this.isInitialized()) {
            return;
        }
        EList groupItems = new ToolSwitch(this.myToolHistory).toGroupItems(palette.getTools());
        BasicEList topLevelTools = new BasicEList();
        Iterator it = groupItems.iterator();
        while (it.hasNext()) {
            ToolGroupItem next = (ToolGroupItem)it.next();
            if (next instanceof org.eclipse.gmf.codegen.gmfgen.ToolGroup) continue;
            it.remove();
            topLevelTools.add((Object)next);
        }
        if (!topLevelTools.isEmpty()) {
            org.eclipse.gmf.codegen.gmfgen.ToolGroup defaultGroup = GMFGenFactory.eINSTANCE.createToolGroup();
            defaultGroup.setTitle("Default");
            defaultGroup.setDescription("Holds top-level non-container tools");
            defaultGroup.setCollapse(false);
            defaultGroup.getEntries().addAll((Collection)topLevelTools);
            this.getGenPalette().getGroups().add((Object)defaultGroup);
        }
        this.getGenPalette().getGroups().addAll((Collection)groupItems);
        if (palette.getDefault() != null) {
            EntryBase eb = (EntryBase)this.myToolHistory.get(palette.getDefault());
            if (!(eb instanceof ToolEntry)) {
                PaletteHandler.logWarning("There's default tool specified for palette, but can't find gmfgen counterpart");
            } else {
                ((ToolEntry)eb).setDefault(true);
            }
        }
        this.getGenPalette().setFlyout(true);
    }

    public void process(NodeMapping nme, GenNode genNode) {
        if (!this.isInitialized() || nme.getTool() == null) {
            return;
        }
        ToolEntry te = this.toToolEntry(nme.getTool());
        if (te != null) {
            te.getGenNodes().add((Object)genNode);
        }
    }

    public void process(LinkMapping lme, GenLink genLink) {
        if (!this.isInitialized() || lme.getTool() == null) {
            return;
        }
        ToolEntry te = this.toToolEntry(lme.getTool());
        if (te != null) {
            te.getGenLinks().add((Object)genLink);
        }
    }

    private ToolEntry toToolEntry(AbstractTool tool) {
        if (PaletteHandler.checkIsContainer(tool)) {
            return null;
        }
        ToolEntry te = this.findToolEntry(tool);
        if (te == null) {
            te = this.createMissingToolEntry(tool);
        }
        return te;
    }

    private static boolean checkIsContainer(AbstractTool tool) {
        if (tool instanceof ToolContainer) {
            PaletteHandler.logWarning("Can't use container here");
            return true;
        }
        return false;
    }

    private ToolEntry findToolEntry(AbstractTool tool) {
        if (!$assertionsDisabled && PaletteHandler.checkIsContainer(tool)) {
            throw new AssertionError();
        }
        return (ToolEntry)this.myToolHistory.get(tool);
    }

    private ToolEntry createMissingToolEntry(AbstractTool tool) {
        ToolEntry t;
        if (!$assertionsDisabled && tool == null) {
            throw new AssertionError();
        }
        if (this.myMisreferencedTools == null) {
            this.myMisreferencedTools = GMFGenFactory.eINSTANCE.createToolGroup();
            this.myMisreferencedTools.setCollapse(false);
            this.myMisreferencedTools.setStack(false);
            this.myMisreferencedTools.setTitle("-- Mis-referenced tools --");
            this.myMisreferencedTools.setDescription("Mapping element referenced tools from palette other than one specified in Mapping instance");
            this.getGenPalette().getGroups().add((Object)this.myMisreferencedTools);
        }
        if ((t = (ToolEntry)new ToolSwitch(this.myToolHistory).doSwitch((EObject)tool)) != null) {
            this.myToolHistory.put(tool, t);
            this.myMisreferencedTools.getEntries().add((Object)t);
        }
        return t;
    }

    private static String constructIconPath(BundleImage icon) {
        if (!$assertionsDisabled && icon == null) {
            throw new AssertionError();
        }
        if (icon.getPath() == null || icon.getPath().trim().length() == 0) {
            return null;
        }
        if (icon.getBundle() == null || icon.getBundle().trim().length() == 0) {
            return new Path(icon.getPath()).makeRelative().toString();
        }
        return new Path(icon.getBundle()).makeAbsolute().append(icon.getPath()).toString();
    }

    private static void logWarning(String message) {
        Bundle b = Platform.getBundle((String)"org.eclipse.gmf.bridge");
        Platform.getLog((Bundle)b).log((IStatus)new Status(2, b.getSymbolicName(), 0, message, null));
    }

    private static class ToolSwitch
    extends GMFToolSwitch {
        private final Map toolHistory;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.tooldef.PaletteHandler$ToolSwitch");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        private ToolSwitch(Map toolMap) {
            if (!$assertionsDisabled && toolMap == null) {
                throw new AssertionError();
            }
            this.toolHistory = toolMap;
        }

        public EList toGroupItems(EList toolDefinitions) {
            if (!$assertionsDisabled && toolDefinitions == null) {
                throw new AssertionError();
            }
            BasicEList rv = new BasicEList();
            Iterator it = toolDefinitions.iterator();
            while (it.hasNext()) {
                EObject next = (EObject)it.next();
                Object value = this.doSwitch(next);
                if (value == null) {
                    PaletteHandler.logWarning("Can't transform '" + next + " to ToolGroupItem");
                    continue;
                }
                this.toolHistory.put(next, value);
                rv.add(value);
            }
            return rv;
        }

        public Object casePaletteSeparator(PaletteSeparator object) {
            return GMFGenFactory.eINSTANCE.createSeparator();
        }

        public Object caseCreationTool(CreationTool tool) {
            ToolEntry ne = GMFGenFactory.eINSTANCE.createToolEntry();
            ToolSwitch.setupCommonToolEntry((EntryBase)ne, (AbstractTool)tool);
            return ne;
        }

        public Object caseStandardTool(StandardTool object) {
            return super.caseStandardTool(object);
        }

        public Object caseGenericTool(GenericTool tool) {
            if (tool.getToolClass() == null) {
                PaletteHandler.logWarning("GenericTool element without a class, no palette entry createed");
                return null;
            }
            ToolEntry ne = GMFGenFactory.eINSTANCE.createToolEntry();
            ne.setQualifiedToolName(tool.getToolClass().getName());
            ToolSwitch.setupCommonToolEntry((EntryBase)ne, (AbstractTool)tool);
            return ne;
        }

        public Object caseToolGroup(ToolGroup toolGroup) {
            org.eclipse.gmf.codegen.gmfgen.ToolGroup tg = GMFGenFactory.eINSTANCE.createToolGroup();
            tg.setCollapse(toolGroup.isCollapsible());
            tg.setStack(false);
            ToolSwitch.setupCommonToolEntry((EntryBase)tg, (AbstractTool)toolGroup);
            tg.getEntries().addAll((Collection)this.toGroupItems(toolGroup.getTools()));
            return tg;
        }

        private static void setupCommonToolEntry(EntryBase te, AbstractTool tool) {
            te.setTitle(tool.getTitle() == null ? "" : tool.getTitle());
            te.setDescription(tool.getDescription());
            if (tool.getLargeIcon() instanceof BundleImage) {
                te.setLargeIconPath(PaletteHandler.constructIconPath((BundleImage)tool.getLargeIcon()));
            }
            if (tool.getSmallIcon() instanceof BundleImage) {
                te.setSmallIconPath(PaletteHandler.constructIconPath((BundleImage)tool.getSmallIcon()));
            }
        }
    }
}

