/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.listener;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.EMFOperationCommand;
import org.eclipse.gmf.runtime.diagram.core.internal.commands.PersistElementCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationPreCommitListener;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationUtil;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramEventBroker
extends ResourceSetListenerImpl {
    private static String LISTEN_TO_ALL_FEATURES = "*";
    private final NotifierToKeyToListenersSetMap preListeners;
    private final NotifierToKeyToListenersSetMap postListeners;
    private static final Map instanceMap = new WeakHashMap();
    private static DiagramEventBrokerFactory debFactory = new DiagramEventBrokerFactoryImpl();
    static /* synthetic */ Class class$0;

    protected DiagramEventBroker() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.ecore.EObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(NotificationFilter.createNotifierTypeFilter((Class)clazz));
        this.preListeners = new NotifierToKeyToListenersSetMap();
        this.postListeners = new NotifierToKeyToListenersSetMap();
    }

    public static DiagramEventBroker getInstance(TransactionalEditingDomain editingDomain) {
        return DiagramEventBroker.initializeDiagramEventBroker(editingDomain);
    }

    public static void startListening(TransactionalEditingDomain editingDomain) {
        DiagramEventBroker.initializeDiagramEventBroker(editingDomain);
    }

    private static DiagramEventBroker initializeDiagramEventBroker(TransactionalEditingDomain editingDomain) {
        WeakReference<DiagramEventBroker> reference = (WeakReference<DiagramEventBroker>)instanceMap.get(editingDomain);
        if (reference == null) {
            DiagramEventBroker diagramEventBroker = debFactory.createDiagramEventBroker(editingDomain);
            editingDomain.addResourceSetListener((ResourceSetListener)diagramEventBroker);
            reference = new WeakReference<DiagramEventBroker>(diagramEventBroker);
            instanceMap.put(editingDomain, reference);
        }
        return (DiagramEventBroker)((Object)reference.get());
    }

    public static void registerDiagramEventBrokerFactory(DiagramEventBrokerFactory newDebFactory) {
        debFactory = newDebFactory;
    }

    public static void stopListening(TransactionalEditingDomain editingDomain) {
        DiagramEventBroker diagramEventBroker = DiagramEventBroker.getInstance(editingDomain);
        if (diagramEventBroker != null) {
            editingDomain.removeResourceSetListener((ResourceSetListener)diagramEventBroker);
            instanceMap.remove(editingDomain);
        }
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) {
        Set deletedObjects = NotificationUtil.getDeletedObjects(event);
        HashSet elementsInPersistQueue = new HashSet();
        CompoundCommand cc = new CompoundCommand();
        Iterator i = event.getNotifications().iterator();
        while (i.hasNext()) {
            Command cmd;
            Object notifier;
            Notification notification = (Notification)i.next();
            if (this.shouldIgnoreNotification(notification) || !((notifier = notification.getNotifier()) instanceof EObject) || deletedObjects.contains(notification.getNotifier()) || (cmd = this.handleTransactionAboutToCommitEvent(notification, elementsInPersistQueue)) == null) continue;
            cc.append(cmd);
        }
        elementsInPersistQueue.clear();
        return cc.isEmpty() ? null : cc;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        Set deletedObjects = NotificationUtil.getDeletedObjects(event);
        Iterator i = event.getNotifications().iterator();
        while (i.hasNext()) {
            Object notifier;
            Notification notification = (Notification)i.next();
            boolean customNotification = NotificationUtil.isCustomNotification(notification);
            if (!customNotification && this.shouldIgnoreNotification(notification) || !((notifier = notification.getNotifier()) instanceof EObject) || deletedObjects.contains(notification.getNotifier()) && !customNotification) continue;
            this.handleElementEvent(notification);
        }
    }

    protected boolean shouldIgnoreNotification(Notification notification) {
        return notification.isTouch() && notification.getEventType() != 9 || NotationPackage.eINSTANCE.getView_Mutable().equals(notification.getFeature());
    }

    private void fireNotification(Notification event) {
        Set listenerList = this.getInterestedNotificationListeners(event, false);
        if (!listenerList.isEmpty()) {
            ArrayList listenersSnapShot = new ArrayList(listenerList);
            if (!listenerList.isEmpty()) {
                Iterator listenerIT = listenersSnapShot.iterator();
                while (listenerIT.hasNext()) {
                    NotificationListener listener = (NotificationListener)listenerIT.next();
                    listener.notifyChanged(event);
                }
            }
        }
    }

    private Command fireTransactionAboutToCommit(Notification event, Set elementsInPersistQueue) {
        Set listenerList = this.getInterestedNotificationListeners(event, true);
        CompoundCommand cc = new CompoundCommand();
        this.preparePersistCommand(event, cc, elementsInPersistQueue);
        if (!listenerList.isEmpty()) {
            ArrayList listenersSnapShot = new ArrayList(listenerList);
            if (!listenerList.isEmpty()) {
                Iterator listenerIT = listenersSnapShot.iterator();
                while (listenerIT.hasNext()) {
                    NotificationPreCommitListener listener = (NotificationPreCommitListener)listenerIT.next();
                    Command cmd = listener.transactionAboutToCommit(event);
                    if (cmd == null) continue;
                    cc.append(cmd);
                }
                return cc.isEmpty() ? null : cc;
            }
        }
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    private void preparePersistCommand(Notification event, CompoundCommand cc, Set elementsInPersistQueue) {
        PersistElementCommand persistCmd = null;
        if (!event.isTouch()) {
            EObject elementToPersist = (EObject)event.getNotifier();
            while (elementToPersist != null && !(elementToPersist instanceof View)) {
                elementToPersist = elementToPersist.eContainer();
            }
            if (elementToPersist != null && !elementsInPersistQueue.contains(elementToPersist) && ViewUtil.isTransient(elementToPersist) && !NotificationFilter.READ.matches(event)) {
                elementsInPersistQueue.add(elementToPersist);
                persistCmd = this.getPersistViewCommand((View)elementToPersist);
            }
        }
        if (persistCmd != null && persistCmd.getEditingDomain() != null) {
            cc.append((Command)new EMFOperationCommand(persistCmd.getEditingDomain(), persistCmd));
        }
    }

    public final void addNotificationListener(EObject target, NotificationPreCommitListener listener) {
        if (target != null) {
            this.preListeners.addListener(target, LISTEN_TO_ALL_FEATURES, listener);
        }
    }

    public final void addNotificationListener(EObject target, NotificationListener listener) {
        if (target != null) {
            this.postListeners.addListener(target, LISTEN_TO_ALL_FEATURES, listener);
        }
    }

    public final void addNotificationListener(EObject target, EStructuralFeature key, NotificationPreCommitListener listener) {
        if (target != null) {
            this.preListeners.addListener(target, key, listener);
        }
    }

    public final void addNotificationListener(EObject target, EStructuralFeature key, NotificationListener listener) {
        if (target != null) {
            this.postListeners.addListener(target, key, listener);
        }
    }

    public final void removeNotificationListener(EObject target, NotificationPreCommitListener listener) {
        if (target != null) {
            this.preListeners.removeListener(target, LISTEN_TO_ALL_FEATURES, listener);
        }
    }

    public final void removeNotificationListener(EObject target, NotificationListener listener) {
        if (target != null) {
            this.postListeners.removeListener(target, LISTEN_TO_ALL_FEATURES, listener);
        }
    }

    public final void removeNotificationListener(EObject target, Object key, NotificationPreCommitListener listener) {
        if (target != null) {
            this.preListeners.removeListener(target, key, listener);
        }
    }

    public final void removeNotificationListener(EObject target, Object key, NotificationListener listener) {
        if (target != null) {
            this.postListeners.removeListener(target, key, listener);
        }
    }

    public final void finalize() {
        try {
            Iterator iter = instanceMap.keySet().iterator();
            while (iter.hasNext()) {
                TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)iter.next();
                editingDomain.removeResourceSetListener((ResourceSetListener)((DiagramEventBroker)((Object)((WeakReference)instanceMap.get(editingDomain)).get())));
            }
        }
        catch (Throwable throwable) {}
    }

    private Set getNotificationListeners(Object notifier, boolean preCommit) {
        NotifierToKeyToListenersSetMap listeners = preCommit ? this.preListeners : this.postListeners;
        return listeners.getListeners(notifier, LISTEN_TO_ALL_FEATURES);
    }

    private Set getNotificationListeners(Object notifier, Object key, boolean preCommit) {
        NotifierToKeyToListenersSetMap listeners;
        NotifierToKeyToListenersSetMap notifierToKeyToListenersSetMap = listeners = preCommit ? this.preListeners : this.postListeners;
        if (key != null) {
            if (!key.equals(LISTEN_TO_ALL_FEATURES)) {
                HashSet listenersSet = new HashSet();
                Set c = listeners.getListeners(notifier, key);
                if (c != null && !c.isEmpty()) {
                    listenersSet.addAll(c);
                }
                if ((c = listeners.getListeners(notifier, LISTEN_TO_ALL_FEATURES)) != null && !c.isEmpty()) {
                    listenersSet.addAll(c);
                }
                return listenersSet;
            }
            if (key.equals(LISTEN_TO_ALL_FEATURES)) {
                return listeners.getAllListeners(notifier);
            }
        }
        return listeners.getAllListeners(notifier);
    }

    protected final Set getInterestedNotificationListeners(Notification event, boolean preCommit) {
        HashSet listenerSet = new HashSet();
        Set c = this.getNotificationListeners(event.getNotifier(), event.getFeature(), preCommit);
        if (c != null) {
            listenerSet.addAll(c);
        }
        EObject notifier = (EObject)event.getNotifier();
        if (NotationPackage.eINSTANCE.getView_Visible().equals(event.getFeature()) && notifier.eContainer() != null) {
            listenerSet.addAll(this.getNotificationListeners(notifier.eContainer(), preCommit));
        } else if (notifier instanceof EAnnotation) {
            this.addListenersOfNotifier(listenerSet, notifier.eContainer(), event, preCommit);
        } else if (!(notifier instanceof View)) {
            while (notifier != null && !(notifier instanceof View)) {
                notifier = notifier.eContainer();
            }
            this.addListenersOfNotifier(listenerSet, notifier, event, preCommit);
        }
        return listenerSet;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    private void addListenersOfNotifier(Set listenerSet, EObject notifier, Notification event, boolean preCommit) {
        Set c;
        if (notifier != null && (c = this.getNotificationListeners(notifier, event.getFeature(), preCommit)) != null) {
            if (listenerSet.isEmpty()) {
                listenerSet.addAll(c);
            } else {
                Iterator i = c.iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    listenerSet.add(o);
                }
            }
        }
    }

    private Command handleTransactionAboutToCommitEvent(Notification event, Set elementsInPersistQueue) {
        EObject element = (EObject)event.getNotifier();
        if (element != null) {
            return this.fireTransactionAboutToCommit(event, elementsInPersistQueue);
        }
        return null;
    }

    private void handleElementEvent(Notification event) {
        EObject element = (EObject)event.getNotifier();
        if (element != null) {
            this.fireNotification(event);
        }
    }

    private PersistElementCommand getPersistViewCommand(View view) {
        PersistElementCommand pvc = null;
        if (!view.isMutable()) {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)view);
            View viewToPersist = ViewUtil.getTopViewToPersist(view);
            if (viewToPersist != null) {
                pvc = new PersistElementCommand(editingDomain, viewToPersist);
            }
        }
        return pvc;
    }

    private final class NotifierToKeyToListenersSetMap {
        private final Map listenersMap = new WeakHashMap();

        private NotifierToKeyToListenersSetMap() {
        }

        public void addListener(EObject notifier, Object key, Object listener) {
            HashSet<Object> listenersSet;
            HashMap<Object, HashSet<Object>> keys = (HashMap<Object, HashSet<Object>>)this.listenersMap.get(notifier);
            if (keys == null) {
                keys = new HashMap<Object, HashSet<Object>>(4);
                this.listenersMap.put(notifier, keys);
            }
            if ((listenersSet = (HashSet<Object>)keys.get(key)) == null) {
                listenersSet = new HashSet<Object>(4);
                keys.put(key, listenersSet);
            }
            listenersSet.add(listener);
        }

        public void addListener(EObject notifier, Object listener) {
            this.addListener(notifier, LISTEN_TO_ALL_FEATURES, listener);
        }

        public void removeListener(EObject notifier, Object key, Object listener) {
            Map keys = (Map)this.listenersMap.get(notifier);
            if (keys != null) {
                Set listenersSet = (Set)keys.get(key);
                if (listenersSet != null) {
                    listenersSet.remove(listener);
                    if (listenersSet.isEmpty()) {
                        keys.remove(key);
                    }
                }
                if (keys.isEmpty()) {
                    this.listenersMap.remove(notifier);
                }
            }
        }

        public Set getListeners(Object notifier, Object key) {
            Set listenersSet;
            Map keys = (Map)this.listenersMap.get(notifier);
            if (keys != null && (listenersSet = (Set)keys.get(key)) != null) {
                return listenersSet;
            }
            return Collections.EMPTY_SET;
        }

        public Set getAllListeners(Object notifier) {
            Map keys = (Map)this.listenersMap.get(notifier);
            if (keys == null || keys.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            HashSet listenersCollection = new HashSet();
            Set enteries = keys.entrySet();
            Iterator iter = enteries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Set listenersSet = (Set)entry.getValue();
                if (listenersSet == null || listenersSet.isEmpty()) continue;
                listenersCollection.addAll(listenersSet);
            }
            return listenersCollection;
        }
    }

    public static interface DiagramEventBrokerFactory {
        public DiagramEventBroker createDiagramEventBroker(TransactionalEditingDomain var1);
    }

    private static class DiagramEventBrokerFactoryImpl
    implements DiagramEventBrokerFactory {
        private DiagramEventBrokerFactoryImpl() {
        }

        public DiagramEventBroker createDiagramEventBroker(TransactionalEditingDomain editingDomain) {
            return new DiagramEventBroker();
        }
    }
}

