/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public abstract class AttachShapeAction
extends DiagramAction {
    static /* synthetic */ Class class$0;

    public AttachShapeAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    protected void selectAddedObject(EditPartViewer viewer, CreateRequest request) {
        Object model = request.getNewObject();
        if (model == null || !(model instanceof Collection)) {
            return;
        }
        Iterator models = ((Collection)model).iterator();
        final ArrayList editparts = new ArrayList();
        while (models.hasNext()) {
            Object editPart;
            IAdaptable viewAdapter = (IAdaptable)models.next();
            if (viewAdapter == null) continue;
            Map map = viewer.getEditPartRegistry();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.gmf.runtime.notation.View");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((editPart = map.get(viewAdapter.getAdapter((Class)clazz))) == null) continue;
            editparts.add(editPart);
        }
        if (!editparts.isEmpty()) {
            viewer.setSelection((ISelection)new StructuredSelection(editparts));
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    EditPart editPart = (EditPart)editparts.get(0);
                    editPart.performRequest(new Request((Object)"direct edit"));
                }
            });
        }
    }

    protected Point getLocation(List editParts) {
        Point referenceLocation = new Point(0, 0);
        Rect compoundBounds = new Rect(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        int i = 0;
        while (i < editParts.size()) {
            GraphicalEditPart part = (GraphicalEditPart)editParts.get(i);
            Rectangle bounds = null;
            bounds = part.getFigure() instanceof PolylineConnectionEx ? ((PolylineConnectionEx)part.getFigure()).getSimpleBounds() : part.getFigure().getBounds();
            compoundBounds = this.compoundRectangle(compoundBounds, bounds);
            ++i;
        }
        referenceLocation = new Point((compoundBounds.x1 + compoundBounds.x2) / 2, compoundBounds.y1);
        GraphicalEditPart part = (GraphicalEditPart)editParts.get(0);
        int vertOffset = MapModeUtil.getMapMode((IFigure)part.getFigure()).DPtoLP(100);
        Point location = new Point();
        location.x = referenceLocation.x;
        location.y = referenceLocation.y - vertOffset;
        if (location.y < 0 && part.getParent() instanceof ShapeCompartmentEditPart) {
            location.y = referenceLocation.y;
            location.x = part.getFigure().getBounds().getRight().x + vertOffset;
        }
        part.getFigure().translateToAbsolute((Translatable)location);
        return location;
    }

    private Rect compoundRectangle(Rect base, Rectangle added) {
        if (added == null) {
            return base;
        }
        if (added.x + added.width > base.x2) {
            base.x2 = added.x + added.width;
        }
        if (added.y + added.height > base.y2) {
            base.y2 = added.y + added.height;
        }
        if (added.x < base.x1) {
            base.x1 = added.x;
        }
        if (added.y < base.y1) {
            base.y1 = added.y;
        }
        return base;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected EditPart getContainer(EditPart editPart) {
        EditPart walker = editPart;
        while (walker != null && (walker instanceof ShapeEditPart || walker instanceof ConnectionEditPart)) {
            walker = walker.getParent();
        }
        if (walker instanceof RootEditPart) {
            return ((RootEditPart)walker).getContents();
        }
        return walker;
    }

    private class Rect {
        public int x1;
        public int y1;
        public int x2;
        public int y2;

        Rect(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle toRectangle() {
            return new Rectangle(this.x1, this.y1, this.x2 - this.x1 + 1, this.y2 - this.y1 + 1);
        }
    }
}

