/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.common.ui.action.ActionManager;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorWithFlyOutPalette;
import org.eclipse.gmf.runtime.diagram.ui.properties.views.PropertiesBrowserPage;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DocumentProviderRegistry;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentEditor;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IElementStateListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.MEditingDomainElement;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.l10n.EditorMessages;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.palette.EditorInputPaletteContent;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.osgi.framework.Bundle;

public class DiagramDocumentEditor
extends DiagramEditorWithFlyOutPalette
implements IDocumentEditor,
IReusableEditor {
    private int fErrorCorrectionOnSave;
    private ActivationListener fActivationListener;
    protected final String fErrorLabel = EditorMessages.Editor_statusline_error_label;
    private IElementStateListener fElementStateListener = new ElementStateListener();
    private IDocumentProvider fExplicitDocumentProvider;
    private boolean fIsSanityCheckEnabled = true;
    private boolean fIsStateValidationEnabled = true;
    private long fModificationStamp = -1L;
    private Image fTitleImage;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DiagramDocumentEditor(boolean hasFlyoutPalette) {
        super(hasFlyoutPalette);
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return new PropertiesBrowserPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(type);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                DiagramDocumentEditor.this.getDocumentProvider().setProgressMonitor(monitor);
            }
        };
        try {
            this.getSite().getWorkbenchWindow().run(false, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof CoreException) {
                CoreException e = (CoreException)t;
                IStatus status = e.getStatus();
                if (status.getException() != null) {
                    throw new PartInitException(status);
                }
                throw new PartInitException((IStatus)new Status(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), t));
            }
            throw new PartInitException((IStatus)new Status(4, EditorPlugin.getPluginId(), 0, EditorMessages.Editor_error_init, t));
        }
    }

    protected final void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        this.fActivationListener = new ActivationListener(site.getWorkbenchWindow().getPartService());
        this.fActivationListener.activate();
    }

    public void dispose() {
        if (this.fActivationListener != null) {
            this.fActivationListener.deactivate();
            this.fActivationListener.dispose();
            this.fActivationListener = null;
        }
        if (this.fTitleImage != null) {
            this.fTitleImage.dispose();
            this.fTitleImage = null;
        }
        this.disposeDocumentProvider();
        super.setInput(null);
        super.dispose();
    }

    public Diagram getDiagram() {
        IDiagramDocument document;
        if (this.getDocumentProvider() != null && (document = (IDiagramDocument)this.getDocumentProvider().getDocument(this.getEditorInput())) != null) {
            return document.getDiagram();
        }
        return null;
    }

    public IDiagramDocument getDiagramDocument() {
        return (IDiagramDocument)this.getDocumentProvider().getDocument(this.getEditorInput());
    }

    public boolean askUserSaveOverwrite() {
        String title = DiagramUIMessages.DiagramEditor_save_outofsync_dialog_title;
        String msg = DiagramUIMessages.DiagramEditor_save_outofsync_dialog_message;
        Shell shell = this.getSite().getShell();
        return MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg);
    }

    public int askUserSaveClose() {
        String title = DiagramUIMessages.DiagramEditor_handleDeleteEvent_dialog_title;
        String message = DiagramUIMessages.DiagramEditor_handleDeleteEvent_dialog_message;
        String[] buttons = new String[]{DiagramUIMessages.DiagramEditor_handleDeleteEvent_dialog_button_save, DiagramUIMessages.DiagramEditor_handleDeleteEvent_dialog_button_close};
        MessageDialog dialog = new MessageDialog(this.getSite().getShell(), title, null, message, 3, buttons, 0);
        return dialog.open();
    }

    public boolean askUserReload() {
        String title = DiagramUIMessages.DiagramEditor_activated_outofsync_dialog_title;
        String msg = DiagramUIMessages.DiagramEditor_activated_outofsync_dialog_message;
        Shell shell = this.getSite().getShell();
        return MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg);
    }

    protected void configureDiagramEditDomain() {
        super.configureDiagramEditDomain();
        DiagramEditDomain editDomain = (DiagramEditDomain)this.getDiagramEditDomain();
        editDomain.setActionManager(this.createActionManager());
    }

    protected ActionManager createActionManager() {
        return new ActionManager(this.createOperationHistory());
    }

    protected IOperationHistory createOperationHistory() {
        return OperationHistoryFactory.getOperationHistory();
    }

    protected Object getDefaultPaletteContent() {
        EditorInputPaletteContent defPaletteContent = null;
        if (this.getDiagram() != null) {
            defPaletteContent = new EditorInputPaletteContent(this.getEditorInput(), this.getDiagramDocument());
        }
        return defPaletteContent;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
    }

    public IDocumentProvider getDocumentProvider() {
        return this.fExplicitDocumentProvider;
    }

    protected void setDocumentProvider(IDocumentProvider provider) {
        if (!$assertionsDisabled && provider == null) {
            throw new AssertionError();
        }
        this.fExplicitDocumentProvider = provider;
    }

    public boolean isEditable() {
        IDocumentProvider provider = this.getDocumentProvider();
        return provider.isModifiable(this.getEditorInput());
    }

    protected void setDocumentProvider(IEditorInput input) {
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider(input, new DocumentProviderRegistry.IDocumentProviderSelector(){

            public boolean select(String documentType) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return documentType.equals(clazz.getName());
            }
        });
        this.setDocumentProvider(provider);
    }

    protected IDocumentProvider getDocumentProvider(IEditorInput input) {
        IDocumentProvider provider = DocumentProviderRegistry.getDefault().getDocumentProvider(input, new DocumentProviderRegistry.IDocumentProviderSelector(){

            public boolean select(String documentType) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return documentType.equals(clazz.getName());
            }
        });
        return provider;
    }

    private void updateDocumentProvider(IEditorInput input) {
        IProgressMonitor rememberedProgressMonitor = null;
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            provider.removeElementStateListener(this.fElementStateListener);
            rememberedProgressMonitor = provider.getProgressMonitor();
            provider.setProgressMonitor(null);
        }
        this.setDocumentProvider(input);
        provider = this.getDocumentProvider();
        if (provider != null) {
            provider.addElementStateListener(this.fElementStateListener);
            provider.setProgressMonitor(rememberedProgressMonitor);
        }
    }

    protected void releaseInput() {
        this.getCommandStack().flush();
        this.clearGraphicalViewerContents();
    }

    public void setInput(IEditorInput input) {
        try {
            this.doSetInput(input, true);
        }
        catch (CoreException x) {
            String title = EditorMessages.Editor_error_setinput_title;
            String msg = EditorMessages.Editor_error_setinput_message;
            Shell shell = this.getSite().getShell();
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
        }
    }

    public void doSetInput(IEditorInput input, boolean releaseEditorContents) throws CoreException {
        if (input == null) {
            this.close(this.isSaveOnCloseNeeded());
        } else {
            IEditorInput oldInput;
            block10: {
                oldInput = this.getEditorInput();
                if (oldInput != null) {
                    this.getDocumentProvider().disconnect(oldInput);
                    if (releaseEditorContents) {
                        this.releaseInput();
                    }
                }
                this.updateDocumentProvider(input);
                IDocumentProvider provider = this.getDocumentProvider();
                if (provider == null || !(provider instanceof IDiagramDocumentProvider)) {
                    Status s = new Status(4, EditorPlugin.getPluginId(), 0, EditorMessages.Editor_error_no_provider, null);
                    throw new CoreException((IStatus)s);
                }
                if (!(input instanceof MEditingDomainElement)) {
                    input = ((IDiagramDocumentProvider)((Object)provider)).createInputWithEditingDomain(input, this.createEditingDomain());
                }
                provider.connect(input);
                try {
                    super.setInput(input);
                }
                catch (Throwable throwable) {
                    if (this.getDiagram() != null) break block10;
                    IStatus status = provider.getStatus(input);
                    if (status != null) {
                        throw new CoreException(status);
                    }
                    Status s = new Status(4, EditorPlugin.getPluginId(), 0, EditorMessages.Editor_error_init, null);
                    throw new CoreException((IStatus)s);
                }
            }
            this.initializeTitle(input);
            if (oldInput != null && releaseEditorContents) {
                this.initializeGraphicalViewerContents();
            }
        }
        this.firePropertyChange(258);
    }

    public void close(final boolean save) {
        this.enableSanityChecking(false);
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (DiagramDocumentEditor.this.getGraphicalViewer() != null) {
                    DiagramDocumentEditor.this.getSite().getPage().closeEditor((IEditorPart)DiagramDocumentEditor.this, save);
                }
            }
        });
    }

    protected void disposeDocumentProvider() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            IEditorInput input = this.getEditorInput();
            if (input != null) {
                provider.disconnect(input);
            }
            if (this.fElementStateListener != null) {
                provider.removeElementStateListener(this.fElementStateListener);
                this.fElementStateListener = null;
            }
            this.fExplicitDocumentProvider = null;
        }
    }

    protected IProgressMonitor getProgressMonitor() {
        IProgressMonitor pm = null;
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            pm = manager.getProgressMonitor();
        }
        return pm != null ? pm : new NullProgressMonitor();
    }

    protected void handleEditorInputChanged() {
        block12: {
            Shell shell = this.getSite().getShell();
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider == null) {
                this.close(false);
                return;
            }
            IEditorInput input = this.getEditorInput();
            if (provider.isDeleted(input)) {
                if (this.isSaveAsAllowed()) {
                    String title = EditorMessages.Editor_error_activated_deleted_save_title;
                    String msg = EditorMessages.Editor_error_activated_deleted_save_message;
                    String[] buttons = new String[]{EditorMessages.Editor_error_activated_deleted_save_button_save, EditorMessages.Editor_error_activated_deleted_save_button_close};
                    MessageDialog dialog = new MessageDialog(shell, title, null, msg, 3, buttons, 0);
                    if (dialog.open() == 0) {
                        IProgressMonitor pm = this.getProgressMonitor();
                        this.performSaveAs(pm);
                        if (pm.isCanceled()) {
                            this.handleEditorInputChanged();
                        }
                    } else {
                        this.close(false);
                    }
                } else {
                    String title = EditorMessages.Editor_error_activated_deleted_close_title;
                    String msg = EditorMessages.Editor_error_activated_deleted_close_message;
                    if (MessageDialog.openConfirm((Shell)shell, (String)title, (String)msg)) {
                        this.close(false);
                    }
                }
            } else {
                String title = EditorMessages.Editor_error_activated_outofsync_title;
                String msg = EditorMessages.Editor_error_activated_outofsync_message;
                if (MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg)) {
                    try {
                        provider.synchronize(input);
                    }
                    catch (CoreException x) {
                        IStatus status = x.getStatus();
                        if (status != null && status.getSeverity() == 8) break block12;
                        title = EditorMessages.Editor_error_refresh_outofsync_title;
                        msg = EditorMessages.Editor_error_refresh_outofsync_message;
                        ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
                    }
                }
            }
        }
    }

    public void doSaveAs() {
        this.performSaveAs(this.getProgressMonitor());
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p.isDeleted(this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                String title = EditorMessages.Editor_error_save_deleted_title;
                String msg = EditorMessages.Editor_error_save_deleted_message;
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        } else {
            this.updateState(this.getEditorInput());
            this.validateState(this.getEditorInput());
            this.performSave(false, progressMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableSanityChecking(boolean enable) {
        DiagramDocumentEditor diagramDocumentEditor = this;
        synchronized (diagramDocumentEditor) {
            this.fIsSanityCheckEnabled = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void safelySanityCheckState(IEditorInput input) {
        boolean enabled = false;
        DiagramDocumentEditor diagramDocumentEditor = this;
        synchronized (diagramDocumentEditor) {
            enabled = this.fIsSanityCheckEnabled;
        }
        if (enabled) {
            this.sanityCheckState(input);
        }
    }

    protected void sanityCheckState(IEditorInput input) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        long stamp = p.getModificationStamp(input);
        if (stamp != this.fModificationStamp) {
            this.fModificationStamp = stamp;
            if (!p.isSynchronized(input)) {
                this.handleEditorInputChanged();
            }
        }
        this.updateState(this.getEditorInput());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableStateValidation(boolean enable) {
        DiagramDocumentEditor diagramDocumentEditor = this;
        synchronized (diagramDocumentEditor) {
            this.fIsStateValidationEnabled = enable;
        }
    }

    protected void validateState(IEditorInput input) {
        IDocumentProvider provider = this.getDocumentProvider();
        try {
            provider.validateState(input, this.getSite().getShell());
        }
        catch (CoreException x) {
            IStatus status = x.getStatus();
            if (status == null || status.getSeverity() != 8) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
                ILog log = Platform.getLog((Bundle)bundle);
                log.log(x.getStatus());
                Shell shell = this.getSite().getShell();
                String title = EditorMessages.Editor_error_validateEdit_title;
                String msg = EditorMessages.Editor_error_validateEdit_message;
                ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
            }
            return;
        }
        if (this.getDiagramEditPart() != null) {
            if (this.isEditable()) {
                this.getDiagramEditPart().enableEditMode();
            } else {
                this.getDiagramEditPart().disableEditMode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateEditorInputState() {
        boolean enabled = false;
        DiagramDocumentEditor diagramDocumentEditor = this;
        synchronized (diagramDocumentEditor) {
            enabled = this.fIsStateValidationEnabled;
        }
        if (enabled) {
            GraphicalViewer viewer = this.getGraphicalViewer();
            if (viewer == null) {
                return false;
            }
            final IEditorInput input = this.getEditorInput();
            BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    DiagramDocumentEditor.this.validateState(input);
                }
            });
            this.sanityCheckState(input);
            return !this.isEditorInputReadOnly();
        }
        return !this.isEditorInputReadOnly();
    }

    protected void updateState(IEditorInput input) {
        IDocumentProvider provider = this.getDocumentProvider();
        try {
            provider.updateStateCache(input);
            if (this.getDiagramEditPart() != null) {
                if (this.isEditable()) {
                    this.getDiagramEditPart().enableEditMode();
                } else {
                    this.getDiagramEditPart().disableEditMode();
                }
            }
        }
        catch (CoreException x) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            ILog log = Platform.getLog((Bundle)bundle);
            log.log(x.getStatus());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        try {
            try {
                provider.aboutToChange(this.getEditorInput());
                IEditorInput input = this.getEditorInput();
                provider.saveDocument(progressMonitor, input, this.getDocumentProvider().getDocument(input), overwrite);
                this.editorSaved();
            }
            catch (CoreException x) {
                IStatus status = x.getStatus();
                if (status == null || status.getSeverity() != 8) {
                    this.handleExceptionOnSave(x, progressMonitor);
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            provider.changed(this.getEditorInput());
            throw throwable;
        }
        {
            Object var6_9 = null;
            provider.changed(this.getEditorInput());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleExceptionOnSave(CoreException exception, IProgressMonitor progressMonitor) {
        try {
            block8: {
                Shell shell;
                block7: {
                    ++this.fErrorCorrectionOnSave;
                    shell = this.getSite().getShell();
                    boolean isSynchronized = false;
                    IDocumentProvider p = this.getDocumentProvider();
                    isSynchronized = p.isSynchronized(this.getEditorInput());
                    if (!this.isNotSynchronizedException(exception) || this.fErrorCorrectionOnSave != 1 || isSynchronized) break block7;
                    String title = EditorMessages.Editor_error_save_outofsync_title;
                    String msg = EditorMessages.Editor_error_save_outofsync_message;
                    if (MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg)) {
                        this.performSave(true, progressMonitor);
                        break block8;
                    } else if (progressMonitor != null) {
                        progressMonitor.setCanceled(true);
                    }
                    break block8;
                }
                String title = EditorMessages.Editor_error_save_title;
                String msg = EditorMessages.Editor_error_save_message;
                ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)exception.getStatus());
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
            }
            Object var8_12 = null;
            --this.fErrorCorrectionOnSave;
            return;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            --this.fErrorCorrectionOnSave;
            throw throwable;
        }
    }

    private boolean isNotSynchronizedException(CoreException ex) {
        if (ex == null) {
            return false;
        }
        IStatus status = ex.getStatus();
        if (status == null || status instanceof MultiStatus) {
            return false;
        }
        if (status.getException() != null) {
            return false;
        }
        return status.getCode() == 274;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        IDocumentProvider p = this.getDocumentProvider();
        return p == null ? false : p.canSaveDocument(this.getEditorInput());
    }

    protected void handleElementContentReplaced() {
        this.initializeGraphicalViewerContents();
    }

    protected void handleElementContentAboutToBeReplaced() {
        this.releaseInput();
    }

    private IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (!(contributor instanceof EditorActionBarContributor)) {
            return null;
        }
        IActionBars actionBars = ((EditorActionBarContributor)contributor).getActionBars();
        if (actionBars == null) {
            return null;
        }
        return actionBars.getStatusLineManager();
    }

    protected void editorSaved() {
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    public boolean isEditorInputReadOnly() {
        IDocumentProvider provider = this.getDocumentProvider();
        return provider.isReadOnly(this.getEditorInput());
    }

    public boolean isEditorInputModifiable() {
        IDocumentProvider provider = this.getDocumentProvider();
        return provider.isModifiable(this.getEditorInput());
    }

    private void initializeTitle(IEditorInput input) {
        Image oldImage = this.fTitleImage;
        this.fTitleImage = null;
        String title = "";
        if (input != null) {
            IEditorDescriptor editorDesc = this.getEditorDescriptor();
            ImageDescriptor imageDesc = editorDesc != null ? editorDesc.getImageDescriptor() : null;
            this.fTitleImage = imageDesc != null ? imageDesc.createImage() : null;
            title = input.getName();
        }
        this.setTitleImage(this.fTitleImage);
        this.setPartName(title);
        this.firePropertyChange(257);
        if (oldImage != null && !oldImage.isDisposed()) {
            oldImage.dispose();
        }
    }

    protected final IEditorDescriptor getEditorDescriptor() {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = editorRegistry.findEditor(this.getSite().getId());
        return editorDesc;
    }

    public void createPartControl(Composite parent) {
        IDocumentProvider provider = this.getDocumentProvider();
        IStatus status = provider.getStatus(this.getEditorInput());
        if (status != null && !status.isOK()) {
            throw new RuntimeException(new CoreException(status));
        }
        super.createPartControl(parent);
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.getEditorInput() instanceof MEditingDomainElement ? ((MEditingDomainElement)this.getEditorInput()).getEditingDomain() : super.getEditingDomain();
    }

    protected TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain editingDomain;
        String editingDomainID = this.getEditingDomainID();
        if (editingDomainID != null && (editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(editingDomainID)) != null) {
            return editingDomain;
        }
        return DiagramEditingDomainFactory.getInstance().createEditingDomain();
    }

    protected String getEditingDomainID() {
        return null;
    }

    class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;
        private IPartService fPartService;

        public ActivationListener(IPartService partService) {
            this.fPartService = partService;
        }

        public void dispose() {
            this.fPartService = null;
        }

        public void activate() {
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void deactivate() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleActivation() {
            if (this.fIsHandlingActivation) {
                return;
            }
            if (this.fActivePart != DiagramDocumentEditor.this) return;
            this.fIsHandlingActivation = true;
            try {
                DiagramDocumentEditor.this.safelySanityCheckState(DiagramDocumentEditor.this.getEditorInput());
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.fIsHandlingActivation = false;
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.fIsHandlingActivation = false;
                return;
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == DiagramDocumentEditor.this.getEditorSite().getWorkbenchWindow()) {
                window.getShell().getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ ActivationListener this$1;
                    {
                        this.this$1 = activationListener;
                    }

                    public void run() {
                        ActivationListener.access$0(this.this$1);
                    }
                });
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        static /* synthetic */ void access$0(ActivationListener activationListener) {
            activationListener.handleActivation();
        }
    }

    class ElementStateListener
    implements IElementStateListener {
        private Display fDisplay;

        ElementStateListener() {
        }

        public void elementStateValidationChanged(Object element, boolean isStateValidated) {
            if (element != null && element.equals(DiagramDocumentEditor.this.getEditorInput())) {
                Runnable r = new Runnable(this, isStateValidated){
                    final /* synthetic */ ElementStateListener this$1;
                    private final /* synthetic */ boolean val$isStateValidated;
                    {
                        this.this$1 = elementStateListener;
                        this.val$isStateValidated = bl;
                    }

                    public void run() {
                        ElementStateListener.access$1(this.this$1).enableSanityChecking(true);
                        if (this.val$isStateValidated) {
                            GraphicalViewer viewer = DiagramDocumentEditor.access$0(ElementStateListener.access$1(this.this$1));
                            if (viewer != null) {
                                ElementStateListener.access$1(this.this$1).enableStateValidation(false);
                            }
                        } else {
                            GraphicalViewer viewer = DiagramDocumentEditor.access$0(ElementStateListener.access$1(this.this$1));
                            if (viewer != null) {
                                ElementStateListener.access$1(this.this$1).enableStateValidation(true);
                            }
                        }
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            if (element != null && element.equals(DiagramDocumentEditor.this.getEditorInput())) {
                Runnable r = new Runnable(this){
                    final /* synthetic */ ElementStateListener this$1;
                    {
                        this.this$1 = elementStateListener;
                    }

                    public void run() {
                        ElementStateListener.access$1(this.this$1).enableSanityChecking(true);
                        ElementStateListener.access$1(this.this$1).firePropertyChange(257);
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementContentAboutToBeReplaced(Object element) {
            if (element != null && element.equals(DiagramDocumentEditor.this.getEditorInput())) {
                Runnable r = new Runnable(this){
                    final /* synthetic */ ElementStateListener this$1;
                    {
                        this.this$1 = elementStateListener;
                    }

                    public void run() {
                        ElementStateListener.access$1(this.this$1).enableSanityChecking(true);
                        ElementStateListener.access$1(this.this$1).handleElementContentAboutToBeReplaced();
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementContentReplaced(Object element) {
            if (element != null && element.equals(DiagramDocumentEditor.this.getEditorInput())) {
                Runnable r = new Runnable(this){
                    final /* synthetic */ ElementStateListener this$1;
                    {
                        this.this$1 = elementStateListener;
                    }

                    public void run() {
                        ElementStateListener.access$1(this.this$1).enableSanityChecking(true);
                        ElementStateListener.access$1(this.this$1).firePropertyChange(257);
                        ElementStateListener.access$1(this.this$1).handleElementContentReplaced();
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementDeleted(Object deletedElement) {
            if (deletedElement != null && deletedElement.equals(DiagramDocumentEditor.this.getEditorInput())) {
                Runnable r = new Runnable(this){
                    final /* synthetic */ ElementStateListener this$1;
                    {
                        this.this$1 = elementStateListener;
                    }

                    public void run() {
                        ElementStateListener.access$1(this.this$1).enableSanityChecking(true);
                        ElementStateListener.access$1(this.this$1).close(false);
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementMoved(Object originalElement, Object movedElement) {
            if (originalElement != null && originalElement.equals(DiagramDocumentEditor.this.getEditorInput())) {
                boolean doValidationAsync = Display.getCurrent() != null;
                Runnable r = new Runnable(this, originalElement, movedElement, doValidationAsync){
                    final /* synthetic */ ElementStateListener this$1;
                    private final /* synthetic */ Object val$originalElement;
                    private final /* synthetic */ Object val$movedElement;
                    private final /* synthetic */ boolean val$doValidationAsync;
                    {
                        this.this$1 = elementStateListener;
                        this.val$originalElement = object;
                        this.val$movedElement = object2;
                        this.val$doValidationAsync = bl;
                    }

                    public void run() {
                        ElementStateListener.access$1(this.this$1).enableSanityChecking(true);
                        if (DiagramDocumentEditor.access$0(ElementStateListener.access$1(this.this$1)) == null) {
                            return;
                        }
                        if (!this.this$1.canHandleMove((IEditorInput)this.val$originalElement, (IEditorInput)this.val$movedElement)) {
                            ElementStateListener.access$1(this.this$1).close(true);
                            return;
                        }
                        if (this.val$movedElement == null || this.val$movedElement instanceof IEditorInput) {
                            IDocumentProvider d = ElementStateListener.access$1(this.this$1).getDocumentProvider();
                            IDocument changed = null;
                            IEditorInput oldInput = ElementStateListener.access$1(this.this$1).getEditorInput();
                            Object previousContent = ElementStateListener.access$1(this.this$1).isDirty() ? ((changed = d.getDocument(oldInput)) != null ? (changed instanceof IDiagramDocument ? ((IDiagramDocument)changed).detachDiagram() : changed.getContent()) : null) : null;
                            try {
                                ElementStateListener.access$1(this.this$1).doSetInput((IEditorInput)this.val$movedElement, changed == null);
                            }
                            catch (CoreException e) {
                                String title = EditorMessages.Editor_error_setinput_title;
                                String msg = EditorMessages.Editor_error_setinput_message;
                                Shell shell = ElementStateListener.access$1(this.this$1).getSite().getShell();
                                ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)e.getStatus());
                            }
                            if (changed != null) {
                                Runnable r2 = new Runnable(this, previousContent){
                                    final /* synthetic */ 7 this$2;
                                    private final /* synthetic */ Object val$previousContent;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$previousContent = object;
                                    }

                                    public void run() {
                                        ElementStateListener.access$1(7.access$0(this.this$2)).validateState(ElementStateListener.access$1(7.access$0(this.this$2)).getEditorInput());
                                        ElementStateListener.access$1(7.access$0(this.this$2)).getDocumentProvider().getDocument(ElementStateListener.access$1(7.access$0(this.this$2)).getEditorInput()).setContent(this.val$previousContent);
                                    }
                                };
                                ElementStateListener.access$0(this.this$1, r2, this.val$doValidationAsync);
                            }
                        }
                    }

                    static /* synthetic */ ElementStateListener access$0(7 var0) {
                        return var0.this$1;
                    }
                };
                this.execute(r, false);
            }
        }

        protected boolean canHandleMove(IEditorInput originalElement, IEditorInput movedElement) {
            return true;
        }

        public void elementStateChanging(Object element) {
            if (element != null && element.equals(DiagramDocumentEditor.this.getEditorInput())) {
                DiagramDocumentEditor.this.enableSanityChecking(false);
            }
        }

        public void elementStateChangeFailed(Object element) {
            if (element != null && element.equals(DiagramDocumentEditor.this.getEditorInput())) {
                DiagramDocumentEditor.this.enableSanityChecking(true);
            }
        }

        private void execute(Runnable runnable, boolean postAsync) {
            if (postAsync || Display.getCurrent() == null) {
                if (this.fDisplay == null) {
                    this.fDisplay = DiagramDocumentEditor.this.getSite().getShell().getDisplay();
                }
                this.fDisplay.asyncExec(runnable);
            } else {
                runnable.run();
            }
        }

        static /* synthetic */ void access$0(ElementStateListener elementStateListener, Runnable runnable, boolean bl) {
            elementStateListener.execute(runnable, bl);
        }

        static /* synthetic */ DiagramDocumentEditor access$1(ElementStateListener elementStateListener) {
            return elementStateListener.DiagramDocumentEditor.this;
        }
    }
}

