/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.figures;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.jface.util.Assert;

public class BorderItemLocator
implements IBorderItemLocator {
    private IFigure parentFigure = null;
    private Rectangle constraint = new Rectangle(0, 0, 0, 0);
    private Dimension borderItemOffset = new Dimension(1, 1);
    private int preferredSide = 8;
    private int currentSide = 8;

    protected Rectangle getConstraint() {
        return this.constraint;
    }

    public BorderItemLocator(IFigure parentFigure) {
        Assert.isNotNull((Object)parentFigure);
        this.parentFigure = parentFigure;
    }

    public BorderItemLocator(IFigure parentFigure, int preferredSide) {
        this(parentFigure);
        this.preferredSide = preferredSide;
    }

    public BorderItemLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        this(parentFigure);
        this.setConstraint(constraint);
    }

    public void setConstraint(Rectangle theConstraint) {
        this.constraint = theConstraint;
        if (theConstraint.getTopLeft().x == 0 || theConstraint.getTopLeft().y == 0) {
            this.setCurrentSideOfParent(this.getPreferredSideOfParent());
        }
        this.getParentFigure().revalidate();
    }

    protected Point getPreferredLocation(IFigure borderItem) {
        Point constraintLocation = this.getConstraint().getLocation();
        Point ptAbsoluteLocation = this.getAbsoluteToBorder(constraintLocation);
        if (constraintLocation.x == 0 || constraintLocation.y == 0) {
            return this.getPreferredLocation(this.getPreferredSideOfParent(), borderItem);
        }
        return ptAbsoluteLocation;
    }

    protected Rectangle getParentBorder() {
        Rectangle bounds = this.getParentFigure().getBounds().getCopy();
        if (this.getParentFigure() instanceof NodeFigure) {
            bounds = ((NodeFigure)this.getParentFigure()).getHandleBounds().getCopy();
        }
        return bounds;
    }

    protected Point getPreferredLocation(int side, IFigure borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        int x = parentFigureX;
        int y = parentFigureY;
        Rectangle borderItemBounds = borderItem.getBounds();
        if (side == 8) {
            x = parentFigureX - borderItemBounds.width + this.getBorderItemOffset().width;
            y += parentFigureHeight / 2;
        } else if (side == 16) {
            x = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width;
            y += parentFigureHeight / 2;
        } else if (side == 1) {
            y = parentFigureY - borderItemBounds.height + this.getBorderItemOffset().height;
            x += parentFigureWidth / 2;
        } else if (side == 4) {
            x += parentFigureWidth / 2;
            y = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        }
        return new Point(x, y);
    }

    private Point locateOnParent(Point suggestedLocation, int suggestedSide, IFigure borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        Rectangle borderItemBounds = borderItem.getBounds();
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        int westX = parentFigureX - borderItemBounds.width + this.getBorderItemOffset().width;
        int eastX = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width;
        int southY = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        int northY = parentFigureY - borderItemBounds.height + this.getBorderItemOffset().height;
        if (suggestedSide == 8) {
            if (suggestedLocation.x != westX) {
                newX = westX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY + borderItemBounds.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemBounds.height) {
                newY = southY - borderItemBounds.height;
            }
        } else if (suggestedSide == 16) {
            if (suggestedLocation.x != eastX) {
                newX = eastX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY + borderItemBounds.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemBounds.height) {
                newY = southY - borderItemBounds.height;
            }
        } else if (suggestedSide == 4) {
            if (suggestedLocation.y != southY) {
                newY = southY;
            }
            if (suggestedLocation.x < bounds.getBottomLeft().x) {
                newX = westX + borderItemBounds.width;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemBounds.width) {
                newX = eastX - borderItemBounds.width;
            }
        } else {
            if (suggestedLocation.y != northY) {
                newY = northY;
            }
            if (suggestedLocation.x < bounds.getBottomLeft().x) {
                newX = westX + borderItemBounds.width;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemBounds.width) {
                newX = eastX - borderItemBounds.width;
            }
        }
        return new Point(newX, newY);
    }

    private boolean conflicts(Point recommendedLocation, IFigure targetBorderItem) {
        Rectangle recommendedRect = new Rectangle(recommendedLocation, targetBorderItem.getSize());
        List borderItems = targetBorderItem.getParent().getChildren();
        ListIterator iterator = borderItems.listIterator();
        while (iterator.hasNext()) {
            IFigure borderItem = (IFigure)iterator.next();
            if (!borderItem.isVisible()) continue;
            Rectangle rect = borderItem.getBounds().getCopy();
            if (borderItem == targetBorderItem || !rect.intersects(recommendedRect)) continue;
            return true;
        }
        return false;
    }

    private Point locateOnBorder(Point suggestedLocation, int suggestedSide, int circuitCount, IFigure borderItem) {
        Point recommendedLocation = this.locateOnParent(suggestedLocation, suggestedSide, borderItem);
        int vertical_gap = MapModeUtil.getMapMode((IFigure)this.getParentFigure()).DPtoLP(8);
        int horizontal_gap = MapModeUtil.getMapMode((IFigure)this.getParentFigure()).DPtoLP(8);
        Rectangle borderItemBounds = borderItem.getBounds();
        if (circuitCount < 4 && this.conflicts(recommendedLocation, borderItem)) {
            if (suggestedSide == 8) {
                do {
                    recommendedLocation.y += borderItemBounds.height + vertical_gap;
                } while (this.conflicts(recommendedLocation, borderItem));
                if (recommendedLocation.y > this.getParentBorder().getBottomLeft().y - borderItemBounds.height) {
                    return this.locateOnBorder(recommendedLocation, 4, circuitCount + 1, borderItem);
                }
            } else if (suggestedSide == 4) {
                do {
                    recommendedLocation.x += borderItemBounds.width + horizontal_gap;
                } while (this.conflicts(recommendedLocation, borderItem));
                if (recommendedLocation.x > this.getParentBorder().getBottomRight().x - borderItemBounds.width) {
                    return this.locateOnBorder(recommendedLocation, 16, circuitCount + 1, borderItem);
                }
            } else if (suggestedSide == 16) {
                do {
                    recommendedLocation.y -= borderItemBounds.height - vertical_gap;
                } while (this.conflicts(recommendedLocation, borderItem));
                if (recommendedLocation.y < this.getParentBorder().getTopRight().y) {
                    return this.locateOnBorder(recommendedLocation, 1, circuitCount + 1, borderItem);
                }
            } else {
                do {
                    recommendedLocation.x -= borderItemBounds.width - horizontal_gap;
                } while (this.conflicts(recommendedLocation, borderItem));
                if (recommendedLocation.x < this.getParentBorder().getTopLeft().x) {
                    return this.locateOnBorder(recommendedLocation, 8, circuitCount + 1, borderItem);
                }
            }
        }
        return recommendedLocation;
    }

    protected Point getAbsoluteToBorder(Point ptRelativeOffset) {
        Point parentOrigin = this.getParentBorder().getTopLeft();
        return parentOrigin.translate(ptRelativeOffset);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        int side = BorderItemLocator.findClosestSideOfParent(proposedLocation, this.getParentBorder());
        Point newTopLeft = this.locateOnBorder(realLocation.getTopLeft(), side, 0, borderItem);
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    public static int findClosestSideOfParent(Rectangle proposedLocation, Rectangle parentBorder) {
        Point parentCenter = parentBorder.getCenter();
        Point childCenter = proposedLocation.getCenter();
        if (childCenter.x < parentCenter.x) {
            if (childCenter.y < parentCenter.y) {
                Point parentTopLeft = parentBorder.getTopLeft();
                if (childCenter.x - parentTopLeft.x <= childCenter.y - parentTopLeft.y) {
                    return 8;
                }
                return 1;
            }
            Point parentBottomLeft = parentBorder.getBottomLeft();
            if (childCenter.x - parentBottomLeft.x <= parentBottomLeft.y - childCenter.y) {
                return 8;
            }
            return 4;
        }
        if (childCenter.y < parentCenter.y) {
            Point parentTopRight = parentBorder.getTopRight();
            if (parentTopRight.x - childCenter.x <= childCenter.y - parentTopRight.y) {
                return 16;
            }
            return 1;
        }
        Point parentBottomRight = parentBorder.getBottomRight();
        if (parentBottomRight.x - childCenter.x <= parentBottomRight.y - childCenter.y) {
            return 16;
        }
        return 4;
    }

    public void relocate(IFigure borderItem) {
        Rectangle rectSuggested = new Rectangle(this.getPreferredLocation(borderItem), borderItem.getBounds().getSize());
        int closestSide = BorderItemLocator.findClosestSideOfParent(rectSuggested, this.getParentBorder());
        this.setPreferredSideOfParent(closestSide);
        Point ptNewLocation = this.locateOnBorder(this.getPreferredLocation(borderItem), this.getPreferredSideOfParent(), 0, borderItem);
        borderItem.setLocation(ptNewLocation);
        this.setCurrentSideOfParent(BorderItemLocator.findClosestSideOfParent(new Rectangle(ptNewLocation, borderItem.getBounds().getSize()), this.getParentBorder()));
    }

    public IFigure getParentFigure() {
        return this.parentFigure;
    }

    public Dimension getBorderItemOffset() {
        return this.borderItemOffset;
    }

    public void setBorderItemOffset(Dimension borderItemOffset) {
        this.borderItemOffset = borderItemOffset;
    }

    public int getPreferredSideOfParent() {
        return this.preferredSide;
    }

    public void setPreferredSideOfParent(int preferredSide) {
        this.preferredSide = preferredSide;
        this.setCurrentSideOfParent(preferredSide);
    }

    public int getCurrentSideOfParent() {
        return this.currentSide;
    }

    public void setCurrentSideOfParent(int side) {
        this.currentSide = side;
    }
}

