/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.requests.DuplicateRequest;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

public class DuplicateViewsCommand
extends DuplicateEObjectsCommand {
    Map duplicatedElements;
    List duplicatedViewsToBeReturned = new ArrayList();
    private Point offset = new Point(0, 0);

    public DuplicateViewsCommand(TransactionalEditingDomain editingDomain, String label, DuplicateRequest request, List viewsToDuplicate, Map duplicatedElements, Point offset) {
        super(editingDomain, label, viewsToDuplicate);
        this.duplicatedElements = duplicatedElements;
        this.duplicatedViewsToBeReturned = request.getDuplicatedViews();
        this.offset = offset;
    }

    public DuplicateViewsCommand(TransactionalEditingDomain editingDomain, String label, DuplicateRequest request, List viewsToDuplicate, Point offset) {
        this(editingDomain, label, request, viewsToDuplicate, null, offset);
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doExecuteWithResult(progressMonitor, info);
        if (!result.getStatus().isOK()) {
            return result;
        }
        if (this.duplicatedElements != null && !this.duplicatedElements.isEmpty()) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            copier.putAll(this.duplicatedElements);
            copier.putAll(this.getAllDuplicatedObjectsMap());
            copier.copyReferences();
        }
        Iterator iter = this.getObjectsToBeDuplicated().iterator();
        while (iter.hasNext()) {
            LayoutConstraint layoutConstraint;
            View originalView = (View)iter.next();
            View duplicateView = (View)this.getAllDuplicatedObjectsMap().get(originalView);
            ArrayList sourceRefs = new ArrayList(duplicateView.getSourceEdges());
            Iterator iterator = sourceRefs.iterator();
            while (iterator.hasNext()) {
                EObject edge = (EObject)iterator.next();
                if (this.getAllDuplicatedObjectsMap().containsValue(edge)) continue;
                sourceRefs.remove(edge);
            }
            ArrayList targetRefs = new ArrayList(duplicateView.getTargetEdges());
            Iterator iterator2 = targetRefs.iterator();
            while (iterator2.hasNext()) {
                EObject edge = (EObject)iterator2.next();
                if (this.getAllDuplicatedObjectsMap().containsValue(edge)) continue;
                targetRefs.remove(edge);
            }
            if (duplicateView instanceof Node && (layoutConstraint = ((Node)duplicateView).getLayoutConstraint()) instanceof Bounds) {
                Bounds bounds = (Bounds)layoutConstraint;
                int x = bounds.getX();
                bounds.setX(x + this.offset.x);
                int y = bounds.getY();
                bounds.setY(y + this.offset.y);
            }
            if (duplicateView == null) continue;
            this.duplicatedViewsToBeReturned.add(duplicateView);
        }
        return CommandResult.newOKCommandResult((Object)this.duplicatedViewsToBeReturned);
    }
}

