/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.tools;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.ui.contentassist.ContentAssistantHelper;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TextCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramFontRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.TextCellEditorEx;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class TextDirectEditManager
extends DirectEditManager {
    private Color proposalPopupBackgroundColor = null;
    private Color proposalPopupForegroundColor = null;
    private boolean committed = false;
    private boolean listenersAttached = true;
    private StringBuffer initialString = new StringBuffer();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public TextDirectEditManager(ITextAwareEditPart source) {
        super((GraphicalEditPart)source, TextDirectEditManager.getTextCellEditorClass(source), TextDirectEditManager.getTextCellEditorLocator(source));
    }

    public TextDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator) {
        super(source, editorType, locator);
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source instanceof TextCompartmentEditPart) {
            return new TextCellEditorLocator(((TextCompartmentEditPart)source).getLabel());
        }
        IFigure figure = source.getFigure();
        if (!$assertionsDisabled && !(figure instanceof Label)) {
            throw new AssertionError();
        }
        return new LabelCellEditorLocator((Label)figure);
    }

    public static Class getTextCellEditorClass(GraphicalEditPart source) {
        IFigure figure = source.getFigure();
        if (figure instanceof WrapLabel && ((WrapLabel)figure).isTextWrapped()) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.gmf.runtime.gef.ui.internal.parts.WrapTextCellEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.gmf.runtime.gef.ui.internal.parts.TextCellEditorEx");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Font getScaledFont(IFigure label) {
        Font scaledFont = label.getFont();
        FontData data = scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, MapModeUtil.getMapMode((IFigure)label).DPtoLP(data.getHeight()));
        label.translateToAbsolute((Translatable)fontSize);
        if (Math.abs(data.getHeight() - fontSize.height) < 2) {
            fontSize.height = data.getHeight();
        }
        data.setHeight(fontSize.height);
        Font newFont = DiagramFontRegistry.getInstance().getFont(null, data);
        return newFont;
    }

    protected void initCellEditor() {
        IContentAssistProcessor processor;
        this.committed = false;
        ITextAwareEditPart textEP = (ITextAwareEditPart)this.getEditPart();
        this.setEditText(textEP.getEditText());
        IFigure label = textEP.getFigure();
        Assert.isNotNull((Object)label);
        Text text = (Text)this.getCellEditor().getControl();
        text.setFont(this.getScaledFont(label));
        this.getCellEditor().setValidator(textEP.getEditTextValidator());
        if (textEP.getParser() != null && (processor = textEP.getCompletionProcessor()) != null) {
            this.proposalPopupBackgroundColor = new Color((Device)this.getCellEditor().getControl().getShell().getDisplay(), new RGB(254, 241, 233));
            this.proposalPopupForegroundColor = new Color((Device)this.getCellEditor().getControl().getShell().getDisplay(), new RGB(0, 0, 0));
            ContentAssistantHelper.createTextContentAssistant((Text)text, (Color)this.proposalPopupForegroundColor, (Color)this.proposalPopupBackgroundColor, (IContentAssistProcessor)processor);
        }
    }

    protected void commit() {
        Control[] children;
        Shell activeShell = Display.getCurrent().getActiveShell();
        if (activeShell != null && this.getCellEditor().getControl().getShell().equals(activeShell.getParent()) && (children = activeShell.getChildren()).length == 1 && children[0] instanceof Table) {
            this.getCellEditor().getControl().setVisible(true);
            ((TextCellEditorEx)this.getCellEditor()).setDeactivationLock(true);
            return;
        }
        if (this.committed) {
            this.bringDown();
            return;
        }
        this.committed = true;
        super.commit();
    }

    protected void bringDown() {
        if (this.proposalPopupForegroundColor != null) {
            this.proposalPopupForegroundColor.dispose();
            this.proposalPopupForegroundColor = null;
        }
        if (this.proposalPopupBackgroundColor != null) {
            this.proposalPopupBackgroundColor.dispose();
            this.proposalPopupBackgroundColor = null;
        }
        this.eraseFeedback();
        this.initialString = new StringBuffer();
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                TextDirectEditManager.super.bringDown();
            }
        });
    }

    public void setEditText(String toEdit) {
        CellEditor cellEditor = this.getCellEditor();
        if (cellEditor == null) {
            return;
        }
        ITextAwareEditPart textEP = (ITextAwareEditPart)this.getEditPart();
        Text textControl = (Text)cellEditor.getControl();
        textEP.setLabelText(toEdit);
        if (cellEditor instanceof TextCellEditorEx) {
            ((TextCellEditorEx)cellEditor).setValueAndProcessEditOccured((Object)toEdit);
        } else {
            cellEditor.setValue((Object)toEdit);
        }
        textControl.setSelection(toEdit.length());
    }

    public void show(char initialChar) {
        this.initialString = this.initialString.append(initialChar);
        this.show();
        if (SWT.getPlatform() != "carbon") {
            this.setEditText(this.initialString.toString());
        }
    }

    public void show(Point location) {
        this.show();
        if (this.getCellEditor() != null && this.getCellEditor().getControl().getBounds().contains(location)) {
            this.sendMouseClick(location);
        }
    }

    private void sendMouseClick(final Point location) {
        final Display currDisplay = Display.getCurrent();
        new Thread(){
            Event event;

            public void run() {
                this.event = new Event();
                this.event.type = 3;
                this.event.button = 1;
                this.event.x = location.x;
                this.event.y = location.y;
                currDisplay.post(this.event);
                this.event.type = 4;
                currDisplay.post(this.event);
            }
        }.start();
    }

    protected void unhookListeners() {
        if (this.listenersAttached) {
            this.listenersAttached = false;
            super.unhookListeners();
        }
    }

    protected void setCellEditor(CellEditor editor) {
        super.setCellEditor(editor);
        if (editor != null) {
            this.listenersAttached = true;
        }
    }

    public void showFeedback() {
        try {
            this.getEditPart().getRoot();
            super.showFeedback();
        }
        catch (Exception exception) {}
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private WrapLabel wrapLabel;

        public TextCellEditorLocator(WrapLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrapLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getWrapLabel().getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (this.getWrapLabel().isTextWrapped() && this.getWrapLabel().getText().length() > 0) {
                rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
            } else {
                int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rect);
            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

