/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.gef;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.RuntimeDiagramTestBase;

public class NotationRefreshTest
extends RuntimeDiagramTestBase {
    public NotationRefreshTest(String name) {
        super(name);
    }

    public void testNotationRefreshOnDeleteNode() throws Exception {
        EditPart diagramEP = this.getDiagramEditPart();
        Diagram diagram = (Diagram)diagramEP.getModel();
        EObject diagramElement = diagram.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagramElement);
        Node nodeA = this.getCanvasInstance().getNodeA();
        EObject elementA = nodeA.getElement();
        EditPart editPartA = this.findEditPart((View)nodeA);
        Command command = RemoveCommand.create((EditingDomain)editingDomain, (Object)elementA.eContainer(), (Object)elementA.eContainingFeature(), (Object)elementA);
        NotationRefreshTest.assertTrue((String)"Failed to obtain command to remove an instance of the domain model element", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertNull((String)"RemoveCommand not executed properly", (Object)elementA.eContainer());
        NotationRefreshTest.assertNull((String)"Notational refresh failed on domain element removal", (Object)this.findView((View)diagram, elementA));
        NotationRefreshTest.assertNull((String)"EditPart not removed automatically", (Object)this.findEditPart((View)nodeA));
        NotationRefreshTest.assertFalse((boolean)editPartA.isActive());
    }

    public void testNotationRefreshOnCreateNode() throws Exception {
        EClass newChildClass;
        EObject newChild;
        EReference feature;
        EditPart diagramEP = this.getDiagramEditPart();
        Diagram diagram = (Diagram)diagramEP.getModel();
        EObject diagramElement = diagram.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagramElement);
        Command command = AddCommand.create((EditingDomain)editingDomain, (Object)diagramElement, (Object)(feature = this.getCanvasInstance().getNodeA().getElement().eContainmentFeature()), (Object)(newChild = (newChildClass = this.getCanvasInstance().getNodeA().getElement().eClass()).getEPackage().getEFactoryInstance().create(newChildClass)));
        NotationRefreshTest.assertTrue((String)"Failed to obtain command to create a new instance of the domain model element", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertSame((String)"AddCommand not executed properly", (Object)diagramElement, (Object)newChild.eContainer());
        View newChildView = this.findView((View)diagram, newChild);
        NotationRefreshTest.assertNotNull((String)"Notational refresh failed on domain element creation", (Object)newChildView);
        int visualId = this.getType(newChildView);
        NotationRefreshTest.assertEquals((int)this.getGenModel().getNodeA().getVisualID(), (int)visualId);
        EditPart newChildEP = this.findEditPart(newChildView);
        NotationRefreshTest.assertNotNull((String)"EditPart not created automatically", (Object)newChildEP);
    }

    public void testNotationRefreshOnAttributeChangeThatAffectsSelector() throws Exception {
        EditPart diagramEP = this.getDiagramEditPart();
        Diagram diagram = (Diagram)diagramEP.getModel();
        EObject diagramElement = diagram.getElement();
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagramElement);
        Node nodeB = this.getCanvasInstance().getNodeB();
        Bounds bounds = (Bounds)nodeB.getLayoutConstraint();
        Rectangle rectangle = new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        NotationRefreshTest.assertEquals((String)"Unexpected visual ID of the element", (int)this.getGenModel().getNodeB().getVisualID(), (int)this.getType((View)nodeB));
        EObject elementB = nodeB.getElement();
        EditPart editPartB = this.findEditPart((View)nodeB);
        Edge edge1 = this.getCanvasInstance().getLinkByClass();
        Edge edge2 = this.getCanvasInstance().getLinkByRef();
        this.checkLinkEnd(edge1, nodeB);
        this.checkLinkEnd(edge2, nodeB);
        EditPart edge1EP = this.findEditPart((View)edge1);
        EditPart edge2EP = this.findEditPart((View)edge2);
        NotationRefreshTest.assertTrue((boolean)edge1EP.isActive());
        NotationRefreshTest.assertTrue((boolean)edge2EP.isActive());
        EClass elementBClass = elementB.eClass();
        EStructuralFeature feature = elementBClass.getEStructuralFeature("pages");
        NotationRefreshTest.assertNotNull((String)"Failed to find the feature that affects selector", (Object)feature);
        Integer newValue = new Integer(200);
        Command command = SetCommand.create((EditingDomain)editingDomain, (Object)elementB, (Object)feature, (Object)newValue);
        NotationRefreshTest.assertTrue((String)"Failed to obtain command to make a change that affects selector", (command != null && command.canExecute() ? 1 : 0) != 0);
        new EMFCommandOperation(editingDomain, command).execute((IProgressMonitor)new NullProgressMonitor(), null);
        NotationRefreshTest.assertEquals((String)"SetCommand not executed properly", (Object)newValue, (Object)elementB.eGet(feature));
        Node newNodeB = (Node)this.findView((View)diagram, elementB);
        NotationRefreshTest.assertNotNull((String)"Notational refresh failed to recreate a new node upon a change that affects selector", (Object)newNodeB);
        NotationRefreshTest.assertNotSame((String)"Notational refresh failed to replace a new node upon a change that affects selector", (Object)nodeB, (Object)newNodeB);
        NotationRefreshTest.assertTrue((String)"Notational refresh failed to change visual ID of the element upon a change that affects selector", (this.getGenModel().getNodeB().getVisualID() != this.getType((View)newNodeB) ? 1 : 0) != 0);
        EditPart newEditPartB = this.findEditPart((View)newNodeB);
        NotationRefreshTest.assertNotNull((String)"EditPart not recreated automatically", (Object)newEditPartB);
        NotationRefreshTest.assertNotSame((String)"EditPart not replaced automatically", (Object)editPartB, (Object)newEditPartB);
        NotationRefreshTest.assertFalse((boolean)editPartB.isActive());
        NotationRefreshTest.assertTrue((boolean)newEditPartB.isActive());
        Bounds newBounds = (Bounds)newNodeB.getLayoutConstraint();
        Rectangle newRectangle = new Rectangle(newBounds.getX(), newBounds.getY(), newBounds.getWidth(), newBounds.getHeight());
        NotationRefreshTest.assertEquals((String)"Notational refresh failed to position the new node where the old one was", (Object)rectangle, (Object)newRectangle);
        NotationRefreshTest.assertTrue((boolean)edge1EP.isActive());
        NotationRefreshTest.assertTrue((boolean)edge2EP.isActive());
        this.checkLinkEnd(edge1, newNodeB);
        this.checkLinkEnd(edge2, newNodeB);
    }

    private void checkLinkEnd(Edge edge, Node node) {
        NotationRefreshTest.assertTrue((node.equals(edge.getSource()) || node.equals(edge.getTarget()) ? 1 : 0) != 0);
    }

    private int getType(View view) {
        return Integer.parseInt(view.getType());
    }

    private View findView(View container, EObject child) {
        Iterator it = container.getChildren().iterator();
        while (it.hasNext()) {
            View next = (View)it.next();
            if (!child.equals(next.getElement())) continue;
            return next;
        }
        return null;
    }
}

