/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.tests.Plugin;

public class CompileUtil {
    public IStatus build(IProject project) {
        try {
            project.build(6, (IProgressMonitor)new NullProgressMonitor());
            IMarker[] compileErrors = this.getJavaErrors(project);
            if (compileErrors.length > 0) {
                StringBuffer sb = new StringBuffer();
                sb.append(project.getName()).append(" has compilation problems:\n");
                String errorsMsg = this.formatErrors(sb, compileErrors);
                return new Status(4, Plugin.getPluginID(), 0, errorsMsg, null);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException ex) {
            return ex.getStatus();
        }
        catch (Exception exception) {
            return Status.CANCEL_STATUS;
        }
    }

    private IMarker[] collectJavaMarkers(IProject p) throws CoreException {
        return p.findMarkers("org.eclipse.jdt.core.problem", true, 2);
    }

    private IMarker[] getJavaErrors(IProject p) throws CoreException {
        return this.filterSevereMarkers(this.collectJavaMarkers(p));
    }

    private IMarker[] filterSevereMarkers(IMarker[] problems) throws CoreException {
        ArrayList<IMarker> rv = new ArrayList<IMarker>(problems.length);
        int i = 0;
        while (i < problems.length) {
            if (2 == (Integer)problems[i].getAttribute("severity")) {
                rv.add(problems[i]);
            }
            ++i;
        }
        return rv.toArray(new IMarker[rv.size()]);
    }

    private String formatErrors(StringBuffer sb, IMarker[] compileErrors) {
        int i = 0;
        while (i < compileErrors.length) {
            try {
                sb.append(compileErrors[i].getResource().getName());
                sb.append(':');
                sb.append(compileErrors[i].getAttribute("message"));
            }
            catch (CoreException ex) {
                sb.append("--ex:");
                sb.append(ex.getMessage());
            }
            sb.append(",\n");
            ++i;
        }
        return sb.toString();
    }
}

