/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.prefuse.examples.graphview;

import java.awt.Color;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.layout.graph.RadialTreeLayout;
import prefuse.controls.Control;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.NeighborHighlightControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;

public class GraphView
extends Display {
    public GraphView(Graph g, String label) {
        super(new Visualization());
        LabelRenderer tr = new LabelRenderer();
        tr.setRoundedCorner(8, 8);
        this.m_vis.setRendererFactory((RendererFactory)new DefaultRendererFactory((Renderer)tr));
        this.setGraph(g, label);
        TupleSet focusGroup = this.m_vis.getGroup(Visualization.FOCUS_ITEMS);
        focusGroup.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet ts, Tuple[] add, Tuple[] rem) {
                try {
                    int i = 0;
                    while (i < rem.length) {
                        ((VisualItem)rem[i]).setFixed(false);
                        ++i;
                    }
                    i = 0;
                    while (i < add.length) {
                        ((VisualItem)add[i]).setFixed(false);
                        ((VisualItem)add[i]).setFixed(true);
                        ++i;
                    }
                    if (ts.getTupleCount() == 0) {
                        ts.addTuple(rem[0]);
                        ((VisualItem)rem[0]).setFixed(false);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                GraphView.this.m_vis.run("draw");
            }
        });
        ColorAction fill = new ColorAction("graph.nodes", VisualItem.FILLCOLOR, ColorLib.rgb((int)200, (int)200, (int)255));
        fill.add(VisualItem.FIXED, ColorLib.rgb((int)255, (int)100, (int)100));
        fill.add(VisualItem.HIGHLIGHT, ColorLib.rgb((int)255, (int)200, (int)125));
        ActionList draw = new ActionList();
        draw.add((Action)fill);
        draw.add((Action)new ColorAction("graph.nodes", VisualItem.STROKECOLOR, 0));
        draw.add((Action)new ColorAction("graph.nodes", VisualItem.TEXTCOLOR, ColorLib.rgb((int)0, (int)0, (int)0)));
        draw.add((Action)new ColorAction("graph.edges", VisualItem.FILLCOLOR, ColorLib.gray((int)200)));
        draw.add((Action)new ColorAction("graph.edges", VisualItem.STROKECOLOR, ColorLib.gray((int)200)));
        RadialTreeLayout treeLayout = new RadialTreeLayout("graph");
        this.m_vis.putAction("treeLayout", (Action)treeLayout);
        ActionList animate = new ActionList(-1L);
        animate.add((Action)treeLayout);
        animate.add((Action)fill);
        animate.add((Action)new RepaintAction());
        this.m_vis.putAction("draw", (Action)draw);
        this.m_vis.putAction("layout", (Action)animate);
        this.m_vis.runAfter("draw", "layout");
        this.setSize(700, 700);
        this.pan(350.0, 350.0);
        this.setForeground(Color.GRAY);
        this.setBackground(Color.WHITE);
        this.addControlListener((Control)new FocusControl(1));
        this.addControlListener((Control)new DragControl());
        this.addControlListener((Control)new PanControl());
        this.addControlListener((Control)new ZoomControl());
        this.addControlListener((Control)new WheelZoomControl());
        this.addControlListener((Control)new ZoomToFitControl());
        this.addControlListener((Control)new NeighborHighlightControl());
        this.setForeground(Color.GRAY);
        this.setBackground(Color.WHITE);
        this.m_vis.run("draw");
    }

    public void setGraph(Graph g, String label) {
        DefaultRendererFactory drf = (DefaultRendererFactory)this.m_vis.getRendererFactory();
        ((LabelRenderer)drf.getDefaultRenderer()).setTextField(label);
        this.m_vis.removeGroup("graph");
        VisualGraph vg = this.m_vis.addGraph("graph", g);
        this.m_vis.setValue("graph.edges", null, VisualItem.INTERACTIVE, (Object)Boolean.FALSE);
        VisualItem f = (VisualItem)vg.getNode(0);
        this.m_vis.getGroup(Visualization.FOCUS_ITEMS).setTuple((Tuple)f);
        f.setFixed(false);
    }
}

