/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.io.library.binding;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.io.java.binding.Binding;
import org.eclipse.gmt.modisco.java.io.java.binding.ClassBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.FieldBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.MethodBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.PackageBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.ParameterBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.UnresolvedBinding;
import org.eclipse.gmt.modisco.java.io.library.ClassFileParser;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

@Deprecated
public final class JavaModelDelegateBindingFactory {
    private static JavaModelDelegateBindingFactory instance = new JavaModelDelegateBindingFactory();
    public static final String JAVA_LANG_OBJECT_SIGNATURE = Signature.createTypeSignature((String)"java.lang.Object", (boolean)true);

    private JavaModelDelegateBindingFactory() {
    }

    public static JavaModelDelegateBindingFactory getInstance() {
        return instance;
    }

    public ClassBinding getBindingForName(String sig, ClassFileParser visitor, boolean removeGenerics) {
        String readableSignature = null;
        readableSignature = removeGenerics ? Signature.toString((String)Signature.getTypeErasure((String)sig)) : Signature.toString((String)sig);
        try {
            switch (Signature.getTypeSignatureKind((String)sig)) {
                case 4: {
                    return this.getBindingForArrayType(sig, visitor, removeGenerics);
                }
                case 2: {
                    return this.getBindingForPrimitiveType(sig, visitor);
                }
                case 1: {
                    if (Signature.getTypeArguments((String)sig).length > 0 && !removeGenerics) {
                        return this.getBindingForParameterizedType(sig, visitor, removeGenerics);
                    }
                    IType type = visitor.getTypeFinder().getType(readableSignature);
                    if (type != null) {
                        return this.getClassBinding(type, visitor);
                    }
                    break;
                }
                case 5: {
                    return this.getBindingForWildCardType(sig, visitor);
                }
                case 3: {
                    ITypeParameter typeParameter = visitor.findTypeParameter(readableSignature);
                    return this.getTypeParameterBinding(typeParameter, visitor, removeGenerics);
                }
                case 6: {
                    return this.getBindingForName(JAVA_LANG_OBJECT_SIGNATURE, visitor, removeGenerics);
                }
            }
        }
        catch (JavaModelException type) {
            // empty catch block
        }
        ClassBinding binding = new ClassBinding();
        binding.setName(readableSignature);
        return binding;
    }

    public Binding getBindingForElement(IJavaElement element, ClassFileParser visitor) {
        Binding result = null;
        try {
            result = this.getBinding(element, visitor);
        }
        catch (JavaModelException e) {
            Status status = new Status(2, "org.eclipse.gmt.modisco.java.discoverer", e.getException().getMessage(), (Throwable)e);
            JavaActivator.getDefault().getLog().log((IStatus)status);
        }
        if (result == null) {
            result = new UnresolvedBinding(element.getElementName());
        }
        return result;
    }

    public ClassBinding getBindingForWildCardType(String signature, ClassFileParser visitor) {
        ClassBinding binding = new ClassBinding();
        StringBuilder buffer = new StringBuilder();
        String boundSignature = null;
        buffer.append("?");
        if (signature.charAt(0) == '+') {
            buffer.append(" extends ");
            boundSignature = signature.substring(1);
        } else if (signature.charAt(0) == '-') {
            buffer.append(" super ");
            boundSignature = signature.substring(1);
        }
        if (boundSignature != null) {
            ClassBinding typeErasureBinding = this.getBindingForName(boundSignature, visitor, false);
            buffer.append(typeErasureBinding.toString());
        }
        binding.setName(buffer.toString());
        return binding;
    }

    public ClassBinding getBindingForParameterizedType(String signature, ClassFileParser visitor, boolean removeGenerics) {
        ClassBinding binding = new ClassBinding();
        StringBuilder buffer = new StringBuilder();
        String typeErasureSignature = Signature.getTypeErasure((String)signature);
        ClassBinding typeErasureBinding = this.getBindingForName(typeErasureSignature, visitor, removeGenerics);
        buffer.append(typeErasureBinding.toString());
        if (!removeGenerics) {
            buffer.append('<');
            String[] typeArgumentsSignatures = Signature.getTypeArguments((String)signature);
            int i = 0;
            while (i < typeArgumentsSignatures.length) {
                if (i > 0) {
                    buffer.append(",");
                }
                ClassBinding typeArgumentBinding = this.getBindingForName(typeArgumentsSignatures[i], visitor, removeGenerics);
                buffer.append(typeArgumentBinding.toString());
                ++i;
            }
            buffer.append('>');
        }
        binding.setName(buffer.toString());
        return binding;
    }

    public ClassBinding getBindingForPrimitiveType(String signature, ClassFileParser visitor) {
        ClassBinding binding = new ClassBinding();
        binding.setName(Signature.toString((String)signature));
        return binding;
    }

    public ClassBinding getBindingForArrayType(String type, ClassFileParser visitor, boolean removeGenerics) {
        ClassBinding result = new ClassBinding();
        ClassBinding elementTypeBinding = this.getBindingForName(Signature.getElementType((String)type), visitor, removeGenerics);
        int dimensions = Signature.getArrayCount((String)type);
        char[] brackets = new char[dimensions * 2];
        int i = dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        result.setName(String.valueOf(elementTypeBinding.toString()) + String.valueOf(brackets));
        return result;
    }

    private Binding getBinding(IJavaElement element, ClassFileParser visitor) throws JavaModelException {
        Binding result = null;
        if (element instanceof IMethod) {
            result = this.getMethodBinding((IMethod)element, visitor);
        } else if (element instanceof IType) {
            result = this.getClassBinding((IType)element, visitor);
        } else if (element instanceof ITypeParameter) {
            result = this.getTypeParameterBinding((ITypeParameter)element, visitor, false);
        } else if (element instanceof IPackageFragment) {
            result = this.getPackageBinding((IPackageFragment)element, visitor);
        } else if (element instanceof IField) {
            result = this.getFieldBinding((IField)element, visitor);
        }
        return result;
    }

    private ClassBinding getTypeParameterBinding(ITypeParameter element, ClassFileParser visitor, boolean removeGenerics) throws JavaModelException {
        if (removeGenerics) {
            String erasure = element.getBounds()[0];
            return this.getBindingForName(Signature.createTypeSignature((String)erasure, (boolean)true), visitor, removeGenerics);
        }
        ClassBinding result = new ClassBinding();
        result.setName(element.getElementName());
        result.setTypeVariable(true);
        return result;
    }

    private MethodBinding getMethodBinding(IMethod method, ClassFileParser visitor) throws JavaModelException {
        MethodBinding result = new MethodBinding();
        result.setName(method.getElementName());
        result.setDeclaringClass(this.getClassBinding(method.getDeclaringType(), visitor));
        result.setConstructor(method.isConstructor());
        result.setAnnotationMember(method.getDeclaringType().isAnnotation());
        int i = 0;
        while (i < method.getParameterTypes().length) {
            result.getParameters().add(this.getParameterBinding(method.getParameterTypes()[i], visitor));
            ++i;
        }
        return result;
    }

    private ParameterBinding getParameterBinding(String type, ClassFileParser visitor) {
        ParameterBinding result = new ParameterBinding();
        int dimensions = Signature.getArrayCount((String)type);
        result.setDimensions(dimensions);
        if (dimensions > 0) {
            result.setElementType(this.getBindingForName(Signature.getElementType((String)type), visitor, true));
        } else {
            result.setElementType(this.getBindingForName(type, visitor, true));
        }
        return result;
    }

    private PackageBinding getPackageBinding(IPackageFragment pck, ClassFileParser visitor) {
        PackageBinding result = new PackageBinding();
        result.setName(pck.getElementName());
        return result;
    }

    private ClassBinding getClassBinding(IType type, ClassFileParser visitor) throws JavaModelException {
        int n;
        int n2;
        String[] stringArray;
        String superClassSignature;
        ClassBinding result = new ClassBinding();
        result.setInterface(type.isInterface());
        result.setAnnotation(type.isAnnotation());
        result.setEnum(type.isEnum());
        result.setName(type.getElementName());
        if (type.getPackageFragment() != null && type.getPackageFragment().exists()) {
            result.setOwnerPackage(this.getPackageBinding(type.getPackageFragment(), visitor));
        }
        if (type.getDeclaringType() != null && type.getDeclaringType().exists()) {
            result.setDeclaringClass(this.getClassBinding(type.getDeclaringType(), visitor));
        }
        if (type.isClass() && (superClassSignature = type.getSuperclassTypeSignature()) != null && !superClassSignature.equals(JAVA_LANG_OBJECT_SIGNATURE)) {
            result.setSuperClass(this.getBindingForName(superClassSignature, visitor, true));
        }
        if (!type.isAnnotation() && type.getSuperInterfaceTypeSignatures() != null) {
            stringArray = type.getSuperInterfaceTypeSignatures();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String superInterfaceSignature = stringArray[n];
                if (!superInterfaceSignature.equals(JAVA_LANG_OBJECT_SIGNATURE)) {
                    result.getSuperInterfaces().add(this.getBindingForName(superInterfaceSignature, visitor, true));
                }
                ++n;
            }
        }
        if (type.getTypeParameters() != null) {
            stringArray = type.getTypeParameters();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String typeParameter = stringArray[n];
                result.addTypeParameters(typeParameter.getElementName());
                ++n;
            }
        }
        return result;
    }

    private FieldBinding getFieldBinding(IField field, ClassFileParser visitor) throws JavaModelException {
        FieldBinding result = new FieldBinding();
        result.setName(field.getElementName());
        result.setEnumConstant(field.isEnumConstant());
        if (field.getDeclaringType() != null && field.getDeclaringType().exists()) {
            result.setDeclaringClass(this.getClassBinding(field.getDeclaringType(), visitor));
        }
        return result;
    }
}

