/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.gmt.modisco.java.actions.DiscoverJavaModelFromJavaProject;
import org.eclipse.gmt.modisco.java.internal.core.JavaJdtBridge;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class BrowseJavaModel
extends AbstractDiscovererImpl {
    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        IJavaProject javaProject = null;
        if (source instanceof IJavaProject) {
            javaProject = (IJavaProject)source;
        } else if (source instanceof IProject) {
            IProject project = (IProject)source;
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    javaProject = JavaCore.create((IProject)project);
                }
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            }
        } else if (source instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)source;
            javaProject = root.getJavaProject();
        } else if (source instanceof IJavaElement) {
            IJavaElement root = (IJavaElement)source;
            javaProject = root.getJavaProject();
        }
        this.prepareJavaModel(javaProject, source);
    }

    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IJavaElement) {
            result = true;
        } else if (source instanceof IJavaProject) {
            result = ((IJavaProject)source).getProject().isAccessible();
        } else if (source instanceof IProject) {
            IProject project = (IProject)source;
            try {
                if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                    result = true;
                }
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            }
        }
        return result;
    }

    ASTNode findCorrespondingJavaElement(IJavaElement jdtElement, Resource javaModel) {
        Package result = null;
        JavaJdtBridge bridge = new JavaJdtBridge();
        if (jdtElement instanceof IPackageFragment) {
            IPackageFragment jdtFragment = (IPackageFragment)jdtElement;
            result = bridge.getJavaPackage(javaModel, jdtFragment);
        } else if (jdtElement instanceof ICompilationUnit) {
            ICompilationUnit jdtUnit = (ICompilationUnit)jdtElement;
            IType jdtType = jdtUnit.findPrimaryType();
            result = bridge.getJavaType(javaModel, jdtType);
        } else if (jdtElement instanceof IType) {
            IType jdtType = (IType)jdtElement;
            result = bridge.getJavaType(javaModel, jdtType);
        } else if (jdtElement instanceof IMethod) {
            IMethod jdtMethod = (IMethod)jdtElement;
            result = bridge.getJavaOperation(javaModel, jdtMethod);
        } else if (jdtElement instanceof IField) {
            IField jdtField = (IField)jdtElement;
            result = bridge.getJavaField(javaModel, jdtField);
        }
        return result;
    }

    private void prepareJavaModel(IJavaProject project, Object source) {
        IPath path = project.getProject().getLocation().addTrailingSeparator().append(project.getElementName()).addFileExtension("javaxmi");
        IFile ifile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        boolean openable = ifile.exists();
        if (!openable) {
            DiscoverJavaModelFromJavaProject discoverer = new DiscoverJavaModelFromJavaProject();
            HashMap<DiscoveryParameter, Object> parameters = new HashMap<DiscoveryParameter, Object>();
            discoverer.discoverElement((Object)project, parameters);
            if (discoverer.getResourceResult() != null) {
                openable = true;
            }
        }
        if (openable) {
            this.openJavaModelEditor(ifile, source);
        }
    }

    private final void openJavaModelEditor(final IFile ifile, final Object source) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)ifile, (String)"org.eclipse.gmt.modisco.infra.browser.editorID");
                    if (source instanceof IJavaElement && !(source instanceof IPackageFragmentRoot)) {
                        EcoreBrowser browser = (EcoreBrowser)editor;
                        URI javaModelUri = URI.createPlatformResourceURI((String)ifile.getFullPath().toString(), (boolean)true);
                        Resource resource = browser.getResourceSet().getResource(javaModelUri, false);
                        if (resource != null) {
                            ASTNode astNode = BrowseJavaModel.this.findCorrespondingJavaElement((IJavaElement)source, resource);
                            if (astNode != null) {
                                browser.browseTo((EObject)astNode);
                            }
                        } else {
                            MoDiscoLogger.logInfo((String)(javaModelUri + " not found !"), (Plugin)JavaActivator.getDefault());
                        }
                    }
                }
                catch (PartInitException e) {
                    MoDiscoLogger.logInfo((Throwable)e, (Plugin)JavaActivator.getDefault());
                }
            }
        });
    }
}

