/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.simpletransformationschain.controller.impl;

import java.io.File;
import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.common.core.internal.logging.MoDiscoLogHandler;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.java.actions.DiscoverJavaModelFromJavaProject;
import org.eclipse.gmt.modisco.java.actions.DiscoverKdmModelFromJavaProject;
import org.eclipse.gmt.modisco.java.actions.TranslateJavaModelToKdm;
import org.eclipse.gmt.modisco.kdm.uml2converter.impl.KdmtoUmlConverterImpl;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.Messages;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.ModelplexKnowledgeDiscoveryFrameworkPlugin;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.controller.Converter;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.controller.impl.ChainedTransformationLauncher;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.ModelServices;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.modelplex.AtlTransformation;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.modelplex.ModelplexDiscoverer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ConverterImpl
implements Converter {
    private final Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private final IJavaProject javaProject;
    private IPath path;
    private final ModelServices model;

    public ConverterImpl(IJavaProject javaProjectParameter, ModelServices modelParameter) {
        this.javaProject = javaProjectParameter;
        this.model = modelParameter;
        try {
            IResource resource;
            if (this.javaProject != null && (resource = this.javaProject.getCorrespondingResource()) != null) {
                this.path = resource.getLocation().addTrailingSeparator().append(this.javaProject.getElementName());
            }
        }
        catch (JavaModelException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)ModelplexKnowledgeDiscoveryFrameworkPlugin.getDefault());
        }
    }

    public void convertJavaProjectToUml2() {
        Job job = new Job(Messages.ConverterImpl_0){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                MoDiscoLogHandler logHandler = new MoDiscoLogHandler(ConverterImpl.this.path.addFileExtension("log").toString());
                ConverterImpl.this.logger.addHandler((Handler)logHandler);
                try {
                    ChainedTransformationLauncher launcher = new ChainedTransformationLauncher();
                    ModelplexDiscoverer discoverer = ConverterImpl.this.model.getDiscoverer();
                    Resource kdmModel = null;
                    URI kdmModelUri = URI.createFileURI((String)ConverterImpl.this.path.addFileExtension("kdm").toString());
                    if (discoverer.getToKdm().isCustom()) {
                        String transformationPath = discoverer.getToKdm().getTransformationPath();
                        URL transformation = new File(transformationPath).toURI().toURL();
                        DiscoverJavaModelFromJavaProject javaDiscoverer = new DiscoverJavaModelFromJavaProject();
                        Resource j2se5Model = javaDiscoverer.discoverElement((Object)ConverterImpl.this.javaProject, null);
                        TranslateJavaModelToKdm kdmTranslater = new TranslateJavaModelToKdm();
                        kdmModel = kdmTranslater.getKDMModelFromJavaModelWithCustomTransformation(j2se5Model.getURI(), transformation, kdmModelUri);
                    } else {
                        DiscoverKdmModelFromJavaProject javaDiscoverer = new DiscoverKdmModelFromJavaProject();
                        kdmModel = javaDiscoverer.discoverElement((Object)ConverterImpl.this.javaProject, kdmModelUri);
                    }
                    for (AtlTransformation atlTransformation : discoverer.getToKdm().getChainedTransformations()) {
                        System.out.println("Additional transformation for KDM : " + atlTransformation);
                        launcher.launchKdmToKdmTransformation(atlTransformation, kdmModelUri, kdmModelUri);
                    }
                    KdmtoUmlConverterImpl converter = new KdmtoUmlConverterImpl();
                    URI outputURI = URI.createFileURI((String)ConverterImpl.this.path.addFileExtension("uml").toString());
                    if (discoverer.getToUml().isCustom()) {
                        String transformationPath = discoverer.getToUml().getTransformationPath();
                        URL transformation = new File(transformationPath).toURI().toURL();
                        converter.getUML2ModelFromKDMModelWithCustomTransformation(kdmModel.getURI(), false, transformation, outputURI);
                    } else {
                        converter.getUML2ModelFromKDMModel(kdmModel, false, outputURI);
                    }
                    for (AtlTransformation atlTransformation : discoverer.getToUml().getChainedTransformations()) {
                        System.out.println("Additional transformation for UML : " + atlTransformation);
                        launcher.launchUmlToUmlTransformation(atlTransformation, outputURI, kdmModelUri, outputURI);
                    }
                }
                catch (Exception e) {
                    result = Status.CANCEL_STATUS;
                    MoDiscoLogger.logError((Throwable)e, (Plugin)ModelplexKnowledgeDiscoveryFrameworkPlugin.getDefault());
                }
                ConverterImpl.this.logger.removeHandler((Handler)logHandler);
                logHandler.close();
                try {
                    ConverterImpl.this.javaProject.getCorrespondingResource().refreshLocal(1, null);
                }
                catch (Exception exception) {}
                return result;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                            IFile ifile = root.getFileForLocation(ConverterImpl.this.path.addFileExtension("uml"));
                            if (ifile.exists()) {
                                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                IDE.openEditor((IWorkbenchPage)page, (IFile)ifile);
                            }
                        }
                        catch (PartInitException e) {
                            MoDiscoLogger.logError((Throwable)e, (Plugin)ModelplexKnowledgeDiscoveryFrameworkPlugin.getDefault());
                        }
                    }
                });
            }
        });
        job.schedule();
    }
}

