/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.ModelEvents;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.modelplex.AtlTransformation;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.modelplex.ModelplexTransformation;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.data.ElementDisplay;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.data.TransformationDisplay;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationContentProvider
implements ITreeContentProvider,
ModelEvents {
    private final List<ElementDisplay> transformations = new ArrayList<ElementDisplay>();

    public final List<ElementDisplay> getTransformations() {
        return this.transformations;
    }

    public Object[] getChildren(Object parentElement) {
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.transformations.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ModelplexTransformation) {
            this.transformations.clear();
            ModelplexTransformation model = (ModelplexTransformation)newInput;
            for (AtlTransformation additionalTransformation : model.getChainedTransformations()) {
                TransformationDisplay display = new TransformationDisplay(additionalTransformation);
                this.transformations.add(display);
            }
        }
    }

    @Override
    public void chainedTransformationAdded(ModelplexTransformation modelplexTransformation, AtlTransformation additionalTransformation) {
        TransformationDisplay display = new TransformationDisplay(additionalTransformation);
        this.transformations.add(display);
    }

    @Override
    public void chainedTransformationRemoved(ModelplexTransformation modelplexTransformation, AtlTransformation removedTransformation) {
        ElementDisplay display = null;
        for (ElementDisplay temp : this.transformations) {
            if (temp.getModelElement() != removedTransformation) continue;
            display = temp;
        }
        this.transformations.remove(display);
    }

    @Override
    public void chainedTransformationUpdated(ModelplexTransformation modelplexTransformation, AtlTransformation updatedTransformation) {
        for (ElementDisplay display : this.transformations) {
            if (display.getModelElement() != updatedTransformation) continue;
            display.refresh();
        }
    }

    @Override
    public void modelplexTransformationUpdated(ModelplexTransformation modelplexTransformation) {
        ArrayList<ElementDisplay> temp = new ArrayList<ElementDisplay>(this.transformations);
        this.transformations.clear();
        for (AtlTransformation transformation : modelplexTransformation.getChainedTransformations()) {
            for (ElementDisplay display : temp) {
                if (display.getModelElement() != transformation) continue;
                this.transformations.add(display);
            }
        }
    }
}

