/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.internal.engine;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.WorkflowModel;
import org.eclipse.gmt.modisco.workflow.generator.GenerateDiscoverer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;

@Deprecated
public class CreatePluginProject {
    private final IProject project;
    private final IJavaProject javaProject;
    private IPackageFragmentRoot sourceFolder;

    public CreatePluginProject(String symbolicName, String packageBase, WorkflowModel workflowModel) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project = root.getProject(symbolicName);
        if (!this.project.exists()) {
            this.project.create(null);
        }
        this.project.open(null);
        this.javaProject = JavaCore.create((IProject)this.project);
        IFolder binFolder = this.createBinFolder();
        this.setJavaNature();
        this.javaProject.setRawClasspath(new IClasspathEntry[0], null);
        this.createOutputFolder(binFolder);
        this.addSystemLibraries();
        this.createPackage(packageBase);
        this.sourceFolder.createPackageFragment(packageBase, false, null);
        this.sourceFolder.createPackageFragment(String.valueOf(packageBase) + ".actions", false, null);
        this.sourceFolder.createPackageFragment(String.valueOf(packageBase) + ".modiscoworks", false, null);
        this.createMetaInfFolder();
        URI uri = URI.createPlatformResourceURI((String)this.project.getFullPath().append(symbolicName).addFileExtension("modiscoworkflow").toString(), (boolean)true);
        workflowModel.exportWorkflow(uri);
        this.createDiscovererFiles(uri);
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private void createDiscovererFiles(URI modelUri) {
        try {
            ArrayList arguments = new ArrayList();
            File fileResource = this.project.getWorkspace().getRoot().getLocation().append(this.project.getName()).toFile();
            GenerateDiscoverer gen = new GenerateDiscoverer(modelUri, fileResource, arguments);
            gen.doGenerate((Monitor)new BasicMonitor());
        }
        catch (IOException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void populateSourceFolder(File src) throws CoreException {
        if (this.sourceFolder == null) {
            this.sourceFolder = this.createSourceFolder();
        }
        this.project.refreshLocal(2, null);
    }

    public IPackageFragment createPackage(String name) throws CoreException {
        if (this.sourceFolder == null) {
            this.sourceFolder = this.createSourceFolder();
        }
        return this.sourceFolder.createPackageFragment(name, false, null);
    }

    public IType createType(IPackageFragment pack, String cuName, String source) throws JavaModelException {
        StringBuffer buf = new StringBuffer();
        buf.append("package " + pack.getElementName() + ";\n");
        buf.append("\n");
        buf.append(source);
        ICompilationUnit cu = pack.createCompilationUnit(cuName, buf.toString(), false, null);
        return cu.getTypes()[0];
    }

    public void dispose() throws CoreException {
        this.project.delete(true, true, null);
        this.project.getParent().refreshLocal(2, null);
    }

    private final IFolder createBinFolder() throws CoreException {
        IFolder binFolder = this.project.getFolder("bin");
        if (!binFolder.exists()) {
            binFolder.create(false, true, null);
        }
        return binFolder;
    }

    private final IFolder createMetaInfFolder() throws CoreException {
        IFolder metaInfFolder = this.project.getFolder("META-INF");
        if (!metaInfFolder.exists()) {
            metaInfFolder.create(false, true, null);
        }
        return metaInfFolder;
    }

    private final void setJavaNature() throws CoreException {
        IProjectDescription description = this.project.getDescription();
        description.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature"});
        this.project.setDescription(description, null);
    }

    private final void createOutputFolder(IFolder binFolder) throws JavaModelException {
        IPath outputLocation = binFolder.getFullPath();
        this.javaProject.setOutputLocation(outputLocation, null);
    }

    private final IPackageFragmentRoot createSourceFolder() throws CoreException {
        IFolder folder = this.project.getFolder("src");
        if (!folder.exists()) {
            folder.create(false, true, null);
        }
        IPackageFragmentRoot root = this.javaProject.getPackageFragmentRoot((IResource)folder);
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaCore.newSourceEntry((IPath)root.getPath());
        this.javaProject.setRawClasspath(newEntries, null);
        return root;
    }

    private final void addSystemLibraries() throws JavaModelException {
        IClasspathEntry[] oldEntries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = JavaRuntime.getDefaultJREContainerEntry();
        this.javaProject.setRawClasspath(newEntries, null);
    }
}

