/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.Activator;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.api.IDiscovererBenchmarkDiscoverer;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.api.IDiscovererID;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.api.IEventNotifier;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IDiscovererList;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.exported.IProjectSet;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl.DiscovererID;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl.EventAndMemoryRecorder;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.reporting.HtmlReport;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.reporting.internal.BenchmarkChartGeneration;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Benchmark;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.BenchmarkFactory;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Discovery;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.DiscoveryIteration;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.EndEvent;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Event;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.EventType;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.MemoryMeasurement;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Project;
import org.eclipse.modisco.infra.discovery.catalog.CatalogFactory;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.IDiscoverer;
import org.eclipse.modisco.infra.discovery.core.IDiscoveryManager;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.infra.discovery.launch.LaunchConfiguration;
import org.eclipse.modisco.infra.discovery.launch.LaunchFactory;
import org.eclipse.modisco.infra.discovery.launch.ParameterValue;
import org.eclipse.modisco.utils.core.internal.exported.SystemInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscovererBenchmarkDiscoverer
extends AbstractModelDiscoverer<IProjectSet>
implements IDiscovererBenchmarkDiscoverer {
    private static final int ZERO = 0;
    private static final int TWO = 2;
    private static final int SIX = 6;
    private static final int EIGHT = 8;
    private static final int TEN = 10;
    private static final String SAVE_OPERATION = "SaveOperation";
    private static final int INTERVAL = 1000;
    private static final int MSINSEC = 1000;
    private static final String CODE_EXTENSION = "java";
    public static final String ID = "org.eclipse.modisco.infra.discovery.benchmark.core.api.benchmarkdiscoverer";
    private static final long BYTEPERMB = 0x100000L;
    private IDiscovererID discovererID = new DiscovererID("org.eclipse.modisco.infra.discovery.benchmark.core.api.benchmarkdiscoverer");
    private int iterations;
    private boolean measureMemoryUse;
    private int memoryPollingInterval = 0;
    private boolean generateHtmlReport;
    private URI htmlReportLocation;
    private EventAndMemoryRecorder recorder;
    private List<MemoryMeasurement> memoryMeasurements = new LinkedList<MemoryMeasurement>();
    private List<Event> events = new LinkedList<Event>();
    private ResourceSet rSet = new ResourceSetImpl();
    private IDiscovererList discoverers;

    public DiscovererBenchmarkDiscoverer() {
        this.rSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        this.iterations = 1;
    }

    protected IDiscovererList getDiscoverers() {
        return this.discoverers;
    }

    @Parameter(name="DISCOVERER_LIST", description="The list of discoverers.", requiresInputValue=true)
    public void setDiscoverers(IDiscovererList discos) {
        this.discoverers = discos;
    }

    public Resource discoverBenchmark(IProjectSet projects, IProgressMonitor progressMonitor) throws DiscoveryException {
        progressMonitor.beginTask("Benchmark Discovery", 10);
        progressMonitor.subTask("Benchmark initialization");
        Benchmark benchmark = this.benchmarkInit();
        progressMonitor.worked(2);
        this.recorder = new EventAndMemoryRecorder(this.measureMemoryUse, this.memoryPollingInterval);
        for (IProject project : projects.sortBySize().getProjects()) {
            progressMonitor.subTask("project initialization");
            Project proj = this.createBenchmarkProjectAndFiles(project);
            benchmark.getProjects().add((Object)proj);
            for (Discovery discoTemp : this.discoverers) {
                progressMonitor.subTask("Discovery initialization");
                Discovery disco = BenchmarkFactory.eINSTANCE.createDiscovery();
                String discovererId = discoTemp.getDiscovererId();
                AbstractModelDiscoverer discoverer = (AbstractModelDiscoverer)IDiscoveryManager.INSTANCE.createDiscovererImpl(discovererId);
                benchmark.getDiscoveries().add((Object)disco);
                this.preDiscoveryDiscoInit(proj, disco, discoTemp, (AbstractModelDiscoverer<IProject>)discoverer, discovererId);
                this.setLaunchParameter(disco, (AbstractModelDiscoverer<IProject>)discoverer);
                String serializationLocation = discoverer.getTargetURI() != null ? discoverer.getTargetURI().trimFileExtension().toPlatformString(false) : this.getTargetURI().trimFileExtension().toPlatformString(false);
                int i = 1;
                while (i <= this.iterations) {
                    URI resultSerializationLocation = URI.createURI((String)serializationLocation);
                    discoverer.setTargetURI(resultSerializationLocation.appendSegment(String.valueOf(disco.getDiscovererId()) + "_" + proj.getName() + "_iteration_" + String.valueOf(i) + ".xmi"));
                    boolean failure = false;
                    StringBuilder discoveryErrors = new StringBuilder();
                    this.recorder.reset();
                    if (IEventNotifier.class.isInstance(discoverer)) {
                        ((IEventNotifier)discoverer).addListener(this.recorder);
                    }
                    progressMonitor.subTask("Project discovery: iteration " + String.valueOf(this.getIterations()));
                    this.recorder.start();
                    try {
                        if (discoverer.isApplicableTo((Object)project)) {
                            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, 8);
                            discoverer.discoverElement((Object)project, (IProgressMonitor)subProgressMonitor);
                        } else {
                            MoDiscoLogger.logWarning((String)("Discoverer " + discovererId + " is not applicable on project " + project.getName()), (Plugin)Activator.getDefault());
                        }
                    }
                    catch (DiscoveryException e) {
                        failure = true;
                        discoveryErrors.append(e.getStackTrace().toString());
                        MoDiscoLogger.logError((Throwable)e, (String)("Benchmark of discoverer " + discovererId + " fails on project" + project.getName()), (Plugin)Activator.getDefault());
                    }
                    catch (ClassCastException e) {
                        failure = true;
                        discoveryErrors.append(e.getStackTrace().toString());
                        MoDiscoLogger.logError((Throwable)e, (String)("Benchmark of discoverer " + discovererId + " fails on project" + project.getName()), (Plugin)Activator.getDefault());
                    }
                    this.recorder.stop();
                    this.events.addAll(this.recorder.getEvents());
                    this.events.addAll(this.recorder.getMemoryMeasurements());
                    this.memoryMeasurements.addAll(this.recorder.getMemoryMeasurements());
                    if (IEventNotifier.class.isInstance(discoverer)) {
                        ((IEventNotifier)discoverer).removeListener(this.recorder);
                    }
                    DiscoveryIteration discoveryIteration = this.createDiscoveryIteration(this.recorder);
                    if (failure) {
                        discoveryIteration.setDiscoveryErrors(discoveryErrors.toString());
                    }
                    disco.getIterations().add((Object)discoveryIteration);
                    ++i;
                }
                this.postDiscoveryDiscoInit(disco, (AbstractModelDiscoverer<IProject>)discoverer);
                if (!this.isTargetSerializationChosen()) continue;
                try {
                    this.saveTargetModel(benchmark);
                }
                catch (IOException e) {
                    MoDiscoLogger.logError((Throwable)e, (String)"Intermediate model save fail", (Plugin)Activator.getDefault());
                }
            }
        }
        benchmark.setJvmMaxHeapInMiB(this.computeMaxMemoryUsage());
        try {
            if (this.isTargetSerializationChosen()) {
                progressMonitor.subTask("Save benchmark model");
                this.saveTargetModel(benchmark);
                progressMonitor.worked(this.getIterations() * projects.getProjects().size() * this.discoverers.getDiscoverers().size());
            }
            if (this.isGenerateHtmlReport()) {
                progressMonitor.subTask("Generate benchmark report");
                SubProgressMonitor subProgressM = new SubProgressMonitor(progressMonitor, 6);
                this.generateHtmlReport((IProgressMonitor)subProgressM, benchmark);
                progressMonitor.worked(2 * this.getIterations() * projects.getProjects().size() * this.discoverers.getDiscoverers().size());
            }
        }
        catch (IOException e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Report generation fail", (Plugin)Activator.getDefault());
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Report generation fail", (Plugin)Activator.getDefault());
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Report generation fail", (Plugin)Activator.getDefault());
        }
        progressMonitor.done();
        return benchmark.eResource();
    }

    private long computeSize(Resource targetModel) {
        long size = 0L;
        if (targetModel != null) {
            TreeIterator iterator = targetModel.getAllContents();
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
        } else {
            MoDiscoLogger.logWarning((String)"Unable to compute the number of element of an unexisting model", (Plugin)Activator.getDefault());
        }
        return size;
    }

    private void generateHtmlReport(IProgressMonitor progressMonitor, Benchmark benchmark) throws Exception {
        URI targetURI = null;
        targetURI = this.getHtmlReportLocation() != null ? this.getHtmlReportLocation() : this.getTargetURI();
        if (targetURI == null) {
            MoDiscoLogger.logWarning((String)"The HTML_REPORT_LOCATION or the TARGET_URI parameter should not be null", (Plugin)Activator.getDefault());
            return;
        }
        IContainer location = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(targetURI.path().replace("/resource", ""))).getParent();
        String locationString = "";
        locationString = targetURI == this.getTargetURI() ? String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + targetURI.trimSegments(1).toString().replace("platform:/resource", "") + "/HTMLReport" : String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + targetURI.toString().replace("platform:/resource", "");
        java.net.URI uri = java.net.URI.create(locationString);
        File file = new File(uri.toString());
        ArrayList arguments = new ArrayList();
        try {
            HtmlReport report = new HtmlReport((EObject)benchmark, file, arguments);
            report.doGenerate(null);
        }
        catch (Exception e) {
            MoDiscoLogger.logWarning((Throwable)e, (String)"Acceleo exception", (Plugin)Activator.getDefault());
        }
        BenchmarkChartGeneration chartGenerator = new BenchmarkChartGeneration(file, this.measureMemoryUse);
        chartGenerator.generateAll(benchmark);
        location.refreshLocal(2, progressMonitor);
    }

    private void setLaunchParameter(Discovery disco, AbstractModelDiscoverer<IProject> discoverer) {
        if (disco.getDiscovererLaunchConfiguration() != null) {
            for (ParameterValue pv : disco.getDiscovererLaunchConfiguration().getParameterValues()) {
                DiscovererParameter parameter = pv.getParameter();
                Object value = pv.getValue();
                if (value == null) continue;
                try {
                    if (parameter.getSetter() == null) {
                        parameter.setSetter(this.findSetter(discoverer.getClass(), parameter.getId()));
                    }
                    this.setValue(parameter, (IDiscoverer<?>)discoverer, value);
                }
                catch (DiscoveryException e) {
                    MoDiscoLogger.logWarning((Throwable)e, (String)e.getMessage(), (Plugin)Activator.getDefault());
                }
            }
        }
    }

    private Method findSetter(Class<? extends AbstractModelDiscoverer> clazz, String id) {
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p;
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(Parameter.class) && (p = method.getAnnotation(Parameter.class)).name().equals(id) && method.getReturnType().equals(Void.TYPE)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private void setValue(DiscovererParameter parameter, IDiscoverer<?> discoverer, Object parameterValue) throws DiscoveryException {
        block6: {
            try {
                if (parameter.getField() != null && Modifier.isPublic((int)parameter.getField().getModifiers())) {
                    parameter.getField().set(discoverer, parameterValue);
                    break block6;
                }
                if (parameter.getSetter() != null && Modifier.isPublic((int)parameter.getSetter().getModifiers())) {
                    parameter.getSetter().invoke(discoverer, parameterValue);
                    break block6;
                }
                throw new DiscoveryException(discoverer.getClass() + " discoverer does not implement public write access to the parameter " + parameter.getId());
            }
            catch (IllegalArgumentException e) {
                throw new DiscoveryException("Illegal parameter value for " + parameter.getId() + " : " + parameterValue, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new DiscoveryException("Illegal parameter value for " + parameter.getId() + " : " + parameterValue, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new DiscoveryException("Illegal parameter value for " + parameter.getId() + " : " + parameterValue, (Throwable)e);
            }
        }
    }

    private void saveTargetModel(Benchmark benchmark) throws IOException {
        if (this.getTargetURI() == null && this.getTargetModel() == null) {
            MoDiscoLogger.logWarning((String)"The parameter TARGET_URI should not be empty", (Plugin)Activator.getDefault());
            return;
        }
        if (benchmark.eResource() == null) {
            Resource res = null;
            res = this.getTargetModel() == null ? this.rSet.createResource(this.getTargetURI()) : this.rSet.createResource(this.getTargetModel().getURI());
            res.getContents().add((Object)benchmark);
            ArrayList<Event> eventsList = new ArrayList<Event>();
            ArrayList<EventType> eventTypeList = new ArrayList<EventType>();
            for (Discovery d : benchmark.getDiscoveries()) {
                for (DiscoveryIteration i : d.getIterations()) {
                    for (Event event : i.getEvents()) {
                        eventsList.add(event);
                        eventTypeList.add(event.getEventType());
                    }
                }
            }
            res.getContents().addAll(eventTypeList);
            this.setTargetModel(res);
        }
        this.saveTargetModel();
    }

    private long computeMaxMemoryUsage() {
        long max = 0L;
        for (MemoryMeasurement measure : this.memoryMeasurements) {
            if (max >= (long)measure.getMemoryUsed()) continue;
            max = measure.getMemoryUsed();
        }
        return max;
    }

    private Benchmark benchmarkInit() {
        Benchmark benchmark = BenchmarkFactory.eINSTANCE.createBenchmark();
        try {
            SystemInfo sysInfo = SystemInfo.getInstance();
            benchmark.setJvmMaxHeapInMiB(Runtime.getRuntime().maxMemory() / 0x100000L);
            benchmark.setProcessorName(sysInfo.getProcName());
            benchmark.setProcessorDescription(sysInfo.getProcDescription());
            benchmark.setProcessorCount(sysInfo.getnProcessors());
            benchmark.setProcessorCacheSize(sysInfo.getProcCacheSize());
            benchmark.setSystemMemory(sysInfo.getMemory());
            benchmark.setOsName(sysInfo.getOsName());
            benchmark.setOsVersion(sysInfo.getOsVersion());
            benchmark.setOsArchitecture(sysInfo.getArch());
        }
        catch (IOException e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Could not get system information for benchmark", (Plugin)Activator.getDefault());
        }
        return benchmark;
    }

    private void preDiscoveryDiscoInit(Project proj, Discovery disco, Discovery discoT, AbstractModelDiscoverer<IProject> discoverer, String discovererId) {
        disco.setProject((org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Resource)proj);
        disco.setName(discoverer.toString());
        disco.setDiscovererClassName(discoverer.getClass().getName());
        disco.setDiscovererId(discovererId);
        DiscovererDescription dd = CatalogFactory.eINSTANCE.createDiscovererDescription();
        if (discoT.getDiscovererLaunchConfiguration() != null) {
            LaunchConfiguration lc = LaunchFactory.eINSTANCE.createLaunchConfiguration();
            lc.setSource((Object)proj.getName());
            lc.setDiscoverer(dd);
            lc.setOpenModelAfterDiscovery(discoT.getDiscovererLaunchConfiguration().isOpenModelAfterDiscovery());
            for (ParameterValue pv : discoT.getDiscovererLaunchConfiguration().getParameterValues()) {
                ParameterValue newPv = LaunchFactory.eINSTANCE.createParameterValue();
                newPv.setValue(pv.getValue());
                DiscovererParameter param = CatalogFactory.eINSTANCE.createDiscovererParameter();
                param.setDescription(pv.getParameter().getDescription());
                param.setDirection(pv.getParameter().getDirection());
                param.setDiscoverer(dd);
                param.setField(pv.getParameter().getField());
                param.setGetter(pv.getParameter().getGetter());
                param.setId(pv.getParameter().getId());
                param.setInitializer(pv.getParameter().getInitializer());
                param.setRequiredInput(pv.getParameter().isRequiredInput());
                param.setSetter(pv.getParameter().getSetter());
                param.setType(pv.getParameter().getType());
                newPv.setParameter(param);
                lc.getParameterValues().add((Object)newPv);
            }
            disco.setDiscovererLaunchConfiguration(lc);
        }
        if (discoT.getCopyOfDiscovererDescription() == null) {
            dd.setId(disco.getDiscovererId());
            dd.setSourceType(proj.getClass());
            dd.setImplementationType(discoverer.getClass());
        } else {
            dd.setId(discoT.getCopyOfDiscovererDescription().getId());
            dd.setImplementationBundle(discoT.getCopyOfDiscovererDescription().getImplementationBundle());
            dd.setImplementationType(discoT.getCopyOfDiscovererDescription().getImplementationType());
            dd.setSourceType(discoT.getCopyOfDiscovererDescription().getSourceType());
        }
        disco.setCopyOfDiscovererDescription(dd);
    }

    private void postDiscoveryDiscoInit(Discovery disco, AbstractModelDiscoverer<IProject> discoverer) {
        double totalDiscoveryTime = 0.0;
        double totalSaveTime = 0.0;
        if (this.iterations > 0) {
            double maxDisco = 0.0;
            double maxSave = 0.0;
            double minDisco = ((DiscoveryIteration)disco.getIterations().get(0)).getDiscoveryTimeInSeconds();
            double minSave = ((DiscoveryIteration)disco.getIterations().get(0)).getSaveTimeInSeconds();
            for (DiscoveryIteration iter : disco.getIterations()) {
                totalSaveTime += iter.getSaveTimeInSeconds();
                totalDiscoveryTime += iter.getDiscoveryTimeInSeconds();
                if (iter.getDiscoveryTimeInSeconds() > maxDisco) {
                    maxDisco = iter.getDiscoveryTimeInSeconds();
                }
                if (iter.getSaveTimeInSeconds() > maxSave) {
                    maxSave = iter.getSaveTimeInSeconds();
                }
                if (iter.getDiscoveryTimeInSeconds() < minDisco) {
                    minDisco = iter.getDiscoveryTimeInSeconds();
                }
                if (!(iter.getSaveTimeInSeconds() < minSave)) continue;
                minSave = iter.getSaveTimeInSeconds();
            }
            disco.setDiscoveryTimeAverageInSeconds(totalDiscoveryTime / (double)this.iterations);
            disco.setSaveTimeAverageInSeconds(totalSaveTime / (double)this.iterations);
            disco.setExecutionTimeStandardDeviation(maxDisco - minDisco);
            disco.setSaveTimeStandardDeviation(maxSave - minSave);
            disco.setNumberOfModelElements(this.computeSize(discoverer.getTargetModel()));
            try {
                URI targetURI = discoverer.getTargetURI();
                String locationString = "file://" + ResourcesPlugin.getWorkspace().getRoot().getLocation().toString() + targetURI.toString();
                java.net.URI uri = java.net.URI.create(locationString);
                IFileStore fileStore = EFS.getStore((java.net.URI)uri);
                disco.setXmiSizeInBytes(fileStore.fetchInfo().getLength());
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (String)"Could not get output model size.", (Plugin)Activator.getDefault());
            }
        }
    }

    private DiscoveryIteration createDiscoveryIteration(EventAndMemoryRecorder rec) {
        DiscoveryIteration discoIter = BenchmarkFactory.eINSTANCE.createDiscoveryIteration();
        discoIter.setDiscoveryDate(new Date());
        discoIter.setMaxUsedMemoryInBytes((long)rec.getMaxMemoryUsed());
        discoIter.getEvents().addAll(rec.getEvents());
        discoIter.setDiscoveryTimeInSeconds((double)((rec.getStopTime() - rec.getStartTime()) / 1000L));
        for (Event event : rec.getEvents()) {
            if (!(event instanceof EndEvent) || !event.getEventType().getName().equals(SAVE_OPERATION)) continue;
            double saveTime = event.getTime() - ((EndEvent)event).getBeginning().getTime();
            discoIter.setSaveTimeInSeconds(saveTime / 1000.0);
            discoIter.setDiscoveryTimeInSeconds(discoIter.getDiscoveryTimeInSeconds() - discoIter.getSaveTimeInSeconds());
        }
        discoIter.getMemoryMeasurements().addAll(rec.getMemoryMeasurements());
        return discoIter;
    }

    private Project createBenchmarkProjectAndFiles(IProject project) {
        Project proj = BenchmarkFactory.eINSTANCE.createProject();
        proj.setName(project.getName());
        try {
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFolder) {
                    proj.getFiles().addAll(this.createFiles((IFolder)res, new LinkedList<org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File>()));
                } else if (res instanceof IFile) {
                    org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File f = this.createFile(res);
                    proj.getFiles().add((Object)f);
                }
                ++n2;
            }
            if (proj.getFiles().isEmpty()) {
                proj.setAverageFileSizeInBytes(0L);
                proj.setTotalSizeInBytes(0L);
                proj.setAverageLinesPerFile(0L);
                proj.setTotalLines(0L);
            } else {
                long totalLineSize = 0L;
                long totalByteSize = 0L;
                for (org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File f : proj.getFiles()) {
                    totalLineSize += f.getLines();
                    totalByteSize += f.getSizeInBytes();
                }
                proj.setAverageFileSizeInBytes(totalByteSize / (long)proj.getFiles().size());
                proj.setTotalSizeInBytes(totalByteSize);
                proj.setAverageLinesPerFile(totalLineSize / this.getNumberOfSourceCodeFiles(proj));
                proj.setTotalLines(totalLineSize);
            }
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Could not get members of project", (Plugin)Activator.getDefault());
        }
        return proj;
    }

    private long getNumberOfSourceCodeFiles(Project proj) {
        int number = 0;
        for (org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File file : proj.getFiles()) {
            if (file.getLines() != 0L) continue;
            ++number;
        }
        return number;
    }

    private List<org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File> createFiles(IFolder folder, List<org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File> files) throws CoreException {
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            if (res instanceof IFolder) {
                files.addAll(this.createFiles((IFolder)res, new LinkedList<org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File>()));
            } else if (res instanceof IFile) {
                org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File f = this.createFile(res);
                files.add(f);
            }
            ++n2;
        }
        return files;
    }

    private org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File createFile(IResource res) throws CoreException {
        IFileStore fileStore = EFS.getStore((java.net.URI)res.getLocationURI());
        org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.File f = BenchmarkFactory.eINSTANCE.createFile();
        f.setSizeInBytes(fileStore.fetchInfo().getLength());
        f.setFilepath(res.getFullPath().toString());
        f.setLines(this.getLineNumber(res));
        return f;
    }

    private long getLineNumber(IResource res) {
        int lines = 0;
        if (res == null) {
            MoDiscoLogger.logWarning((String)"Unable to compute the number of lines of an unexisting file", (Plugin)Activator.getDefault());
        } else if (res.getFileExtension() != null && res.getFileExtension().endsWith(CODE_EXTENSION)) {
            try {
                File f = new File(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + res.getFullPath().toString());
                BufferedReader br = new BufferedReader(new FileReader(f));
                lines = 0;
                while (br.readLine() != null) {
                    ++lines;
                }
                br.close();
            }
            catch (IOException e) {
                MoDiscoLogger.logWarning((Throwable)e, (String)("unable to count the number of lines of " + res.getName()), (Plugin)Activator.getDefault());
            }
            catch (NullPointerException e) {
                MoDiscoLogger.logWarning((Throwable)e, (String)("unable to count the number of lines of " + res.getName()), (Plugin)Activator.getDefault());
            }
        }
        return lines;
    }

    public boolean isApplicableTo(IProjectSet sources) {
        boolean result = true;
        for (IProject source : sources.getProjects()) {
            boolean bl = result = result && source.getProject().isAccessible();
        }
        return result;
    }

    protected void basicDiscoverElement(IProjectSet sources, IProgressMonitor monitor) throws DiscoveryException {
        this.discoverBenchmark(sources, monitor);
    }

    public EventAndMemoryRecorder getRecorder() {
        return this.recorder;
    }

    public void setRecorders(EventAndMemoryRecorder rec) {
        this.recorder = rec;
    }

    public void setDiscovererID(IDiscovererID discoId) {
        this.discovererID = discoId;
    }

    @Parameter(name="NUMBER_OF_ITERATIONS", description="The number of iterations to do.", requiresInputValue=true)
    public void setIterations(int it) {
        this.iterations = it;
    }

    @Parameter(name="MEASURE_MEMORY_USAGE", description="Tells if the memory usage should be measured or not.", requiresInputValue=true)
    public void setMeasureMemoryUse(boolean measure) {
        this.measureMemoryUse = measure;
        if (this.measureMemoryUse && this.memoryPollingInterval == 0) {
            this.memoryPollingInterval = 1000;
        }
    }

    @Parameter(name="MEMORY_POLLING_INTERVAL", description="The time interval between to memory measurement (default value is 1 sec)", requiresInputValue=false)
    public void setMemoryPollingInterval(int memoryInterval) {
        this.memoryPollingInterval = memoryInterval;
    }

    @Parameter(name="GENERATE_HTML_REPORT", description="Tells if a html report should be generated.", requiresInputValue=true)
    public void setGenerateHtmlReport(boolean generate) {
        this.generateHtmlReport = generate;
    }

    public void setTargetURI(URI targetURI) {
        super.setTargetURI(targetURI);
        super.setTargetModel(this.rSet.createResource(targetURI));
    }

    @Parameter(name="TARGET_URI")
    public URI getTargetURI() {
        return super.getTargetURI();
    }

    @Override
    public IDiscovererID getDiscovererID() {
        return this.discovererID;
    }

    @Override
    public int getIterations() {
        return this.iterations;
    }

    @Override
    public boolean isMeasureMemoryUse() {
        return this.measureMemoryUse;
    }

    @Override
    public int getMemoryPollingInterval() {
        return this.memoryPollingInterval;
    }

    @Override
    public boolean isGenerateHtmlReport() {
        return this.generateHtmlReport;
    }

    public URI getHtmlReportLocation() {
        return this.htmlReportLocation;
    }

    @Parameter(name="HTML_REPORT_LOCATION", description="Tells the location of the HTML report, should be set if GENERATE_HTML_REPORT is true", requiresInputValue=false)
    public void setHtmlReportLocation(URI htmlReportLocationParam) {
        this.htmlReportLocation = htmlReportLocationParam;
    }
}

