/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.Activator;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.api.IEventListener;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl.MemoryMeasurementJob;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Event;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.MemoryMeasurement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventAndMemoryRecorder
implements IEventListener {
    private long startTime;
    private long stopTime;
    private int maxMemoryUsed;
    private boolean measureMemoryUse;
    private List<MemoryMeasurement> memoryMeasurements;
    private List<Event> events;
    private MemoryMeasurementJob job;

    public EventAndMemoryRecorder(boolean measureMemoryUse, int memoryPollingInterval) {
        this.measureMemoryUse = measureMemoryUse;
        this.events = new LinkedList<Event>();
        this.memoryMeasurements = new LinkedList<MemoryMeasurement>();
        this.job = measureMemoryUse ? new MemoryMeasurementJob("MemoryMeasurementJob", memoryPollingInterval) : null;
    }

    public EventAndMemoryRecorder reset() {
        this.events = new LinkedList<Event>();
        this.memoryMeasurements = new LinkedList<MemoryMeasurement>();
        if (this.measureMemoryUse) {
            this.job.reset();
        }
        return this;
    }

    @Override
    public void notifyEvent(Event event) {
        this.events.add(event);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public int getMaxMemoryUsed() {
        return this.maxMemoryUsed;
    }

    public boolean isMeasureMemoryUse() {
        return this.measureMemoryUse;
    }

    public List<MemoryMeasurement> getMemoryMeasurements() {
        return this.memoryMeasurements;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        if (this.measureMemoryUse) {
            this.job.setJobStartTime(this.startTime);
            this.job.run((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void stop() {
        try {
            if (this.measureMemoryUse) {
                if (!this.job.cancel()) {
                    this.job.join();
                }
                this.memoryMeasurements.addAll(this.job.getMeasures());
            }
            this.stopTime = System.currentTimeMillis();
            this.maxMemoryUsed = 0;
            this.events.addAll(this.memoryMeasurements);
            for (MemoryMeasurement measure : this.memoryMeasurements) {
                if (measure.getMemoryUsed() <= this.maxMemoryUsed) continue;
                this.maxMemoryUsed = measure.getMemoryUsed();
            }
        }
        catch (InterruptedException e) {
            MoDiscoLogger.logError((Throwable)e, (String)"Problem with the memory recorder.", (Plugin)Activator.getDefault());
        }
    }
}

