/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.composition.discoverer;

import java.io.File;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractTypeDeclaration;
import org.eclipse.gmt.modisco.java.Archive;
import org.eclipse.gmt.modisco.java.CompilationUnit;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.gmt.modisco.java.actions.DefaultDiscoverer;
import org.eclipse.gmt.modisco.java.actions.DiscoverJavaModelFromJavaProject;
import org.eclipse.gmt.modisco.java.internal.util.JavaUtil;
import org.eclipse.gmt.modisco.omg.kdm.kdm.KDMModel;
import org.eclipse.gmt.modisco.omg.kdm.kdm.Segment;
import org.eclipse.gmt.modisco.omg.kdm.source.AbstractInventoryElement;
import org.eclipse.gmt.modisco.omg.kdm.source.BinaryFile;
import org.eclipse.gmt.modisco.omg.kdm.source.InventoryContainer;
import org.eclipse.gmt.modisco.omg.kdm.source.InventoryModel;
import org.eclipse.gmt.modisco.omg.kdm.source.SourceFile;
import org.eclipse.gmt.modisco.omg.kdm.source.util.KDMSourceUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.modisco.java.composition.discoverer.Activator;
import org.eclipse.modisco.java.composition.discoverer.Messages;
import org.eclipse.modisco.java.composition.discoverer.listeners.JavaCompositionSourceVisitListener;
import org.eclipse.modisco.java.composition.javaapplication.Java2Directory;
import org.eclipse.modisco.java.composition.javaapplication.Java2File;
import org.eclipse.modisco.java.composition.javaapplication.JavaApplication;
import org.eclipse.modisco.java.composition.javaapplication.JavaJar2File;
import org.eclipse.modisco.java.composition.javaapplication.JavaNodeSourceRegion;
import org.eclipse.modisco.java.composition.javaapplication.JavaapplicationFactory;
import org.eclipse.modisco.kdm.source.extension.discovery.AbstractComposedKDMSourceDiscoverer;
import org.eclipse.modisco.kdm.source.extension.discovery.SourceVisitListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DiscoverKDMSourceAndJavaModel
extends AbstractComposedKDMSourceDiscoverer {
    public static final int FLUSH_LIMIT = 10000;
    private static final String JAVA = "Java";
    private static List<DiscoveryParameter> parametersKeys = null;
    public static final DiscoveryParameter PARAMETERS_BEAN = DiscoverJavaModelFromJavaProject.PARAMETERS_BEAN;
    private static final String FRAGMENT_FOLDER_NAME = "java2kdmFragments";
    private ResourceSetImpl fResourceSet;
    private Resource javaModelResource = null;
    private Resource package2DirectoryResource = null;
    private Resource javaAppModelResource = null;
    private Map<Java2Directory, Resource> directoryToResourceFragmentMap = null;
    private Map<CompilationUnit, List<JavaNodeSourceRegion>> cuToRegionsMap = null;
    private Model javaModel = null;
    private Segment kdmModel = null;
    private JavaApplication javaApplication = null;
    private InventoryContainer container = null;
    private IProject project = null;
    private String resourceRootPath;
    private String resourceFragmentPath;
    private boolean isSilent;

    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IJavaProject) {
            result = true;
        } else if (source instanceof IProject) {
            IProject project2 = (IProject)source;
            try {
                if (project2.hasNature("org.eclipse.jdt.core.javanature")) {
                    result = true;
                }
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    public List<DiscoveryParameter> getDiscovererParameters() {
        if (parametersKeys == null) {
            parametersKeys = new ArrayList<DiscoveryParameter>();
            parametersKeys.add(DefaultDiscoverer.PARAMETER_SILENT_MODE);
            parametersKeys.add(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE);
            parametersKeys.add(DiscoverJavaModelFromJavaProject.PARAMETERS_BEAN);
        }
        return parametersKeys;
    }

    protected void initializeCompositeModel(Object source, Map<DiscoveryParameter, Object> parameters, IProgressMonitor monitor) {
        if (Activator.getDefault().isDebugging()) {
            System.out.println("--- Starting DiscoverKDMSourceAndJavaModel.initializeCompositeModel ---");
        }
        this.javaApplication = JavaapplicationFactory.eINSTANCE.createJavaApplication();
        this.setKdmSourceModelResource(null);
        this.javaModel = null;
        this.kdmModel = null;
        this.cuToRegionsMap = null;
        this.container = null;
        if (source instanceof IJavaProject) {
            this.project = ((IJavaProject)source).getProject();
        } else if (source instanceof IProject) {
            this.project = (IProject)source;
        }
        if (this.project == null) {
            throw new NullPointerException(Messages.DiscoverKDMSourceAndJavaModel_5);
        }
        if (parameters != null) {
            this.isSilent = Boolean.TRUE.equals(parameters.get(DefaultDiscoverer.PARAMETER_SILENT_MODE));
        }
        this.resourceRootPath = "platform:/resource/" + this.project.getProject().getName() + "/";
        this.resourceFragmentPath = String.valueOf(this.resourceRootPath) + "/" + FRAGMENT_FOLDER_NAME + "/";
        String pathJavaApp = String.valueOf(this.resourceRootPath) + this.project.getProject().getName() + "_java2kdm.xmi";
        String pathDirectory = String.valueOf(this.resourceFragmentPath) + "Package2Directory" + "_java2kdm.xmi";
        this.javaAppModelResource = this.getResource(pathJavaApp);
        this.package2DirectoryResource = this.getResource(pathDirectory);
        this.javaAppModelResource.getContents().add((Object)this.javaApplication);
    }

    protected void discoverOtherLeafModels(Object source, Map<DiscoveryParameter, Object> parameters, IProgressMonitor monitor) {
        if (Activator.getDefault().isDebugging()) {
            System.out.println("--- Starting DiscoverKDMSourceAndJavaModel.discoverOtherLeafModels ---");
        }
        try {
            this.discoverJavaModel(source, parameters, monitor);
        }
        catch (InterruptedException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    protected void completeModelsBuild(Object source, Map<DiscoveryParameter, Object> parameters, IProgressMonitor monitor) {
        if (Activator.getDefault().isDebugging()) {
            System.out.println("--- Starting DiscoverKDMSourceAndJavaModel.completeModelsBuild ---");
        }
        if (this.javaModelResource != null) {
            this.directoryToResourceFragmentMap = null;
            this.weaveModel();
            this.weaveCompilationUnit();
            this.weaveArchiveFile();
            try {
                this.saveAllResource(monitor);
            }
            catch (IOException e) {
                MoDiscoLogger.logError((String)e.getMessage(), (Plugin)Activator.getDefault());
            }
            if (this.javaAppModelResource != null) {
                if (parameters != null) {
                    parameters.put(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE, this.javaAppModelResource);
                } else {
                    MoDiscoLogger.logWarning((String)Messages.DiscoverKDMSourceAndJavaModel_12, (Plugin)Activator.getDefault());
                }
            } else if (Activator.getDefault().isDebugging()) {
                System.out.println("--- Starting JavaAppModelResource = null ---");
            }
        } else {
            if (Activator.getDefault().isDebugging()) {
                System.out.println("--- Starting JavaModelResource = null ---");
            }
            this.javaApplication = null;
            this.javaAppModelResource = null;
        }
        this.doFinally(monitor);
    }

    protected String getDiscoveryName() {
        return Messages.DiscoverKDMSourceAndJavaModel_6;
    }

    protected Resource getResultModel() {
        return this.getJavaAppModelResource();
    }

    protected boolean shouldOpenEditorOnResultModel() {
        return !this.isSilent;
    }

    @Deprecated
    public Resource discoverElement(Object source, URI target) {
        throw new RuntimeException("Should not be used.");
    }

    protected Resource getResource(String path) {
        if (this.fResourceSet == null) {
            this.fResourceSet = new ResourceSetImpl();
        }
        return this.fResourceSet.createResource(URI.createURI((String)path));
    }

    protected void doFinally(IProgressMonitor monitor) {
        monitor.done();
        this.setKdmSourceModelResource(null);
        this.javaModel = null;
        this.kdmModel = null;
        this.cuToRegionsMap = null;
        this.container = null;
    }

    void discoverJavaModel(Object source, Map<DiscoveryParameter, Object> parameters, IProgressMonitor monitor) throws InterruptedException {
        this.cuToRegionsMap = new HashMap<CompilationUnit, List<JavaNodeSourceRegion>>();
        this.javaModelResource = null;
        monitor.subTask(Messages.DiscoverKDMSourceAndJavaModel_10);
        Map<DiscoveryParameter, Object> parameterForJavaDiscovery = this.getJavaParameters(parameters);
        DiscoverJavaModelFromJavaProject javaDiscoverer = this.initJavaDiscoverer();
        javaDiscoverer.addSourceVisitListener(this.initSourceVisitListener());
        javaDiscoverer.discoverElement(source, parameterForJavaDiscovery);
        if (parameterForJavaDiscovery.get(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE) != null) {
            this.javaModelResource = (Resource)parameterForJavaDiscovery.get(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE);
        } else {
            monitor.setCanceled(true);
        }
    }

    protected Map<DiscoveryParameter, Object> getJavaParameters(Map<DiscoveryParameter, Object> parameters) {
        HashMap<DiscoveryParameter, Object> parameterForJavaDiscovery = new HashMap<DiscoveryParameter, Object>();
        parameterForJavaDiscovery.put(DefaultDiscoverer.PARAMETER_SILENT_MODE, new Boolean(this.isSilent));
        parameterForJavaDiscovery.put(DefaultDiscoverer.PARAMETER_BROWSE_RESULT, Boolean.FALSE);
        parameterForJavaDiscovery.put(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE, null);
        if (parameters != null && parameters.containsKey(PARAMETERS_BEAN)) {
            parameterForJavaDiscovery.put(PARAMETERS_BEAN, parameters.get(PARAMETERS_BEAN));
        }
        return parameterForJavaDiscovery;
    }

    protected DiscoverJavaModelFromJavaProject initJavaDiscoverer() {
        return new DiscoverJavaModelFromJavaProject();
    }

    protected SourceVisitListener initSourceVisitListener() {
        return new JavaCompositionSourceVisitListener(this.cuToRegionsMap);
    }

    void weaveModel() {
        this.javaApplication.setJavaModel(this.getJavaModel());
        this.javaApplication.setDeploymentModel((InventoryModel)this.getKdmModel().getModel().get(0));
    }

    private InventoryContainer getKDMProjectForWeaving() {
        block4: {
            try {
                if (this.container != null) break block4;
                InventoryModel invent = null;
                for (KDMModel kdmModelTmp : this.getKdmModel().getModel()) {
                    if (!(kdmModelTmp instanceof InventoryModel)) continue;
                    invent = (InventoryModel)kdmModelTmp;
                    break;
                }
                if (invent == null) break block4;
                for (AbstractInventoryElement absInvenElt : invent.getInventoryElement()) {
                    if (!(absInvenElt instanceof InventoryContainer)) continue;
                    this.container = (InventoryContainer)absInvenElt;
                    break;
                }
            }
            catch (NullPointerException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return this.container;
    }

    void weaveArchiveFile() {
        ArrayList listBinaryFiles = new ArrayList();
        listBinaryFiles.addAll(KDMSourceUtils.getBinaryFilesFromInventoryModel((InventoryContainer)this.getKDMProjectForWeaving(), null, (boolean)true));
        for (Archive archive : this.getJavaModel().getArchives()) {
            for (BinaryFile binaryFile : listBinaryFiles) {
                if (!binaryFile.getPath().equalsIgnoreCase(archive.getOriginalFilePath())) continue;
                JavaJar2File javaJar2File = JavaapplicationFactory.eINSTANCE.createJavaJar2File();
                javaJar2File.setJavaArchive(archive);
                javaJar2File.setFile(binaryFile);
                this.javaApplication.getJar2FileChildren().add((Object)javaJar2File);
            }
        }
    }

    void weaveCompilationUnit() {
        ArrayList<CompilationUnit> compilationUnitList = new ArrayList<CompilationUnit>();
        for (CompilationUnit cu : this.getJavaModel().getCompilationUnits()) {
            if (cu.getName().equals("package-info.java")) continue;
            compilationUnitList.add(cu);
        }
        ArrayList<String> filteredFileName = new ArrayList<String>();
        filteredFileName.add("bin");
        ArrayList sourceFileList = new ArrayList();
        sourceFileList.addAll(KDMSourceUtils.getSourceFileFromInventoryModel((InventoryContainer)this.getKDMProjectForWeaving(), filteredFileName, (boolean)true));
        block1: for (CompilationUnit compilationUnit : compilationUnitList) {
            Package pck = DiscoverKDMSourceAndJavaModel.getPackageFromCU(compilationUnit);
            Java2Directory java2Directory = this.getJava2DirectoryFromPackage(pck);
            if (java2Directory == null) {
                java2Directory = this.manageJava2DirectoryCreation(compilationUnit, pck);
            }
            for (SourceFile sourceFile : sourceFileList) {
                if (!new File(sourceFile.getPath()).equals(new File(compilationUnit.getOriginalFilePath()))) continue;
                Java2File java2File = JavaapplicationFactory.eINSTANCE.createJava2File();
                java2File.setFile(sourceFile);
                sourceFile.setLanguage(JAVA);
                java2File.setUnit((EObject)compilationUnit);
                if (this.cuToRegionsMap.get(compilationUnit) != null) {
                    java2File.getChildren().addAll(this.getAndSortChildren(compilationUnit));
                }
                if (this.getMapJava2DirectoryResource().containsKey(java2Directory)) {
                    this.getMapJava2DirectoryResource().get(java2Directory).getContents().add((Object)java2File);
                } else {
                    Resource resource = this.getResource(String.valueOf(this.resourceFragmentPath) + "/" + JavaUtil.getQualifiedName((ASTNode)java2Directory.getJavaPackage()) + "_java2kdm.xmi");
                    resource.getContents().add((Object)java2File);
                    this.getMapJava2DirectoryResource().put(java2Directory, resource);
                }
                java2Directory.getJava2FileChildren().add((Object)java2File);
                continue block1;
            }
        }
    }

    private List<JavaNodeSourceRegion> getAndSortChildren(CompilationUnit compilationUnit) {
        List<JavaNodeSourceRegion> toBeSortedJavaNodeList = this.cuToRegionsMap.get(compilationUnit);
        Comparator<JavaNodeSourceRegion> c = new Comparator<JavaNodeSourceRegion>(){

            @Override
            public int compare(JavaNodeSourceRegion o1, JavaNodeSourceRegion o2) {
                return o1.getStartPosition().compareTo(o2.getStartPosition());
            }
        };
        Collections.sort(toBeSortedJavaNodeList, c);
        return toBeSortedJavaNodeList;
    }

    private Java2Directory getJava2DirectoryFromPackage(Package pck) {
        Java2Directory java2Directory = null;
        if (pck != null) {
            for (EObject object : this.package2DirectoryResource.getContents()) {
                if (!((Java2Directory)object).getJavaPackage().equals(pck)) continue;
                java2Directory = (Java2Directory)object;
                break;
            }
        } else {
            MoDiscoLogger.logWarning((String)"No Package Found", (Plugin)Activator.getDefault());
        }
        return java2Directory;
    }

    private static Package getPackageFromCU(CompilationUnit compilationUnit) {
        Package pck = null;
        for (AbstractTypeDeclaration atd : compilationUnit.getTypes()) {
            pck = atd.getPackage();
            if (pck == null) continue;
            return pck;
        }
        return pck;
    }

    private Java2Directory manageJava2DirectoryCreation(CompilationUnit compilationUnit, Package pck) {
        Java2Directory java2Directory = JavaapplicationFactory.eINSTANCE.createJava2Directory();
        java2Directory.setJavaPackage(pck);
        String directoryPath = compilationUnit.getOriginalFilePath().substring(0, compilationUnit.getOriginalFilePath().lastIndexOf(File.separator));
        java2Directory.getDirectory().add((Object)KDMSourceUtils.getDirectoryByPath((String)directoryPath, (InventoryContainer)this.getKDMProjectForWeaving()));
        this.package2DirectoryResource.getContents().add((Object)java2Directory);
        this.javaApplication.getJava2DirectoryChildren().add((Object)java2Directory);
        return java2Directory;
    }

    protected void saveAllResource(IProgressMonitor monitor) throws IOException {
        monitor.subTask(Messages.DiscoverKDMSourceAndJavaModel_7);
        DiscoverKDMSourceAndJavaModel.saveResource(this.getJavaAppModelResource(), monitor);
        monitor.subTask(Messages.DiscoverKDMSourceAndJavaModel_8);
        DiscoverKDMSourceAndJavaModel.saveResource(this.getPackage2DirectoryResource(), monitor);
        monitor.subTask(Messages.DiscoverKDMSourceAndJavaModel_9);
        for (Resource r : this.getMapJava2DirectoryResource().values()) {
            DiscoverKDMSourceAndJavaModel.saveResource(r, monitor);
        }
    }

    private static void saveResource(Resource resource, IProgressMonitor monitor) throws IOException {
        HashMap<String, Constable> options = new HashMap<String, Constable>();
        options.put("FLUSH_THRESHOLD", new Integer(10000));
        options.put("USE_FILE_BUFFER", new Boolean(true));
        monitor.subTask(Messages.DiscoverKDMSourceAndJavaModel_4);
        try {
            resource.save(options);
        }
        catch (Resource.IOWrappedException e) {
            if (e.getCause() != null && e.getCause() instanceof CoreException) {
                MoDiscoLogger.logWarning((Throwable)e, (String)("XMI serialization has failed... Trying again without File Buffer. File is " + resource.getURI()), (Plugin)Activator.getDefault());
                options.clear();
                resource.save(options);
                MoDiscoLogger.logWarning((String)("XMI serialization is done for " + resource.getURI()), (Plugin)Activator.getDefault());
            }
            throw e;
        }
    }

    public Model getJavaModel() {
        if (this.javaModel == null) {
            if (this.getJavaModelResource() != null) {
                this.javaModel = (Model)this.getJavaModelResource().getContents().get(0);
            } else {
                throw new NullPointerException(Messages.DiscoverKDMSourceAndJavaModel_2);
            }
        }
        return this.javaModel;
    }

    public Segment getKdmModel() {
        if (this.kdmModel == null) {
            if (this.getKdmSourceModelResource() != null) {
                this.kdmModel = (Segment)this.getKdmSourceModelResource().getContents().get(0);
            } else {
                throw new NullPointerException(Messages.DiscoverKDMSourceAndJavaModel_3);
            }
        }
        return this.kdmModel;
    }

    private Map<Java2Directory, Resource> getMapJava2DirectoryResource() {
        if (this.directoryToResourceFragmentMap == null) {
            this.directoryToResourceFragmentMap = new HashMap<Java2Directory, Resource>();
        }
        return this.directoryToResourceFragmentMap;
    }

    public Resource getKdmSourceModelResource() {
        return super.getKdmSourceModelResource();
    }

    public Resource getPackage2DirectoryResource() {
        return this.package2DirectoryResource;
    }

    public Resource getJavaAppModelResource() {
        return this.javaAppModelResource;
    }

    public Map<CompilationUnit, List<JavaNodeSourceRegion>> getCuToRegionsMap() {
        return this.cuToRegionsMap;
    }

    public Resource getJavaModelResource() {
        return this.javaModelResource;
    }
}

