/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Messages;
import org.eclipse.gmt.modisco.workflow.WorkflowModel;
import org.eclipse.gmt.modisco.workflow.internal.engine.CreatePluginProject;
import org.eclipse.gmt.modisco.workflow.internal.ui.WorkflowTab;
import org.eclipse.gmt.modisco.workflow.internal.ui.export.Common;
import org.eclipse.gmt.modisco.workflow.internal.ui.export.ExportDialog;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class MoDiscoExportTab
extends AbstractLaunchConfigurationTab {
    private ScrolledComposite scrollContainer;
    private Composite rootContainer;
    private String idWorkflow;
    private Combo comboEngine;
    private final List<String> idEngineList = new ArrayList<String>();
    private Button buttonExportDiscoverer;
    private Button buttonExportModelInternal;
    private ILaunchConfiguration currentConfiguration;

    public void createControl(Composite parent) {
        this.scrollContainer = new ScrolledComposite(parent, 768);
        this.scrollContainer.setExpandHorizontal(true);
        this.scrollContainer.setExpandVertical(true);
        this.rootContainer = new Composite((Composite)this.scrollContainer, 0);
        GridLayout layoutRoot = new GridLayout();
        this.rootContainer.setLayout((Layout)layoutRoot);
        layoutRoot.numColumns = 1;
        layoutRoot.verticalSpacing = 9;
        this.scrollContainer.setContent((Control)this.rootContainer);
        this.createGroupWorkflowType();
        this.createGroupExport();
        this.initializeCombo();
        this.setControl((Control)this.rootContainer);
        this.setControl((Control)this.scrollContainer);
    }

    private void createGroupWorkflowType() {
        Group groupWorkflow = new Group(this.rootContainer, 0);
        groupWorkflow.setText(Messages.MoDiscoExportTab_0);
        GridLayout layoutGroup = new GridLayout();
        groupWorkflow.setLayout((Layout)layoutGroup);
        layoutGroup.numColumns = 3;
        layoutGroup.verticalSpacing = 9;
        GridData gdHoriz = new GridData(768);
        groupWorkflow.setLayoutData((Object)gdHoriz);
        Label labelWorkflow = new Label((Composite)groupWorkflow, 0);
        labelWorkflow.setText(Messages.MoDiscoExportTab_1);
        labelWorkflow.pack();
        this.comboEngine = new Combo((Composite)groupWorkflow, 8);
        this.comboEngine.setLayoutData((Object)gdHoriz);
        this.comboEngine.pack();
        this.comboEngine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MoDiscoExportTab.this.setIdWorkflow(MoDiscoExportTab.this.getIdEngineList().get(MoDiscoExportTab.this.getComboEngine().getSelectionIndex()));
                MoDiscoExportTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createGroupExport() {
        GridData gdText = new GridData();
        gdText.horizontalAlignment = 0x1000008;
        GridData gdLabel = new GridData();
        gdLabel.horizontalSpan = 2;
        gdLabel.grabExcessHorizontalSpace = true;
        Group groupExport = this.createGroup(this.rootContainer, Messages.MoDiscoExportTab_2, 3, 2, 768);
        Label nameDiscoverer = new Label((Composite)groupExport, 0);
        nameDiscoverer.setText(Messages.MoDiscoExportTab_3);
        this.buttonExportDiscoverer = this.createPushButton((Composite)groupExport, Messages.MoDiscoExportTab_4, Activator.getImageDescriptor("icons/exportIcon.png").createImage());
        this.buttonExportDiscoverer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MoDiscoExportTab.this.exportDiscoverer();
            }
        });
        nameDiscoverer.setLayoutData((Object)gdLabel);
        this.buttonExportDiscoverer.setLayoutData((Object)gdText);
        GridData gdLabel2 = new GridData();
        gdLabel2.horizontalSpan = 2;
        Label modelInternalLabel = new Label((Composite)groupExport, 0);
        modelInternalLabel.setText(Messages.MoDiscoExportTab_9);
        modelInternalLabel.setLayoutData((Object)gdLabel2);
        this.buttonExportModelInternal = this.createPushButton((Composite)groupExport, Messages.MoDiscoExportTab_10, Activator.getImageDescriptor("icons/exportIcon.png").createImage());
        this.buttonExportModelInternal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MoDiscoExportTab.this.handleExportLocationButtonSelected();
                Common.getInstance().refreshPackageExplorer();
            }
        });
        this.buttonExportModelInternal.setLayoutData((Object)gdText);
    }

    private final Group createGroup(Composite parent, String text, int columns, int hspan, int fill) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setText(text);
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }

    void exportDiscoverer() {
        IStatus status = this.verifyNameToExportDiscoverer();
        if (status.isOK()) {
            ExportDialog dialog = new ExportDialog(this.currentConfiguration.getName(), this.getShell());
            dialog.open();
            if (dialog.isExport()) {
                this.exportMoDiscoWorkflowToDiscovererProject(dialog.getProjectName(), dialog.getSymbolicName(), dialog.getBaseName());
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MoDiscoExportTab_12, (String)(String.valueOf(status.getMessage()) + Messages.MoDiscoExportTab_13));
        }
    }

    private final void exportMoDiscoWorkflowToDiscovererProject(String projectName, String symbolicName, String basePackageName) {
        try {
            new CreatePluginProject(symbolicName, basePackageName, this.getWorkflowModel());
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    private final IStatus verifyNameToExportDiscoverer() {
        for (Element modiscoWork : this.getWorkflowModel().getAllElements()) {
            IStatus status = JavaConventions.validateIdentifier((String)modiscoWork.getName(), (String)"org.eclipse.jdt.core.compiler.source", (String)"org.eclipse.jdt.core.compiler.compliance");
            if (status.isOK()) continue;
            return status;
        }
        return Status.OK_STATUS;
    }

    public String getName() {
        return Messages.MoDiscoExportTab_14;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.currentConfiguration = configuration;
        try {
            this.comboEngine.select(this.idEngineList.indexOf(configuration.getAttribute("org.eclipse.gmt.modisco.workflowIdWorkflowExecution", "org.eclipse.gmt.modisco.workflow.defaultengine")));
            this.idWorkflow = configuration.getAttribute("org.eclipse.gmt.modisco.workflowIdWorkflowExecution", "org.eclipse.gmt.modisco.workflow.defaultengine");
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.gmt.modisco.workflowIdWorkflowExecution", this.idWorkflow);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public Image getImage() {
        return Activator.getImageDescriptor("icons/exportIcon.png").createImage();
    }

    private void initializeCombo() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.gmt.modisco.workflow.engine");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals("workflowCore")) {
                    this.comboEngine.add(element.getAttribute("name"));
                    this.idEngineList.add(extension.getUniqueIdentifier());
                }
                ++n4;
            }
            ++n2;
        }
    }

    void handleExportLocationButtonSelected() {
        IWorkspaceRoot currentContainer = ResourcesPlugin.getWorkspace().getRoot();
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)currentContainer, false, Messages.MoDiscoExportTab_16);
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            path = path.addTrailingSeparator().append(this.getWorkflowModel().getName()).addFileExtension("modiscoworkflow");
            URI targetUri = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
            this.getWorkflowModel().exportWorkflow(targetUri);
            Common.getInstance().refreshPackageExplorer();
        }
    }

    private final WorkflowModel getWorkflowModel() {
        WorkflowModel controller = null;
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.getLaunchConfigurationDialog().getTabs();
        int n = iLaunchConfigurationTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            if (tab instanceof WorkflowTab) {
                controller = ((WorkflowTab)tab).getWorkflowModel();
                break;
            }
            ++n2;
        }
        return controller;
    }

    public void setIdWorkflow(String idWorkflow) {
        this.idWorkflow = idWorkflow;
    }

    public List<String> getIdEngineList() {
        return this.idEngineList;
    }

    public Combo getComboEngine() {
        return this.comboEngine;
    }
}

