/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.io.library;

import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.AbstractTypeDeclaration;
import org.eclipse.gmt.modisco.java.AbstractVariablesContainer;
import org.eclipse.gmt.modisco.java.Annotation;
import org.eclipse.gmt.modisco.java.AnnotationMemberValuePair;
import org.eclipse.gmt.modisco.java.AnnotationTypeMemberDeclaration;
import org.eclipse.gmt.modisco.java.Archive;
import org.eclipse.gmt.modisco.java.ArrayInitializer;
import org.eclipse.gmt.modisco.java.ArrayType;
import org.eclipse.gmt.modisco.java.BodyDeclaration;
import org.eclipse.gmt.modisco.java.BooleanLiteral;
import org.eclipse.gmt.modisco.java.CharacterLiteral;
import org.eclipse.gmt.modisco.java.ClassDeclaration;
import org.eclipse.gmt.modisco.java.ClassFile;
import org.eclipse.gmt.modisco.java.EnumConstantDeclaration;
import org.eclipse.gmt.modisco.java.EnumDeclaration;
import org.eclipse.gmt.modisco.java.Expression;
import org.eclipse.gmt.modisco.java.FieldDeclaration;
import org.eclipse.gmt.modisco.java.InheritanceKind;
import org.eclipse.gmt.modisco.java.MethodDeclaration;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.Modifier;
import org.eclipse.gmt.modisco.java.NamedElement;
import org.eclipse.gmt.modisco.java.NumberLiteral;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.gmt.modisco.java.ParameterizedType;
import org.eclipse.gmt.modisco.java.PrimitiveType;
import org.eclipse.gmt.modisco.java.SingleVariableAccess;
import org.eclipse.gmt.modisco.java.SingleVariableDeclaration;
import org.eclipse.gmt.modisco.java.StringLiteral;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.TypeAccess;
import org.eclipse.gmt.modisco.java.TypeDeclaration;
import org.eclipse.gmt.modisco.java.TypeLiteral;
import org.eclipse.gmt.modisco.java.TypeParameter;
import org.eclipse.gmt.modisco.java.UnresolvedItem;
import org.eclipse.gmt.modisco.java.UnresolvedItemAccess;
import org.eclipse.gmt.modisco.java.VariableDeclarationFragment;
import org.eclipse.gmt.modisco.java.VisibilityKind;
import org.eclipse.gmt.modisco.java.WildCardType;
import org.eclipse.gmt.modisco.java.emf.JavaFactory;
import org.eclipse.gmt.modisco.java.io.java.binding.Binding;
import org.eclipse.gmt.modisco.java.io.java.binding.BindingManager;
import org.eclipse.gmt.modisco.java.io.java.binding.ClassBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.FieldBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.MethodBinding;
import org.eclipse.gmt.modisco.java.io.java.binding.PendingElement;
import org.eclipse.gmt.modisco.java.io.library.ClassFileParserUtils;
import org.eclipse.gmt.modisco.java.io.library.LibraryReader;
import org.eclipse.gmt.modisco.java.io.library.TypeFinder;
import org.eclipse.gmt.modisco.java.io.library.binding.JavaModelDelegateBindingFactory;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

@Deprecated
public class ClassFileParser {
    private JavaFactory factory;
    private final Model model;
    private BindingManager globalBindings;
    private final TypeFinder typeFinder;
    private final String filePath;
    private ClassFile cuNode;
    private Package currentPackage;
    private IMember currentlyVisitedJavaElement = null;

    public ClassFileParser(JavaFactory factory, Model resultModel, BindingManager globalBindings, TypeFinder typeFinder, String filePath) {
        this.setFactory(factory);
        this.model = resultModel;
        this.setGlobalBindings(globalBindings);
        this.typeFinder = typeFinder;
        this.filePath = filePath;
    }

    public ITypeParameter findTypeParameter(String name) {
        IMember member = this.currentlyVisitedJavaElement;
        ITypeParameter typeParameter = null;
        while (member != null) {
            typeParameter = member.getElementType() == 9 ? ((IMethod)member).getTypeParameter(name) : ((IType)member).getTypeParameter(name);
            if (typeParameter.exists()) break;
            member = member.getDeclaringType();
        }
        return typeParameter;
    }

    public TypeFinder getTypeFinder() {
        return this.typeFinder;
    }

    public void initializeNode(ASTNode element) {
        element.setOriginalClassFile(this.cuNode);
    }

    public void parse(IClassFile classFile) throws JavaModelException {
        IType type = classFile.getType();
        if (!type.exists() || type.isAnonymous() || type.isLocal() || type.isMember()) {
            return;
        }
        Binding id = JavaModelDelegateBindingFactory.getInstance().getBindingForElement((IJavaElement)type, this);
        if (this.getGlobalBindings().containsTarget(id)) {
            return;
        }
        this.visitPackage(type.getPackageFragment());
        this.visitClassFile(classFile);
        Archive archive = LibraryReader.getArchive(classFile, this.getFactory(), this.model);
        if (archive != null) {
            archive.getClassFiles().add((Object)this.cuNode);
        } else {
            this.model.getClassFiles().add((Object)this.cuNode);
        }
        this.parse2(type, null);
    }

    protected void visitClassFile(IClassFile classFile) {
        ClassFile element = this.getFactory().createClassFile();
        this.model.getClassFiles().add((Object)element);
        element.setName(classFile.getElementName());
        element.setOriginalFilePath(this.filePath);
        element.setPackage(this.currentPackage);
        this.cuNode = element;
    }

    protected AbstractTypeDeclaration parse2(IType type, AbstractTypeDeclaration enclosingType) throws JavaModelException {
        AbstractTypeDeclaration typeDeclaration = this.visitType(type);
        if (enclosingType == null) {
            this.cuNode.setType(typeDeclaration);
        } else {
            enclosingType.getBodyDeclarations().add((Object)typeDeclaration);
        }
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField f = iFieldArray[n2];
            if (type.isEnum() && f.isEnumConstant()) {
                EnumConstantDeclaration constant = this.visitEnumConstantDeclaration(f);
                if (constant != null) {
                    ((EnumDeclaration)typeDeclaration).getEnumConstants().add((Object)constant);
                }
            } else {
                FieldDeclaration field = this.visitField(f);
                if (field != null) {
                    typeDeclaration.getBodyDeclarations().add((Object)field);
                }
            }
            ++n2;
        }
        iFieldArray = type.getMethods();
        n = iFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            IField m = iFieldArray[n2];
            Object method = null;
            method = type.isAnnotation() ? this.visitAnnotationTypeMemberDeclaration((IMethod)m) : this.visitMethod((IMethod)m);
            if (method != null) {
                typeDeclaration.getBodyDeclarations().add(method);
            }
            ++n2;
        }
        iFieldArray = type.getTypes();
        n = iFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            IField subType = iFieldArray[n2];
            if (subType.exists()) {
                this.parse2((IType)subType, typeDeclaration);
            }
            ++n2;
        }
        return typeDeclaration;
    }

    protected void visitPackage(IPackageFragment packageFragment) {
        Package element = null;
        if (!packageFragment.exists() || packageFragment.getElementName().length() == 0) {
            element = (Package)this.getGlobalBindings().getTarget("(default package)");
            if (element == null) {
                element = this.getFactory().createPackage();
                element.setName("(default package)");
                element.setModel(this.model);
                this.getGlobalBindings().addTarget("(default package)", (NamedElement)element);
            }
        } else {
            Binding id = JavaModelDelegateBindingFactory.getInstance().getBindingForElement((IJavaElement)packageFragment, this);
            if (!this.getGlobalBindings().containsTarget(id.toString())) {
                element = this.createPackageHierarchy(packageFragment);
                ClassFileParserUtils.manageBindingDeclaration((NamedElement)element, (IJavaElement)packageFragment, this);
            } else {
                element = (Package)this.getGlobalBindings().getTarget(id.toString());
            }
        }
        this.currentPackage = element;
    }

    protected Package createPackageHierarchy(IPackageFragment packageFragment) {
        Package result = this.getFactory().createPackage();
        Binding id = JavaModelDelegateBindingFactory.getInstance().getBindingForElement((IJavaElement)packageFragment, this);
        String currentPackageName = id.getName();
        Package localCurrentPackage = result;
        int lastDotIndex = currentPackageName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            this.model.getOwnedElements().add((Object)result);
            localCurrentPackage.setName(currentPackageName);
        } else {
            localCurrentPackage.setName(currentPackageName.substring(lastDotIndex + 1));
            while (lastDotIndex > 0) {
                currentPackageName = currentPackageName.substring(0, lastDotIndex);
                Package aParentPackage = null;
                if (!this.getGlobalBindings().containsTarget(currentPackageName)) {
                    aParentPackage = this.getFactory().createPackage();
                    this.getGlobalBindings().addTarget(currentPackageName, (NamedElement)aParentPackage);
                    lastDotIndex = currentPackageName.lastIndexOf(46);
                    if (lastDotIndex < 0) {
                        this.model.getOwnedElements().add((Object)aParentPackage);
                        aParentPackage.setName(currentPackageName);
                    } else {
                        aParentPackage.setName(currentPackageName.substring(lastDotIndex + 1));
                    }
                } else {
                    aParentPackage = (Package)this.getGlobalBindings().getTarget(currentPackageName);
                    aParentPackage.getOwnedPackages().add((Object)localCurrentPackage);
                    break;
                }
                aParentPackage.getOwnedPackages().add((Object)localCurrentPackage);
                localCurrentPackage = aParentPackage;
            }
        }
        return result;
    }

    protected AbstractTypeDeclaration visitType(IType type) throws JavaModelException {
        ITypeParameter[] parameters;
        int n;
        Object element = null;
        element = type.isEnum() ? this.getFactory().createEnumDeclaration() : (type.isAnnotation() ? this.getFactory().createAnnotationTypeDeclaration() : (type.isInterface() ? this.getFactory().createInterfaceDeclaration() : this.getFactory().createClassDeclaration()));
        this.currentlyVisitedJavaElement = type;
        this.initializeNode((ASTNode)element);
        element.setName(type.getElementName());
        element.setPackage(this.currentPackage);
        this.currentPackage.getOwnedElements().add(element);
        String superClass = type.getSuperclassTypeSignature();
        if (type.isClass() && superClass != null && !ClassFileParserUtils.isJavaLangObject(superClass)) {
            ((ClassDeclaration)element).setSuperClass(this.getRefOnType(superClass));
        }
        if (!type.isAnnotation()) {
            String[] stringArray = type.getSuperInterfaceTypeSignatures();
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String superInterface = stringArray[n2];
                if (!ClassFileParserUtils.isJavaLangObject(superInterface)) {
                    element.getSuperInterfaces().add((Object)this.getRefOnType(superInterface));
                }
                ++n2;
            }
        }
        ITypeParameter[] iTypeParameterArray = parameters = type.getTypeParameters();
        int n3 = parameters.length;
        n = 0;
        while (n < n3) {
            ITypeParameter parameter = iTypeParameterArray[n];
            TypeParameter t = this.getFactory().createTypeParameter();
            ((TypeDeclaration)element).getTypeParameters().add((Object)t);
            this.visitTypeParameter(parameter, t);
            ++n;
        }
        iTypeParameterArray = type.getAnnotations();
        n3 = iTypeParameterArray.length;
        n = 0;
        while (n < n3) {
            ITypeParameter annotation = iTypeParameterArray[n];
            Annotation anno = this.getFactory().createAnnotation();
            element.getAnnotations().add((Object)anno);
            this.visitAnnotation((IAnnotation)annotation, anno);
            ++n;
        }
        Modifier m = this.getFactory().createModifier();
        element.setModifier(m);
        m.setBodyDeclaration((BodyDeclaration)element);
        this.manageModifier(m, type.getFlags(), (IJavaElement)type);
        ClassFileParserUtils.manageBindingDeclaration((NamedElement)element, (IJavaElement)type, this);
        return element;
    }

    protected FieldDeclaration visitField(IField field) throws JavaModelException {
        if (Flags.isSynthetic((int)field.getFlags())) {
            return null;
        }
        FieldDeclaration element = this.getFactory().createFieldDeclaration();
        this.initializeNode((ASTNode)element);
        String type = field.getTypeSignature();
        element.setType(this.getRefOnType(type));
        Modifier m = this.getFactory().createModifier();
        element.setModifier(m);
        m.setBodyDeclaration((BodyDeclaration)element);
        this.manageModifier(m, field.getFlags(), (IJavaElement)field);
        VariableDeclarationFragment fragment = this.getFactory().createVariableDeclarationFragment();
        this.initializeNode((ASTNode)fragment);
        fragment.setExtraArrayDimensions(0);
        fragment.setName(field.getElementName());
        fragment.setVariablesContainer((AbstractVariablesContainer)element);
        IAnnotation[] iAnnotationArray = field.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            Annotation anno = this.getFactory().createAnnotation();
            element.getAnnotations().add((Object)anno);
            this.visitAnnotation(annotation, anno);
            ++n2;
        }
        ClassFileParserUtils.manageBindingDeclaration((NamedElement)fragment, (IJavaElement)field, this);
        return element;
    }

    protected AnnotationTypeMemberDeclaration visitAnnotationTypeMemberDeclaration(IMethod method) throws JavaModelException {
        AnnotationTypeMemberDeclaration element = this.getFactory().createAnnotationTypeMemberDeclaration();
        this.initializeNode((ASTNode)element);
        element.setName(method.getElementName());
        element.setType(this.getRefOnType(method.getReturnType()));
        IMemberValuePair defaultValue = method.getDefaultValue();
        if (defaultValue != null) {
            Expression result = this.manageMemberValuePair(defaultValue);
            element.setDefault(result);
        }
        Modifier m = this.getFactory().createModifier();
        m.setBodyDeclaration((BodyDeclaration)element);
        element.setModifier(m);
        this.manageModifier(m, method.getFlags(), (IJavaElement)method);
        ClassFileParserUtils.manageBindingDeclaration((NamedElement)element, (IJavaElement)method, this);
        return element;
    }

    protected EnumConstantDeclaration visitEnumConstantDeclaration(IField field) throws JavaModelException {
        EnumConstantDeclaration element = this.getFactory().createEnumConstantDeclaration();
        this.initializeNode((ASTNode)element);
        element.setName(field.getElementName());
        element.setModifier(this.getFactory().createModifier());
        IAnnotation[] iAnnotationArray = field.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            Annotation anno = this.getFactory().createAnnotation();
            element.getAnnotations().add((Object)anno);
            this.visitAnnotation(annotation, anno);
            ++n2;
        }
        ClassFileParserUtils.manageBindingDeclaration((NamedElement)element, (IJavaElement)field, this);
        return element;
    }

    protected AbstractMethodDeclaration visitMethod(IMethod method) throws JavaModelException {
        ITypeParameter[] parameters;
        if (Flags.isSynthetic((int)method.getFlags()) || Flags.isBridge((int)method.getFlags()) || method.getElementName().equals("<clinit>")) {
            return null;
        }
        this.currentlyVisitedJavaElement = method;
        Object element = null;
        element = method.isConstructor() ? this.getFactory().createConstructorDeclaration() : this.getFactory().createMethodDeclaration();
        this.initializeNode((ASTNode)element);
        element.setName(method.getElementName());
        String[] stringArray = method.getExceptionTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String exc = stringArray[n2];
            element.getThrownExceptions().add((Object)this.getRefOnType(exc));
            ++n2;
        }
        if (!method.isConstructor()) {
            String returnType = method.getReturnType();
            ((MethodDeclaration)element).setReturnType(this.getRefOnType(returnType));
        }
        ITypeParameter[] iTypeParameterArray = parameters = method.getTypeParameters();
        int n3 = parameters.length;
        n = 0;
        while (n < n3) {
            ITypeParameter parameter = iTypeParameterArray[n];
            TypeParameter t = this.getFactory().createTypeParameter();
            element.getTypeParameters().add((Object)t);
            this.visitTypeParameter(parameter, t);
            ++n;
        }
        int i = 0;
        while (i < method.getNumberOfParameters()) {
            String parameterType = method.getParameterTypes()[i];
            String parameterName = method.getRawParameterNames()[i];
            SingleVariableDeclaration var = this.getFactory().createSingleVariableDeclaration();
            this.initializeNode((ASTNode)var);
            element.getParameters().add((Object)var);
            var.setMethodDeclaration((AbstractMethodDeclaration)element);
            var.setName(parameterName);
            var.setExtraArrayDimensions(0);
            if (i == method.getNumberOfParameters() - 1) {
                boolean isMethodVarargs = Flags.isVarargs((int)method.getFlags());
                var.setVarargs(isMethodVarargs);
            }
            var.setType(this.getRefOnType(parameterType));
            ++i;
        }
        iTypeParameterArray = method.getAnnotations();
        int n4 = iTypeParameterArray.length;
        int n5 = 0;
        while (n5 < n4) {
            ITypeParameter annotation = iTypeParameterArray[n5];
            Annotation anno = this.getFactory().createAnnotation();
            element.getAnnotations().add((Object)anno);
            this.visitAnnotation((IAnnotation)annotation, anno);
            ++n5;
        }
        Modifier m = this.getFactory().createModifier();
        element.setModifier(m);
        m.setBodyDeclaration((BodyDeclaration)element);
        this.manageModifier(m, method.getFlags(), (IJavaElement)method);
        ClassFileParserUtils.manageBindingDeclaration((NamedElement)element, (IJavaElement)method, this);
        return element;
    }

    protected void visitAnnotation(IAnnotation annotation, Annotation anno) throws JavaModelException {
        this.initializeNode((ASTNode)anno);
        String typeName = annotation.getElementName();
        String typeSignature = Signature.createTypeSignature((String)typeName, (boolean)true);
        anno.setType(this.getRefOnType(typeSignature));
        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
        int n = iMemberValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair valuePair = iMemberValuePairArray[n2];
            AnnotationMemberValuePair element = this.getFactory().createAnnotationMemberValuePair();
            this.initializeNode((ASTNode)element);
            anno.getValues().add((Object)element);
            Expression value = this.manageMemberValuePair(valuePair);
            element.setValue(value);
            PendingElement pending = new PendingElement(this.getFactory());
            pending.setClientNode((ASTNode)element);
            pending.setLinkName("member");
            Binding id = null;
            if (this.typeFinder.isTypeExists(typeName)) {
                ClassBinding parent = JavaModelDelegateBindingFactory.getInstance().getBindingForName(typeSignature, this, true);
                id = new MethodBinding();
                ((MethodBinding)id).setDeclaringClass(parent);
                id.setName(valuePair.getMemberName());
            } else {
                id = new Binding();
                id.setName(String.valueOf(typeName) + "." + valuePair.getMemberName() + "()");
            }
            this.getGlobalBindings().addPending(pending, id);
            ++n2;
        }
    }

    private Expression manageMemberValuePair(IMemberValuePair defaultValue) {
        Expression result = null;
        switch (defaultValue.getValueKind()) {
            case 11: {
                result = this.manageValuePairClassKind(defaultValue);
                break;
            }
            case 10: {
                result = this.manageValuePairAnnotationKind(defaultValue);
                break;
            }
            case 12: {
                result = this.manageValuePairQualifiedNameKind(defaultValue);
                break;
            }
            case 8: {
                if (defaultValue.getValue().getClass().isArray()) {
                    Object[] tab = (Object[])defaultValue.getValue();
                    ArrayInitializer array = this.getFactory().createArrayInitializer();
                    this.initializeNode((ASTNode)array);
                    Object[] objectArray = tab;
                    int n = tab.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        BooleanLiteral bool = this.getFactory().createBooleanLiteral();
                        bool.setValue(((Boolean)element).booleanValue());
                        array.getExpressions().add((Object)bool);
                        ++n2;
                    }
                    result = array;
                    break;
                }
                BooleanLiteral bool = this.getFactory().createBooleanLiteral();
                bool.setValue(((Boolean)defaultValue.getValue()).booleanValue());
                result = bool;
                break;
            }
            case 4: {
                if (defaultValue.getValue().getClass().isArray()) {
                    Object[] tab = (Object[])defaultValue.getValue();
                    ArrayInitializer array = this.getFactory().createArrayInitializer();
                    this.initializeNode((ASTNode)array);
                    Object[] objectArray = tab;
                    int n = tab.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object element = objectArray[n3];
                        CharacterLiteral ch = this.getFactory().createCharacterLiteral();
                        char value = ((Character)element).charValue();
                        ch.setEscapedValue(ClassFileParserUtils.escapeCharacter(value));
                        array.getExpressions().add((Object)ch);
                        ++n3;
                    }
                    result = array;
                    break;
                }
                CharacterLiteral ch = this.getFactory().createCharacterLiteral();
                char value = ((Character)defaultValue.getValue()).charValue();
                ch.setEscapedValue(ClassFileParserUtils.escapeCharacter(value));
                result = ch;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                if (defaultValue.getValue().getClass().isArray()) {
                    Object[] tab = (Object[])defaultValue.getValue();
                    ArrayInitializer array = this.getFactory().createArrayInitializer();
                    this.initializeNode((ASTNode)array);
                    Object[] objectArray = tab;
                    int n = tab.length;
                    int n4 = 0;
                    while (n4 < n) {
                        Object element = objectArray[n4];
                        NumberLiteral number = this.getFactory().createNumberLiteral();
                        number.setTokenValue(element.toString());
                        array.getExpressions().add((Object)number);
                        ++n4;
                    }
                    result = array;
                    break;
                }
                NumberLiteral number = this.getFactory().createNumberLiteral();
                number.setTokenValue(defaultValue.getValue().toString());
                result = number;
                break;
            }
            case 9: {
                if (defaultValue.getValue().getClass().isArray()) {
                    Object[] tab = (Object[])defaultValue.getValue();
                    ArrayInitializer array = this.getFactory().createArrayInitializer();
                    this.initializeNode((ASTNode)array);
                    Object[] objectArray = tab;
                    int n = tab.length;
                    int n5 = 0;
                    while (n5 < n) {
                        Object element = objectArray[n5];
                        StringLiteral string = this.getFactory().createStringLiteral();
                        String value = String.valueOf(element);
                        string.setEscapedValue(ClassFileParserUtils.escapeString(value));
                        array.getExpressions().add((Object)string);
                        ++n5;
                    }
                    result = array;
                    break;
                }
                StringLiteral string = this.getFactory().createStringLiteral();
                String value = String.valueOf(defaultValue.getValue());
                string.setEscapedValue(ClassFileParserUtils.escapeString(value));
                result = string;
                break;
            }
            default: {
                if (defaultValue.getValue().getClass().isArray()) {
                    Object[] tab = (Object[])defaultValue.getValue();
                    ArrayInitializer array = this.getFactory().createArrayInitializer();
                    this.initializeNode((ASTNode)array);
                    Object[] objectArray = tab;
                    int n = tab.length;
                    int n6 = 0;
                    while (n6 < n) {
                        Object element = objectArray[n6];
                        UnresolvedItemAccess unrAcc = this.getFactory().createUnresolvedItemAccess();
                        UnresolvedItem item = this.getFactory().createUnresolvedItem();
                        unrAcc.setElement(item);
                        item.setName(String.valueOf(element));
                        array.getExpressions().add((Object)unrAcc);
                        ++n6;
                    }
                    result = array;
                    break;
                }
                UnresolvedItemAccess unrAcc = this.getFactory().createUnresolvedItemAccess();
                UnresolvedItem item = this.getFactory().createUnresolvedItem();
                unrAcc.setElement(item);
                item.setName(String.valueOf(defaultValue.getValue()));
                result = unrAcc;
            }
        }
        return result;
    }

    private Expression manageValuePairQualifiedNameKind(IMemberValuePair defaultValue) {
        ArrayInitializer result;
        if (defaultValue.getValue().getClass().isArray()) {
            Object[] tab = (Object[])defaultValue.getValue();
            ArrayInitializer array = this.getFactory().createArrayInitializer();
            this.initializeNode((ASTNode)array);
            Object[] objectArray = tab;
            int n = tab.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                SingleVariableAccess varAcc = this.getFactory().createSingleVariableAccess();
                PendingElement pending = new PendingElement(this.getFactory());
                pending.setClientNode((ASTNode)varAcc);
                pending.setLinkName("variable");
                String name = String.valueOf(element.toString());
                String memberName = name.substring(name.lastIndexOf(46) + 1);
                String typeName = name.substring(0, name.lastIndexOf(46));
                Binding id = null;
                if (this.typeFinder.isTypeExists(typeName)) {
                    ClassBinding parent = JavaModelDelegateBindingFactory.getInstance().getBindingForName(Signature.createTypeSignature((String)typeName, (boolean)true), this, true);
                    id = new FieldBinding();
                    ((FieldBinding)id).setDeclaringClass(parent);
                    id.setName(memberName);
                } else {
                    id = new Binding();
                    id.setName(String.valueOf(typeName) + "." + memberName);
                }
                this.getGlobalBindings().addPending(pending, id);
                array.getExpressions().add((Object)varAcc);
                ++n2;
            }
            result = array;
        } else {
            SingleVariableAccess varAcc = this.getFactory().createSingleVariableAccess();
            PendingElement pending = new PendingElement(this.getFactory());
            pending.setClientNode((ASTNode)varAcc);
            pending.setLinkName("variable");
            String name = String.valueOf(defaultValue.getValue());
            String memberName = name.substring(name.lastIndexOf(46) + 1);
            String typeName = name.substring(0, name.lastIndexOf(46));
            Binding id = null;
            if (this.typeFinder.isTypeExists(typeName)) {
                ClassBinding parent = JavaModelDelegateBindingFactory.getInstance().getBindingForName(Signature.createTypeSignature((String)typeName, (boolean)true), this, true);
                id = new FieldBinding();
                ((FieldBinding)id).setDeclaringClass(parent);
                id.setName(memberName);
            } else {
                id = new Binding();
                id.setName(String.valueOf(typeName) + "." + memberName);
            }
            this.getGlobalBindings().addPending(pending, id);
            result = varAcc;
        }
        return result;
    }

    private Expression manageValuePairAnnotationKind(IMemberValuePair defaultValue) {
        Annotation result;
        if (defaultValue.getValue().getClass().isArray()) {
            Object[] tab = (Object[])defaultValue.getValue();
            ArrayInitializer array = this.getFactory().createArrayInitializer();
            this.initializeNode((ASTNode)array);
            Object[] objectArray = tab;
            int n = tab.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                IAnnotation annotation = (IAnnotation)element;
                Annotation anno = this.getFactory().createAnnotation();
                try {
                    this.visitAnnotation(annotation, anno);
                }
                catch (JavaModelException javaModelException) {}
                array.getExpressions().add((Object)anno);
                ++n2;
            }
            result = array;
        } else {
            IAnnotation annotation = (IAnnotation)defaultValue.getValue();
            Annotation anno = this.getFactory().createAnnotation();
            try {
                this.visitAnnotation(annotation, anno);
            }
            catch (JavaModelException javaModelException) {}
            result = anno;
        }
        return result;
    }

    private Expression manageValuePairClassKind(IMemberValuePair defaultValue) {
        TypeLiteral result;
        if (defaultValue.getValue().getClass().isArray()) {
            Object[] tab = (Object[])defaultValue.getValue();
            ArrayInitializer array = this.getFactory().createArrayInitializer();
            this.initializeNode((ASTNode)array);
            Object[] objectArray = tab;
            int n = tab.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                String typeName = element.toString();
                String typeSignature = Signature.createTypeSignature((String)typeName, (boolean)true);
                TypeLiteral literal = this.getFactory().createTypeLiteral();
                literal.setType(this.getRefOnType(typeSignature));
                array.getExpressions().add((Object)literal);
                ++n2;
            }
            result = array;
        } else {
            String typeName = defaultValue.getValue().toString();
            String typeSignature = Signature.createTypeSignature((String)typeName, (boolean)true);
            TypeLiteral literal = this.getFactory().createTypeLiteral();
            literal.setType(this.getRefOnType(typeSignature));
            result = literal;
        }
        return result;
    }

    protected void visitTypeParameter(ITypeParameter typeParameter, TypeParameter element) throws JavaModelException {
        String[] boundsNames;
        this.initializeNode((ASTNode)element);
        element.setName(typeParameter.getElementName());
        String[] stringArray = boundsNames = typeParameter.getBounds();
        int n = boundsNames.length;
        int n2 = 0;
        while (n2 < n) {
            String bound = stringArray[n2];
            String boundSignature = Signature.createTypeSignature((String)bound, (boolean)true);
            if (!ClassFileParserUtils.isJavaLangObject(boundSignature)) {
                element.getBounds().add((Object)this.getRefOnType(boundSignature));
            }
            ++n2;
        }
        ClassFileParserUtils.manageBindingDeclaration((NamedElement)element, (IJavaElement)typeParameter, this);
    }

    private TypeAccess getRefOnType(String qualifiedName) {
        TypeAccess typAcc = this.getFactory().createTypeAccess();
        switch (Signature.getTypeSignatureKind((String)qualifiedName)) {
            case 4: {
                this.visitArrayType(typAcc, qualifiedName, this);
                break;
            }
            case 2: {
                this.visitPrimitiveType(typAcc, qualifiedName);
                break;
            }
            case 1: {
                if (Signature.getTypeArguments((String)qualifiedName).length > 0) {
                    this.visitParameterizedType(typAcc, qualifiedName);
                    break;
                }
                ClassFileParserUtils.manageBindingRef(typAcc, qualifiedName, this);
                break;
            }
            case 5: {
                this.visitWildCardType(typAcc, qualifiedName);
                break;
            }
            case 3: {
                ClassFileParserUtils.manageBindingRef(typAcc, qualifiedName, this);
                break;
            }
            case 6: {
                ClassFileParserUtils.manageBindingRef(typAcc, JavaModelDelegateBindingFactory.JAVA_LANG_OBJECT_SIGNATURE, this);
            }
        }
        return typAcc;
    }

    protected void visitParameterizedType(TypeAccess type, String qualifiedName) {
        ClassBinding id = JavaModelDelegateBindingFactory.getInstance().getBindingForParameterizedType(qualifiedName, this, false);
        ParameterizedType parameterizedType = (ParameterizedType)this.getGlobalBindings().getTarget(id);
        if (parameterizedType == null) {
            String[] typeArgumentsSignatures;
            parameterizedType = this.getFactory().createParameterizedType();
            parameterizedType.setName(((Binding)id).toString());
            parameterizedType.setType(this.getRefOnType(Signature.getTypeErasure((String)qualifiedName)));
            String[] stringArray = typeArgumentsSignatures = Signature.getTypeArguments((String)qualifiedName);
            int n = typeArgumentsSignatures.length;
            int n2 = 0;
            while (n2 < n) {
                String typeArgumentsSignature = stringArray[n2];
                parameterizedType.getTypeArguments().add((Object)this.getRefOnType(typeArgumentsSignature));
                ++n2;
            }
            this.model.getOrphanTypes().add((Object)parameterizedType);
            this.getGlobalBindings().addTarget(id, (NamedElement)parameterizedType);
        }
        type.setType((Type)parameterizedType);
    }

    protected void visitWildCardType(TypeAccess type, String qualifiedName) {
        ClassBinding id = JavaModelDelegateBindingFactory.getInstance().getBindingForWildCardType(qualifiedName, this);
        WildCardType wildCardType = (WildCardType)this.getGlobalBindings().getTarget(id);
        if (wildCardType == null) {
            wildCardType = this.getFactory().createWildCardType();
            boolean isUpperBound = false;
            String boundSignature = null;
            switch (qualifiedName.charAt(0)) {
                case '+': {
                    isUpperBound = true;
                    break;
                }
                case '-': {
                    boundSignature = qualifiedName.substring(1);
                    break;
                }
                case '*': {
                    break;
                }
            }
            if (boundSignature != null) {
                wildCardType.setBound(this.getRefOnType(boundSignature));
            }
            wildCardType.setUpperBound(isUpperBound);
            wildCardType.setName(((Binding)id).toString());
            this.model.getOrphanTypes().add((Object)wildCardType);
            this.getGlobalBindings().addTarget(id, (NamedElement)wildCardType);
        }
        type.setType((Type)wildCardType);
    }

    protected void visitPrimitiveType(TypeAccess type, String qualifiedName) {
        ClassBinding id = JavaModelDelegateBindingFactory.getInstance().getBindingForPrimitiveType(qualifiedName, this);
        PrimitiveType primitiveType = (PrimitiveType)this.getGlobalBindings().getTarget(((Binding)id).toString());
        if (primitiveType == null) {
            ClassFileParserUtils.initializePrimitiveTypes(this.getFactory(), this.model, this.getGlobalBindings());
            primitiveType = (PrimitiveType)this.getGlobalBindings().getTarget(((Binding)id).toString());
        }
        if (primitiveType == null) {
            primitiveType = this.getFactory().createPrimitiveType();
            primitiveType.setName(((Binding)id).toString());
            this.model.getOrphanTypes().add((Object)primitiveType);
            this.getGlobalBindings().addTarget(id, (NamedElement)primitiveType);
        }
        type.setType((Type)primitiveType);
    }

    protected void visitArrayType(TypeAccess typAcc, String qualifiedName, ClassFileParser visitor) {
        ClassBinding id = JavaModelDelegateBindingFactory.getInstance().getBindingForArrayType(qualifiedName, visitor, false);
        ArrayType arrayType = (ArrayType)this.getGlobalBindings().getTarget(((Binding)id).toString());
        if (arrayType == null) {
            arrayType = this.getFactory().createArrayType();
            arrayType.setDimensions(Signature.getArrayCount((String)qualifiedName));
            arrayType.setName(((Binding)id).toString());
            arrayType.setElementType(this.getRefOnType(Signature.getElementType((String)qualifiedName)));
            this.model.getOrphanTypes().add((Object)arrayType);
            this.getGlobalBindings().addTarget(id, (NamedElement)arrayType);
        }
        typAcc.setType((Type)arrayType);
    }

    private void manageModifier(Modifier modiscoModifier, int flags, IJavaElement element) {
        int kind = element.getElementType();
        if (!(modiscoModifier.isStatic() || kind != 7 && kind != 9 && kind != 8)) {
            modiscoModifier.setStatic(Flags.isStatic((int)flags));
        }
        if (!modiscoModifier.isNative() && kind == 9) {
            modiscoModifier.setNative(Flags.isNative((int)flags));
        }
        if (!(modiscoModifier.isStrictfp() || kind != 7 && kind != 9)) {
            modiscoModifier.setStrictfp(Flags.isStrictfp((int)flags));
        }
        if (!modiscoModifier.isSynchronized() && kind == 9) {
            modiscoModifier.setSynchronized(Flags.isSynchronized((int)flags));
        }
        if (!modiscoModifier.isTransient() && kind == 8) {
            modiscoModifier.setTransient(Flags.isTransient((int)flags));
        }
        if (!modiscoModifier.isVolatile() && kind == 8) {
            modiscoModifier.setVolatile(Flags.isVolatile((int)flags));
        }
        if (kind == 7 || kind == 9 || kind == 8) {
            if (Flags.isPrivate((int)flags)) {
                modiscoModifier.setVisibility(VisibilityKind.PRIVATE);
            } else if (Flags.isProtected((int)flags)) {
                modiscoModifier.setVisibility(VisibilityKind.PROTECTED);
            } else if (Flags.isPublic((int)flags)) {
                modiscoModifier.setVisibility(VisibilityKind.PUBLIC);
            }
        }
        if (kind == 7 || kind == 9) {
            if (Flags.isAbstract((int)flags)) {
                modiscoModifier.setInheritance(InheritanceKind.ABSTRACT);
            } else if (Flags.isFinal((int)flags)) {
                modiscoModifier.setInheritance(InheritanceKind.FINAL);
            }
        }
    }

    public void setFactory(JavaFactory factory) {
        this.factory = factory;
    }

    public JavaFactory getFactory() {
        return this.factory;
    }

    public void setGlobalBindings(BindingManager globalBindings) {
        this.globalBindings = globalBindings;
    }

    public BindingManager getGlobalBindings() {
        return this.globalBindings;
    }
}

