/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterImpl;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.Messages;
import org.eclipse.gmt.modisco.java.actions.DefaultDiscoverer;
import org.eclipse.gmt.modisco.java.actions.TranslateJavaModelToKdm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class DiscoverKdmModelFromJavaModel
extends DefaultDiscoverer {
    private static List<DiscoveryParameter> parametersKeys = null;
    public static final DiscoveryParameter PARAMETER_PATH_TO_TRANSFORMATION = new DiscoveryParameterImpl("OPTION_ASM_PATH", DiscoveryParameterDirectionKind.in, String.class, false);

    @Override
    public Resource discoverElement(Object source, URI target) {
        HashMap<DiscoveryParameter, Object> parameters = new HashMap<DiscoveryParameter, Object>();
        parameters.put(DefaultDiscoverer.PARAMETER_SILENT_MODE, false);
        this.discoverElement(source, parameters);
        return (Resource)parameters.get(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE);
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        IFile iFile = (IFile)source;
        String sourcePath = iFile.getFullPath().toString();
        XMIResourceImpl javaModelResource = new XMIResourceImpl();
        javaModelResource.setURI(URI.createPlatformResourceURI((String)sourcePath, (boolean)true));
        Resource kdmModelResource = null;
        try {
            URI javaModelURI = javaModelResource.getURI();
            URI kdmModelUri = javaModelURI.trimFileExtension().appendFileExtension("kdm");
            TranslateJavaModelToKdm kdmTranslater = new TranslateJavaModelToKdm();
            if (parameters.containsKey(PARAMETER_PATH_TO_TRANSFORMATION) && parameters.get(PARAMETER_PATH_TO_TRANSFORMATION) != null && parameters.get(PARAMETER_PATH_TO_TRANSFORMATION) instanceof String) {
                String s = (String)parameters.get(PARAMETER_PATH_TO_TRANSFORMATION);
                kdmTranslater.setPathToTransformation(s);
            }
            if ((kdmModelResource = kdmTranslater.getKDMModelFromJavaModelWithCustomTransformation(javaModelURI, kdmModelUri)) != null) {
                String kdmFileString = kdmModelUri.toPlatformString(true);
                IFile kdmFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(kdmFileString));
                kdmFile.getProject().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                this.openEditor(kdmFile, parameters);
                parameters.put(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE, kdmModelResource);
            }
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
        }
    }

    public List<DiscoveryParameter> getDiscovererParameters() {
        if (parametersKeys == null) {
            parametersKeys = new ArrayList<DiscoveryParameter>();
            parametersKeys.add(DefaultDiscoverer.PARAMETER_SILENT_MODE);
            parametersKeys.add(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE);
            parametersKeys.add(PARAMETER_PATH_TO_TRANSFORMATION);
        }
        return parametersKeys;
    }

    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IFile) {
            IFile iFile = (IFile)source;
            String extension = iFile.getFileExtension();
            result = extension != null && extension.equals("javaxmi");
        }
        return result;
    }

    public String toString() {
        return Messages.DiscoverKdmModelFromJavaModel_title;
    }
}

