/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.kdm.uml2converter.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.UriUtils;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.kdm.uml2converter.KdmToUml2Activator;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.drivers.emf4atl.EMFModelLoader;
import org.eclipse.m2m.atl.engine.vm.AtlLauncher;
import org.eclipse.m2m.atl.engine.vm.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class AtlLaunchHelper {
    private EMFModelLoader modelHandler;

    private void createResources() {
        this.modelHandler = (EMFModelLoader)AtlModelHandler.getDefault((String)"EMF").createModelLoader();
    }

    private void dispose(Map<String, ASMEMFModel> models) {
        for (ASMEMFModel model : models.values()) {
            this.modelHandler.unload((ASMModel)model);
        }
    }

    private void initMetamodels(Map<String, ASMEMFModel> models, List<ModelInfo> inputModels, List<ModelInfo> outputModels) throws IOException {
        ASMEMFModel metamodel;
        for (ModelInfo imi : inputModels) {
            if (models.containsKey(imi.getMetamodelName())) continue;
            metamodel = this.modelHandler.loadModel(imi.getMetamodelName(), this.modelHandler.getMOF(), imi.getMetamodelUri());
            models.put(imi.getMetamodelName(), metamodel);
        }
        for (ModelInfo omi : outputModels) {
            if (models.containsKey(omi.getMetamodelName())) continue;
            metamodel = this.modelHandler.loadModel(omi.getMetamodelName(), this.modelHandler.getMOF(), omi.getMetamodelUri());
            models.put(omi.getMetamodelName(), metamodel);
        }
    }

    private void initModels(Map<String, ASMEMFModel> models, List<ModelInfo> inputModels, List<ModelInfo> outputModels) throws IOException {
        for (ModelInfo imi : inputModels) {
            ASMEMFModel inputModel = this.modelHandler.loadModel(imi.getModelName(), (ASMModel)models.get(imi.getMetamodelName()), imi.getModelUri());
            models.put(imi.getModelName(), inputModel);
        }
        for (ModelInfo omi : outputModels) {
            ASMEMFModel outputModel = (ASMEMFModel)this.modelHandler.newModel(omi.getModelName(), UriUtils.toString((URI)omi.getModelUri()), (ASMModel)models.get(omi.getMetamodelName()));
            models.put(omi.getModelName(), outputModel);
        }
    }

    private void saveModels(Map<String, ASMEMFModel> models, List<ModelInfo> outputModels, List<Resource> result) throws IOException {
        for (ModelInfo omi : outputModels) {
            ASMEMFModel outputModel = models.get(omi.getModelName());
            this.modelHandler.save((ASMModel)outputModel, UriUtils.toString((URI)omi.getModelUri()));
            result.add(outputModel.getExtent());
        }
    }

    public List<Resource> scheduleTransformation(final URL transformation, List<ModelInfo> inputModels, List<ModelInfo> outputModels, String jobTitle) {
        String jobLabel = jobTitle;
        if (jobLabel == null) {
            jobLabel = "ATL transformation";
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        try {
            final HashMap<String, ASMEMFModel> models = new HashMap<String, ASMEMFModel>();
            this.createResources();
            this.initMetamodels(models, inputModels, outputModels);
            this.initModels(models, inputModels, outputModels);
            final HashMap<String, String> options = new HashMap<String, String>();
            options.put("continueAfterError", "true");
            options.put("printExecutionTime", "true");
            Job transformationThread = new Job(jobTitle){

                protected IStatus run(IProgressMonitor monitor) {
                    IStatus jobResult = Status.OK_STATUS;
                    try {
                        AtlLauncher.getDefault().launch(transformation, Collections.EMPTY_MAP, models, Collections.EMPTY_MAP, Collections.EMPTY_LIST, options);
                    }
                    catch (Exception e) {
                        jobResult = Status.CANCEL_STATUS;
                        MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
                    }
                    return jobResult;
                }
            };
            transformationThread.schedule();
            try {
                transformationThread.join();
            }
            catch (InterruptedException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
            }
            this.saveModels(models, outputModels, result);
            this.dispose(models);
        }
        catch (IOException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
        }
        return result;
    }

    public Resource scheduleTransformation(URL transformation, ModelInfo inputModel, ModelInfo outputModel, String jobTitle) {
        Resource result = null;
        ArrayList<ModelInfo> inputModels = new ArrayList<ModelInfo>();
        inputModels.add(inputModel);
        ArrayList<ModelInfo> outputModels = new ArrayList<ModelInfo>();
        outputModels.add(outputModel);
        List<Resource> results = this.scheduleTransformation(transformation, inputModels, outputModels, jobTitle);
        if (results.size() > 0) {
            result = results.get(0);
        }
        return result;
    }

    public static class ModelInfo {
        private final String modelName;
        private final URI modelUri;
        private final String metamodelName;
        private final URI metamodelUri;

        public ModelInfo(String name, URI uri, String metamodelName, URI metamodelUri) {
            this.modelName = name;
            this.modelUri = uri;
            this.metamodelName = metamodelName;
            this.metamodelUri = metamodelUri;
        }

        public String getModelName() {
            return this.modelName;
        }

        public URI getModelUri() {
            return this.modelUri;
        }

        public String getMetamodelName() {
            return this.metamodelName;
        }

        public URI getMetamodelUri() {
            return this.metamodelUri;
        }
    }
}

