/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.internal.jobs.JobStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.BenchmarkFactory;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.EventType;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.MemoryMeasurement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryMeasurementJob
extends Job {
    private int memoryPollingInterval;
    private List<MemoryMeasurement> measures;
    private long jobStartTime;
    private EventType eventType;

    public MemoryMeasurementJob(String name, int interval) {
        super(name);
        this.memoryPollingInterval = interval;
        this.measures = new LinkedList<MemoryMeasurement>();
        this.jobStartTime = 0L;
        this.eventType = BenchmarkFactory.eINSTANCE.createEventType();
        this.eventType.setName("periodicMemoryMeasure");
    }

    public MemoryMeasurementJob reset() {
        this.measures = new LinkedList<MemoryMeasurement>();
        return this;
    }

    public void setJobStartTime(long s) {
        this.jobStartTime = s;
    }

    public int getMemoryPollingInterval() {
        return this.memoryPollingInterval;
    }

    public List<MemoryMeasurement> getMeasures() {
        return this.measures;
    }

    protected IStatus run(IProgressMonitor monitor) {
        JobStatus result = new JobStatus(0, (Job)this, "Memory measured every " + this.memoryPollingInterval + " ms.");
        System.gc();
        long mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        MemoryMeasurement memoryMeasure = BenchmarkFactory.eINSTANCE.createMemoryMeasurement();
        memoryMeasure.setTime(System.currentTimeMillis() - this.jobStartTime);
        memoryMeasure.setMemoryUsed((int)mem);
        memoryMeasure.setEventType(this.eventType);
        this.measures.add(memoryMeasure);
        this.schedule(this.memoryPollingInterval);
        return result;
    }
}

