/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal.reporting.internal;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Benchmark;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Discovery;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.DiscoveryIteration;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Event;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.MemoryMeasurement;
import org.eclipse.modisco.utils.chart.birt.core.internal.exported.BirtGraphHelper;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Axe;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Chart;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.ChartFactory;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Coordinate;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Point;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Serie;

public class BenchmarkChartGeneration {
    private File location;
    private boolean measureMemory;
    private ChartFactory factory;
    private BirtGraphHelper helper;
    public static final double MEGABYTE = 1048576.0;

    public BenchmarkChartGeneration(File location, boolean measureMemory) {
        this.location = location;
        this.measureMemory = measureMemory;
        this.factory = ChartFactory.eINSTANCE;
        this.helper = BirtGraphHelper.getInstance();
    }

    public void generateAll(Benchmark b) throws Exception {
        this.createDiscoveryTimeAsProjectSizeFull(b);
        if (this.measureMemory) {
            this.createMemoryUsedAsProjectSizeFull(b);
        }
    }

    public void createDiscoveryTimeAsProjectSizeFull(Benchmark b) throws Exception {
        this.createDiscoveryTimeAsProjectSizeOverallAveraged(b);
        ArrayList<String> testedDiscoverers = new ArrayList<String>();
        for (Discovery d : b.getDiscoveries()) {
            if (testedDiscoverers.contains(d.getDiscovererId())) continue;
            this.createDiscoveryTimeAsProjectSizeAveraged(b, d);
            testedDiscoverers.add(d.getDiscovererId());
        }
    }

    private void createDiscoveryTimeAsProjectSizeAveraged(Benchmark b, Discovery d) throws Exception {
        Chart chart = this.factory.createChart();
        chart.setTitle("Discovery time by project size for" + d.getDiscovererId());
        Serie s = this.factory.createSerie();
        s.setName(d.getDiscovererId());
        chart.getSeries().add((Object)s);
        Axe size = this.factory.createAxe();
        Axe time = this.factory.createAxe();
        size.setUnit("megabytes");
        size.setLegend("project size");
        time.setUnit("secondes");
        time.setLegend("Discovery Time");
        chart.getAxes().add((Object)size);
        chart.getAxes().add((Object)time);
        for (Discovery dtemp : b.getDiscoveries()) {
            if (!dtemp.getDiscovererId().equals(d.getDiscovererId())) continue;
            Point p = this.factory.createPoint();
            p.setSerie(s);
            Coordinate t = this.factory.createCoordinate();
            t.setAxe(size);
            t.setValue((double)dtemp.getProject().getTotalSizeInBytes() / 1048576.0);
            Coordinate m = this.factory.createCoordinate();
            m.setAxe(time);
            m.setValue(dtemp.getDiscoveryTimeAverageInSeconds());
            p.getCoordinates().add((Object)t);
            p.getCoordinates().add((Object)m);
        }
        this.helper.createBirtGraph(chart, this.location, "DiscoveryTimeByProjectSize" + d.getDiscovererId());
    }

    private void createDiscoveryTimeAsProjectSizeOverallAveraged(Benchmark b) throws Exception {
        Chart chart = this.factory.createChart();
        chart.setTitle("Discovery time by project size overall");
        Axe size = this.factory.createAxe();
        Axe time = this.factory.createAxe();
        size.setUnit("megabytes");
        size.setLegend("project size");
        time.setUnit("secondes");
        time.setLegend("Discovery Time");
        chart.getAxes().add((Object)size);
        chart.getAxes().add((Object)time);
        ArrayList<String> testedDiscoverers = new ArrayList<String>();
        for (Discovery d : b.getDiscoveries()) {
            if (testedDiscoverers.contains(d.getDiscovererId())) continue;
            Serie s = this.factory.createSerie();
            s.setName(d.getDiscovererId());
            chart.getSeries().add((Object)s);
            for (Discovery dtemp : b.getDiscoveries()) {
                if (!dtemp.getDiscovererId().equals(d.getDiscovererId())) continue;
                Point p = this.factory.createPoint();
                p.setSerie(s);
                Coordinate t = this.factory.createCoordinate();
                t.setAxe(size);
                t.setValue((double)dtemp.getProject().getTotalSizeInBytes() / 1048576.0);
                Coordinate m = this.factory.createCoordinate();
                m.setAxe(time);
                m.setValue(dtemp.getDiscoveryTimeAverageInSeconds());
                p.getCoordinates().add((Object)t);
                p.getCoordinates().add((Object)m);
            }
            testedDiscoverers.add(d.getDiscovererId());
        }
        this.helper.createBirtGraph(chart, this.location, "DiscoveryTimeByProjectSizeOverall");
    }

    public void createMemoryUsedAsProjectSizeFull(Benchmark b) throws Exception {
        this.createMemoryUsedAsProjectSizeOverallAveraged(b);
        ArrayList<String> testedDiscoverers = new ArrayList<String>();
        for (Discovery d : b.getDiscoveries()) {
            if (!testedDiscoverers.contains(d.getDiscovererId())) {
                this.createMemoryUsedAsProjectSizeAveraged(b, d);
                testedDiscoverers.add(d.getDiscovererId());
            }
            for (DiscoveryIteration di : d.getIterations()) {
                this.createMemoryUseByTime(d, di);
            }
        }
    }

    private void createMemoryUsedAsProjectSizeAveraged(Benchmark b, Discovery d) throws Exception {
        Chart chart = this.factory.createChart();
        chart.setTitle("Memory used by project size for" + d.getDiscovererId());
        Serie s = this.factory.createSerie();
        s.setName(d.getDiscovererId());
        chart.getSeries().add((Object)s);
        Axe size = this.factory.createAxe();
        Axe memory = this.factory.createAxe();
        size.setUnit("megabytes");
        size.setLegend("project size");
        memory.setUnit("megabytes");
        memory.setLegend("memory used");
        chart.getAxes().add((Object)size);
        chart.getAxes().add((Object)memory);
        for (Discovery dtemp : b.getDiscoveries()) {
            if (!dtemp.getDiscovererId().equals(d.getDiscovererId())) continue;
            Point p = this.factory.createPoint();
            p.setSerie(s);
            Coordinate t = this.factory.createCoordinate();
            t.setAxe(size);
            t.setValue((double)dtemp.getProject().getTotalSizeInBytes() / 1048576.0);
            Coordinate m = this.factory.createCoordinate();
            m.setAxe(memory);
            m.setValue((double)((DiscoveryIteration)dtemp.getIterations().get(0)).getMaxUsedMemoryInBytes() / 1048576.0);
            p.getCoordinates().add((Object)t);
            p.getCoordinates().add((Object)m);
        }
        this.helper.createBirtGraph(chart, this.location, "memoryByProjectSize" + d.getDiscovererId());
    }

    private void createMemoryUsedAsProjectSizeOverallAveraged(Benchmark b) throws Exception {
        Chart chart = this.factory.createChart();
        chart.setTitle("Memory used by project size overall");
        Axe size = this.factory.createAxe();
        Axe memory = this.factory.createAxe();
        size.setUnit("megabytes");
        size.setLegend("project size");
        memory.setUnit("megabytes");
        memory.setLegend("memory used");
        chart.getAxes().add((Object)size);
        chart.getAxes().add((Object)memory);
        ArrayList<String> testedDiscoverers = new ArrayList<String>();
        for (Discovery d : b.getDiscoveries()) {
            if (testedDiscoverers.contains(d.getDiscovererId())) continue;
            Serie s = this.factory.createSerie();
            s.setName(d.getDiscovererId());
            chart.getSeries().add((Object)s);
            for (Discovery dtemp : b.getDiscoveries()) {
                if (!dtemp.getDiscovererId().equals(d.getDiscovererId())) continue;
                Point p = this.factory.createPoint();
                p.setSerie(s);
                Coordinate t = this.factory.createCoordinate();
                t.setAxe(size);
                t.setValue((double)dtemp.getProject().getTotalSizeInBytes() / 1048576.0);
                Coordinate m = this.factory.createCoordinate();
                m.setAxe(memory);
                m.setValue((double)((DiscoveryIteration)dtemp.getIterations().get(0)).getMaxUsedMemoryInBytes() / 1048576.0);
                p.getCoordinates().add((Object)t);
                p.getCoordinates().add((Object)m);
            }
            testedDiscoverers.add(d.getDiscovererId());
        }
        this.helper.createBirtGraph(chart, this.location, "memoryByProjectSizeOverall");
    }

    public void createMemoryUseByTime(Discovery d, DiscoveryIteration di) throws Exception {
        Chart chart = this.factory.createChart();
        chart.setTitle("Memory used by time for " + d.getDiscovererId() + " on " + d.getProject().getName() + " the " + di.getDiscoveryDate());
        Serie s = this.factory.createSerie();
        s.setName(d.getDiscovererId());
        chart.getSeries().add((Object)s);
        Axe time = this.factory.createAxe();
        Axe memory = this.factory.createAxe();
        time.setUnit("ms");
        time.setLegend("time");
        memory.setUnit("megabytes");
        memory.setLegend("memory used");
        chart.getAxes().add((Object)time);
        chart.getAxes().add((Object)memory);
        for (Event mm : di.getMemoryMeasurements()) {
            if (!(mm instanceof MemoryMeasurement)) continue;
            MemoryMeasurement mem = (MemoryMeasurement)mm;
            Point p = this.factory.createPoint();
            p.setSerie(s);
            Coordinate t = this.factory.createCoordinate();
            t.setAxe(time);
            t.setValue((double)mem.getTime());
            Coordinate m = this.factory.createCoordinate();
            m.setAxe(memory);
            m.setValue((double)mem.getMemoryUsed() / 1048576.0);
            p.getCoordinates().add((Object)t);
            p.getCoordinates().add((Object)m);
        }
        this.helper.createBirtGraph(chart, this.location, "memoryByTime" + d.getDiscovererId() + "_" + di.getDiscoveryDate().toString().replaceAll(" ", "_").replaceAll(":", "-"));
    }
}

