/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import prefuse.data.expression.ColumnExpression;
import prefuse.data.expression.Expression;
import prefuse.data.expression.ExpressionVisitor;

public class ExpressionAnalyzer {
    public static boolean hasDependency(Expression expr) {
        ColumnCollector cc = new ColumnCollector(false);
        expr.visit(cc);
        return cc.getColumnCount() > 0;
    }

    public static Set getReferencedColumns(Expression expr) {
        ColumnCollector cc = new ColumnCollector(true);
        expr.visit(cc);
        return cc.getColumnSet();
    }

    private static class ColumnCollector
    implements ExpressionVisitor {
        private boolean store;
        private Set m_cols;
        private int m_count;

        public ColumnCollector(boolean store) {
            this.store = store;
        }

        public int getColumnCount() {
            return this.m_count;
        }

        public Set getColumnSet() {
            if (this.m_cols == null) {
                return Collections.EMPTY_SET;
            }
            return this.m_cols;
        }

        public void visitExpression(Expression expr) {
            if (expr instanceof ColumnExpression) {
                ++this.m_count;
                if (this.store) {
                    String field = ((ColumnExpression)expr).getColumnName();
                    if (this.m_cols == null) {
                        this.m_cols = new HashSet();
                    }
                    this.m_cols.add(field);
                }
            }
        }

        public void down() {
        }

        public void up() {
        }
    }
}

