/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import prefuse.util.io.IOLib;

public class PrefuseConfig
extends Properties {
    private static final Logger s_logger = Logger.getLogger(PrefuseConfig.class.getName());
    private static final PrefuseConfig s_config = new PrefuseConfig();

    public static PrefuseConfig getConfig() {
        return s_config;
    }

    private PrefuseConfig() {
        String configFile;
        this.setDefaults();
        try {
            configFile = System.getProperty("prefuse.config");
        }
        catch (Exception e) {
            configFile = null;
        }
        if (configFile == null) {
            configFile = "prefuse.conf";
        }
        try {
            this.load(IOLib.streamFromString(configFile));
            s_logger.info("Loaded config file: " + configFile);
        }
        catch (Exception e) {
            // empty catch block
        }
        String logdir = this.getProperty("util.logdir");
        String logfile = this.getProperty("util.logfile");
        if (logdir != null) {
            try {
                Logger logger = Logger.getLogger("prefuse");
                logger.setUseParentHandlers(false);
                FileHandler fileHandler = new FileHandler(String.valueOf(logdir) + "/" + logfile);
                fileHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(fileHandler);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String get(String key) {
        return s_config.getProperty(key);
    }

    public static int getInt(String key) {
        String val = s_config.getProperty(key);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            return Integer.MIN_VALUE;
        }
    }

    public static long getLong(String key) {
        String val = s_config.getProperty(key);
        try {
            return Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            return Long.MIN_VALUE;
        }
    }

    public static float getFloat(String key) {
        String val = s_config.getProperty(key);
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException nfe) {
            return Float.NaN;
        }
    }

    public static double getDouble(String key) {
        String val = s_config.getProperty(key);
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    public static boolean getBoolean(String key) {
        String val = s_config.getProperty(key);
        return "true".equalsIgnoreCase(val);
    }

    private void setDefaults() {
        this.setProperty("size.scale2D", "0.5");
        this.setProperty("activity.threadPriority", "6");
        this.setProperty("data.delimiter", ".");
        this.setProperty("data.graph.nodeGroup", "nodes");
        this.setProperty("data.graph.edgeGroup", "edges");
        this.setProperty("data.visual.fieldPrefix", "_");
        this.setProperty("data.io.worker.threadPriority", String.valueOf(5));
        this.setProperty("data.filter.optimizeThreshold", "300");
        this.setProperty("data.graph.sourceKey", "source");
        this.setProperty("data.graph.targetKey", "target");
        this.setProperty("data.tree.sourceKey", "parent");
        this.setProperty("data.tree.targetKey", "child");
        this.setProperty("visualization.allItems", "_all_");
        this.setProperty("visualization.focusItems", "_focus_");
        this.setProperty("visualization.selectedItems", "_selected_");
        this.setProperty("visualization.searchItems", "_search_");
        this.setProperty("util.logfile", "prefuse_log_%g.txt");
    }
}

