/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.simpletransformationschain.controller.impl;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.kdm.uml2converter.impl.KdmtoUmlConverterImpl;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.Messages;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.ModelplexKnowledgeDiscoveryFrameworkPlugin;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.controller.TransformationExporter;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.ModelServices;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.modelplex.DiscovererKind;
import org.eclipse.modisco.java.discoverer.internal.JavaActivator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IDE;

public class TransformationExporterImpl
implements TransformationExporter {
    private final ModelServices modelServices;

    TransformationExporterImpl(ModelServices modelServicesParameter) {
        this.modelServices = modelServicesParameter;
    }

    public void exportKdmToUmlTransformation() {
        SaveAsDialog dialog = new SaveAsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setTitle(Messages.TransformationExporterImpl_0);
        dialog.open();
        IPath path = dialog.getResult();
        if (path.getFileExtension() == null || !path.getFileExtension().equals("atl")) {
            path = path.addFileExtension("atl");
        }
        String asmPath = path.removeFileExtension().addFileExtension("asm").makeAbsolute().toString();
        this.modelServices.getDiscoverer().getToUml().setCustom(true);
        this.modelServices.getDiscoverer().getToUml().setTransformationPath(asmPath);
        KdmtoUmlConverterImpl converter = new KdmtoUmlConverterImpl();
        converter.exportKdmToUmlTransformation(path);
    }

    public void exportSpecificToKdmTransformation() {
        SaveAsDialog dialog = new SaveAsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setTitle(Messages.TransformationExporterImpl_4);
        dialog.open();
        IPath path = dialog.getResult();
        if (path.getFileExtension() == null || !path.getFileExtension().equals("atl")) {
            path = path.addFileExtension("atl");
        }
        String asmPath = path.removeFileExtension().addFileExtension("asm").makeAbsolute().toString();
        this.modelServices.getDiscoverer().getToKdm().setCustom(true);
        this.modelServices.getDiscoverer().getToKdm().setTransformationPath(asmPath);
        if (this.modelServices.getDiscoverer().getKind() == DiscovererKind.JAVA) {
            this.exportJavaToKdmTransformation(path);
        }
    }

    private void exportJavaToKdmTransformation(IPath path) {
        IPath atlPath = path;
        final InputStream transfoFileStream = JavaActivator.class.getResourceAsStream("internal/resources/transformations/javaToKdm.atl");
        if (atlPath.getFileExtension() == null || !atlPath.getFileExtension().equals("atl")) {
            atlPath = atlPath.addFileExtension("atl");
        }
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(atlPath);
        final IProject destinationProject = file.getProject();
        Job job = new Job("exporting ATL transformation"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (file.exists()) {
                        file.setContents(transfoFileStream, 1, monitor);
                    } else {
                        file.create(transfoFileStream, 1, monitor);
                    }
                }
                catch (CoreException coreException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            destinationProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                        }
                        catch (Exception e) {
                            MoDiscoLogger.logError((Throwable)e, (Plugin)ModelplexKnowledgeDiscoveryFrameworkPlugin.getDefault());
                        }
                    }
                });
            }
        });
        job.schedule();
    }
}

