/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import java.util.Arrays;
import prefuse.data.DataReadOnlyException;
import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;

public class ByteColumn
extends AbstractColumn {
    private byte[] m_values;
    private int m_size;

    public ByteColumn() {
        this(0, 10, 0);
    }

    public ByteColumn(int nrows) {
        this(nrows, nrows, 0);
    }

    public ByteColumn(int nrows, int capacity, byte defaultValue) {
        super(Byte.TYPE, new Byte(defaultValue));
        if (capacity < nrows) {
            throw new IllegalArgumentException("Capacity value can not be less than the row count.");
        }
        this.m_values = new byte[capacity];
        Arrays.fill(this.m_values, defaultValue);
        this.m_size = nrows;
    }

    public int getRowCount() {
        return this.m_size;
    }

    public void setMaximumRow(int nrows) {
        if (nrows > this.m_values.length) {
            int capacity = Math.max(3 * this.m_values.length / 2 + 1, nrows);
            byte[] values = new byte[capacity];
            System.arraycopy(this.m_values, 0, values, 0, this.m_size);
            Arrays.fill(values, this.m_size, capacity, (Byte)this.m_defaultValue);
            this.m_values = values;
        }
        this.m_size = nrows;
    }

    public Object get(int row) {
        return new Byte(this.getByte(row));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(Object val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (val == null) throw new DataTypeException("Column does not accept null values");
        if (val instanceof Number) {
            this.setInt(((Number)val).byteValue(), row);
            return;
        } else {
            if (!(val instanceof String)) throw new DataTypeException(val.getClass());
            this.setString((String)val, row);
        }
    }

    public byte getByte(int row) throws DataTypeException {
        if (row < 0 || row > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        return this.m_values[row];
    }

    public int getInt(int row) throws DataTypeException {
        if (row < 0 || row > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        return this.m_values[row];
    }

    public void setInt(int val, int row) throws DataTypeException {
        if (this.m_readOnly) {
            throw new DataReadOnlyException();
        }
        if (row < 0 || row >= this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        byte prev = this.m_values[row];
        if (prev == val) {
            return;
        }
        this.m_values[row] = (byte)val;
        this.fireColumnEvent(row, prev);
    }

    public long getLong(int row) throws DataTypeException {
        return this.getInt(row);
    }

    public float getFloat(int row) throws DataTypeException {
        return this.getInt(row);
    }

    public double getDouble(int row) throws DataTypeException {
        return this.getInt(row);
    }
}

