/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmt.modisco.infra.browser.core.DragAndDropUtils;
import org.eclipse.gmt.modisco.infra.browser.core.ModelElementItemEx;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ModelElementItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragAndDropOnModelElementCommand
extends DragAndDropCommand {
    private final ModelElementItemEx modelElementItem;

    public DragAndDropOnModelElementCommand(EditingDomain editingDomain, ModelElementItemEx modelElementItem, float location, int operations, int operation, Collection<?> collection) {
        super(editingDomain, (Object)modelElementItem, location, operations, operation, collection);
        this.modelElementItem = modelElementItem;
    }

    public ModelElementItem getModelElementItem() {
        return this.modelElementItem;
    }

    public Command getDropCommand() {
        return this.dropCommand;
    }

    protected Object getParent(Object object) {
        if (object instanceof ITreeElement) {
            ITreeElement treeElement = (ITreeElement)object;
            return treeElement.getTreeParent();
        }
        return Collections.emptyList();
    }

    protected Collection<?> getChildren(Object object) {
        if (object instanceof ITreeElement) {
            ITreeElement treeElement = (ITreeElement)object;
            return treeElement.getChildren();
        }
        return Collections.emptyList();
    }

    protected boolean prepareDropMoveInsert(Object parent, Collection<?> children, int index) {
        if (!(parent instanceof LinkItem)) {
            return false;
        }
        LinkItem parentLinkItem = (LinkItem)parent;
        ArrayList<Object> emfChildren = new ArrayList<Object>();
        for (Object o : children) {
            if (o instanceof ModelElementItem) {
                ModelElementItem item = (ModelElementItem)o;
                emfChildren.add(item.getEObject());
                continue;
            }
            emfChildren.add(o);
        }
        if (this.collection.contains(this.modelElementItem.getEObject())) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else if (emfChildren.containsAll(this.collection)) {
            this.dragCommand = IdentityCommand.INSTANCE;
            CompoundCommand compoundCommand = new CompoundCommand();
            ArrayList before = new ArrayList();
            ArrayList after = new ArrayList();
            int i = 0;
            for (Object e : emfChildren) {
                if (this.collection.contains(e)) {
                    if (i < index) {
                        before.add(e);
                    } else if (i > index) {
                        after.add(e);
                    }
                }
                ++i;
            }
            for (Object e : before) {
                compoundCommand.append(MoveCommand.create((EditingDomain)this.domain, (Object)parentLinkItem.getParent(), (Object)parentLinkItem.getReference(), e, (int)(index - 1)));
            }
            ListIterator listIterator = after.listIterator(after.size());
            while (listIterator.hasPrevious()) {
                Object object = listIterator.previous();
                compoundCommand.append(MoveCommand.create((EditingDomain)this.domain, (Object)parentLinkItem.getParent(), (Object)parentLinkItem.getReference(), object, (int)index));
            }
            this.dropCommand = compoundCommand.getCommandList().isEmpty() ? IdentityCommand.INSTANCE : compoundCommand;
        } else {
            EObject eObject;
            Resource resource;
            if (this.isCrossDomain() && (resource = (eObject = this.modelElementItem.getEObject()).eResource()) != null && resource.getResourceSet() != null) {
                this.collection = DragAndDropUtils.translateCrossDomainObjects(this.collection, resource.getResourceSet());
            }
            this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)parentLinkItem.getParent(), (Object)parentLinkItem.getReference(), (Collection)this.collection, (int)index);
            this.dragCommand = this.analyzeForNonContainment(this.dropCommand) ? IdentityCommand.INSTANCE : RemoveCommand.create((EditingDomain)this.domain, (Collection)this.collection);
        }
        boolean result = this.dragCommand.canExecute() && this.dropCommand.canExecute();
        return result;
    }

    protected boolean prepareDropCopyInsert(Object parent, Collection<?> children, int index) {
        boolean result;
        if (!(parent instanceof LinkItem)) {
            return false;
        }
        LinkItem parentLinkItem = (LinkItem)parent;
        if (this.collection.contains(this.modelElementItem.getEObject())) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
            result = false;
        } else {
            this.dragCommand = CopyCommand.create((EditingDomain)this.domain, (Collection)this.collection);
            if (this.optimize) {
                result = this.optimizedCanExecute();
                if (result) {
                    this.optimizedDropCommandOwner = this.modelElementItem.getEObject();
                }
            } else if (this.dragCommand.canExecute() && this.dragCommand.canUndo()) {
                this.dragCommand.execute();
                this.isDragCommandExecuted = true;
                this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)parentLinkItem.getParent(), (Object)parentLinkItem.getReference(), (Collection)this.dragCommand.getResult(), (int)index);
                if (this.analyzeForNonContainment(this.dropCommand)) {
                    this.dropCommand.dispose();
                    this.dropCommand = UnexecutableCommand.INSTANCE;
                    this.dragCommand.undo();
                    this.dragCommand.dispose();
                    this.isDragCommandExecuted = false;
                    this.dragCommand = IdentityCommand.INSTANCE;
                }
                result = this.dropCommand.canExecute();
            } else {
                this.dropCommand = UnexecutableCommand.INSTANCE;
                result = false;
            }
        }
        return result;
    }

    protected boolean prepareDropLinkInsert(Object parent, Collection<?> children, int index) {
        this.dragCommand = IdentityCommand.INSTANCE;
        this.dropCommand = UnexecutableCommand.INSTANCE;
        return false;
    }

    protected boolean prepareDropMoveOn() {
        if (this.isCrossDomain()) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else {
            this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)this.modelElementItem.getEObject(), null, (Collection)this.collection);
            if (this.analyzeForNonContainment(this.dropCommand)) {
                this.dropCommand.dispose();
                this.dropCommand = UnexecutableCommand.INSTANCE;
                this.dragCommand = IdentityCommand.INSTANCE;
            } else {
                this.dragCommand = RemoveCommand.create((EditingDomain)this.domain, (Collection)this.collection);
            }
        }
        boolean result = this.dragCommand.canExecute() && this.dropCommand.canExecute();
        return result;
    }

    protected boolean prepareDropCopyOn() {
        this.dragCommand = CopyCommand.create((EditingDomain)this.domain, (Collection)this.collection);
        if (this.dragCommand.canExecute() && this.dragCommand.canUndo()) {
            this.dragCommand.execute();
            this.isDragCommandExecuted = true;
            this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)this.modelElementItem.getEObject(), null, (Collection)this.dragCommand.getResult());
            if (this.analyzeForNonContainment(this.dropCommand)) {
                this.dropCommand.dispose();
                this.dropCommand = UnexecutableCommand.INSTANCE;
                this.dragCommand.undo();
                this.dragCommand.dispose();
                this.isDragCommandExecuted = false;
                this.dragCommand = IdentityCommand.INSTANCE;
            }
        } else {
            this.dropCommand = UnexecutableCommand.INSTANCE;
        }
        boolean result = this.dragCommand.canExecute() && this.dropCommand.canExecute();
        return result;
    }

    protected boolean prepareDropLinkOn() {
        this.dragCommand = IdentityCommand.INSTANCE;
        this.dropCommand = UnexecutableCommand.INSTANCE;
        return false;
    }
}

