/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors;

import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.editors.NonBlockingElementComputation;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.gmt.modisco.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class BrowserLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private final EcoreBrowser browser;
    private final TextComputation textComputation;
    private final ImageComputation imageComputation;
    private final ForegroundColorComputation foregroundColorComputation;
    private final BackgroundColorComputation backgroundColorComputation;
    private final FontComputation fontComputation;

    public BrowserLabelProvider(EcoreBrowser browser) {
        this.browser = browser;
        this.textComputation = new TextComputation();
        this.imageComputation = new ImageComputation();
        this.foregroundColorComputation = new ForegroundColorComputation();
        this.backgroundColorComputation = new BackgroundColorComputation();
        this.fontComputation = new FontComputation();
    }

    public IWorkbenchSiteProgressService getProgressService() {
        return this.browser.getProgressService();
    }

    protected void refreshBrowser() {
        this.browser.refreshDelayed(false);
    }

    public String getText(Object element) {
        return (String)this.textComputation.computeValue(element);
    }

    public Image getImage(Object element) {
        return (Image)this.imageComputation.computeValue(element);
    }

    public Color getForeground(Object element) {
        return (Color)this.foregroundColorComputation.computeValue(element);
    }

    public Color getBackground(Object element) {
        return (Color)this.backgroundColorComputation.computeValue(element);
    }

    public Font getFont(Object element) {
        return (Font)this.fontComputation.computeValue(element);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BackgroundColorComputation
    extends NonBlockingElementComputation<Color> {
        public BackgroundColorComputation() {
            super(BrowserLabelProvider.this.getProgressService());
        }

        @Override
        protected Color basicCompute(Object element) {
            if (element instanceof ITreeElement) {
                ITreeElement treeElement = (ITreeElement)element;
                return treeElement.getBackground();
            }
            return null;
        }

        @Override
        protected Color getTemporaryDefaultValue() {
            return null;
        }

        @Override
        protected void computationFinished() {
            BrowserLabelProvider.this.refreshBrowser();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FontComputation
    extends NonBlockingElementComputation<Font> {
        public FontComputation() {
            super(BrowserLabelProvider.this.getProgressService());
        }

        @Override
        protected Font basicCompute(Object element) {
            if (element instanceof ITreeElement) {
                ITreeElement treeElement = (ITreeElement)element;
                return treeElement.getFont();
            }
            return null;
        }

        @Override
        protected Font getTemporaryDefaultValue() {
            return null;
        }

        @Override
        protected void computationFinished() {
            BrowserLabelProvider.this.refreshBrowser();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ForegroundColorComputation
    extends NonBlockingElementComputation<Color> {
        public ForegroundColorComputation() {
            super(BrowserLabelProvider.this.getProgressService());
        }

        @Override
        protected Color basicCompute(Object element) {
            if (element instanceof ITreeElement) {
                ITreeElement treeElement = (ITreeElement)element;
                return treeElement.getForeground();
            }
            return null;
        }

        @Override
        protected Color getTemporaryDefaultValue() {
            return null;
        }

        @Override
        protected void computationFinished() {
            BrowserLabelProvider.this.refreshBrowser();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ImageComputation
    extends NonBlockingElementComputation<Image> {
        public ImageComputation() {
            super(BrowserLabelProvider.this.getProgressService());
        }

        @Override
        protected Image basicCompute(Object element) {
            if (element instanceof ITreeElement) {
                ITreeElement treeElement = (ITreeElement)element;
                return treeElement.getImage();
            }
            return null;
        }

        @Override
        protected Image getTemporaryDefaultValue() {
            return null;
        }

        @Override
        protected void computationFinished() {
            BrowserLabelProvider.this.refreshBrowser();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TextComputation
    extends NonBlockingElementComputation<String> {
        public TextComputation() {
            super(BrowserLabelProvider.this.getProgressService());
        }

        @Override
        protected String basicCompute(Object element) {
            String prefix = element instanceof ModelElementItem ? " " : "";
            if (element instanceof ITreeElement) {
                ITreeElement treeElement = (ITreeElement)element;
                return String.valueOf(prefix) + treeElement.getText();
            }
            if (element == EcoreBrowser.LOADING_MESSAGE) {
                return EcoreBrowser.LOADING_MESSAGE;
            }
            return String.valueOf(prefix) + element.toString();
        }

        @Override
        protected String getTemporaryDefaultValue() {
            return EcoreBrowser.LOADING_MESSAGE;
        }

        @Override
        protected void computationFinished() {
            BrowserLabelProvider.this.refreshBrowser();
        }
    }
}

