/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.common;

import org.eclipse.gmt.modisco.usecase.simpletransformationschain.controller.ControllerServices;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.ModelEvents;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.modelplex.AtlTransformation;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.model.modelplex.ModelplexTransformation;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.data.ElementDisplay;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.data.TransformationContentProvider;
import org.eclipse.gmt.modisco.usecase.simpletransformationschain.ui.data.TransformationLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TransformationTreeComposite
extends Composite
implements ModelEvents,
ICheckStateListener {
    private CheckboxTreeViewer additionalTransformationsTreeViewer = null;
    private TransformationContentProvider transformationContentProvider;
    private final ModelplexTransformation model;
    private final ControllerServices controller;

    public TransformationTreeComposite(Composite parent, int style, ControllerServices controllerParameter, ModelplexTransformation modelParameter) {
        super(parent, style);
        this.controller = controllerParameter;
        this.model = modelParameter;
        this.initialize();
    }

    private void initialize() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.additionalTransformationsTreeViewer = new CheckboxTreeViewer((Composite)this, 2048);
        this.additionalTransformationsTreeViewer.getTree().setLayoutData((Object)gridData);
        this.additionalTransformationsTreeViewer.getControl().setLayoutData((Object)gridData);
        this.transformationContentProvider = new TransformationContentProvider();
        this.additionalTransformationsTreeViewer.setContentProvider((IContentProvider)this.transformationContentProvider);
        this.additionalTransformationsTreeViewer.setLabelProvider((IBaseLabelProvider)new TransformationLabelProvider());
        this.additionalTransformationsTreeViewer.setInput((Object)this.model);
        this.additionalTransformationsTreeViewer.setComparator(null);
        this.initializeCheckedState();
        this.additionalTransformationsTreeViewer.addCheckStateListener((ICheckStateListener)this);
        this.setLayoutData(gridData);
        this.setSize(new Point(300, 200));
        this.setLayout((Layout)new GridLayout());
    }

    private final void initializeCheckedState() {
        for (ElementDisplay elementDisplay : this.transformationContentProvider.getTransformations()) {
            this.additionalTransformationsTreeViewer.setChecked((Object)elementDisplay, elementDisplay.getModelElement().isSelected());
        }
    }

    public void chainedTransformationAdded(ModelplexTransformation modelplexTransformation, AtlTransformation additionalTransformation) {
        if (this.model == modelplexTransformation) {
            this.transformationContentProvider.chainedTransformationAdded(modelplexTransformation, additionalTransformation);
            this.additionalTransformationsTreeViewer.refresh(false);
            this.initializeCheckedState();
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        AtlTransformation atlTransformation = ((ElementDisplay)event.getElement()).getModelElement();
        this.controller.updateAdditionalTransformation(atlTransformation, this.model, event.getChecked());
    }

    public ITreeSelection getSelection() {
        return (ITreeSelection)this.additionalTransformationsTreeViewer.getSelection();
    }

    public void chainedTransformationRemoved(ModelplexTransformation modelplexTransformation, AtlTransformation removedTransformation) {
        if (this.model == modelplexTransformation) {
            this.transformationContentProvider.chainedTransformationRemoved(modelplexTransformation, removedTransformation);
            this.additionalTransformationsTreeViewer.refresh(false);
        }
    }

    public void chainedTransformationUpdated(ModelplexTransformation modelplexTransformation, AtlTransformation updatedTransformation) {
        if (this.model == modelplexTransformation) {
            this.transformationContentProvider.chainedTransformationUpdated(modelplexTransformation, updatedTransformation);
            this.additionalTransformationsTreeViewer.refresh();
            this.initializeCheckedState();
        }
    }

    public void modelplexTransformationUpdated(ModelplexTransformation modelplexTransformation) {
        if (this.model == modelplexTransformation) {
            this.transformationContentProvider.modelplexTransformationUpdated(modelplexTransformation);
            this.additionalTransformationsTreeViewer.refresh();
            this.initializeCheckedState();
        }
    }
}

