/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.utils.chart.birt.core.internal.exported;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.NumberFormatSpecifierImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.modisco.utils.chart.birt.core.internal.GraphHelperException;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Axe;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Coordinate;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Point;
import org.eclipse.modisco.utils.chart.metamodel.internal.chart.Serie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BirtGraphHelper {
    private static final double UNIT_SPACING = 0.1;
    private static BirtGraphHelper instance;
    private List<ColorDefinition> colors = new ArrayList<ColorDefinition>();
    private static final int CHART_WIDTH = 800;
    private static final int CHART_HEIGHT = 400;

    public List<ColorDefinition> getColors() {
        return this.colors;
    }

    public void setColors(List<ColorDefinition> colors) {
        this.colors = colors;
    }

    private BirtGraphHelper() {
        this.colors.add(ColorDefinitionImpl.BLUE());
        this.colors.add(ColorDefinitionImpl.ORANGE());
        this.colors.add(ColorDefinitionImpl.GREEN());
        this.colors.add(ColorDefinitionImpl.RED());
        this.colors.add(ColorDefinitionImpl.CYAN());
        this.colors.add(ColorDefinitionImpl.PINK());
        this.colors.add(ColorDefinitionImpl.GREY());
        this.colors.add(ColorDefinitionImpl.YELLOW());
    }

    public static synchronized BirtGraphHelper getInstance() {
        if (instance == null) {
            instance = new BirtGraphHelper();
        }
        return instance;
    }

    public void createBirtGraph(org.eclipse.modisco.utils.chart.metamodel.internal.chart.Chart birtChart, File targetFolder, String fileName) throws Exception {
        ChartWithAxes chart = ChartWithAxesImpl.create();
        if (birtChart.getAxes().size() != 2) {
            throw new GraphHelperException("the chart should have only 2 dimensions");
        }
        chart.setDimension(ChartDimension.TWO_DIMENSIONAL_LITERAL);
        chart.setUnitSpacing(0.1);
        chart.getPlot().setBackground((Fill)ColorDefinitionImpl.WHITE());
        chart.getPlot().getClientArea().setBackground((Fill)ColorDefinitionImpl.WHITE());
        chart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
        chart.getLegend().setVisible(true);
        chart.getLegend().setAnchor(Anchor.NORTH_EAST_LITERAL);
        chart.getTitle().getLabel().getCaption().setValue(birtChart.getTitle());
        Axe abs = (Axe)birtChart.getAxes().get(0);
        Axe ord = (Axe)birtChart.getAxes().get(1);
        Axis xAxis = chart.getPrimaryBaseAxes()[0];
        xAxis.setType(AxisType.LINEAR_LITERAL);
        xAxis.setFormatSpecifier((FormatSpecifier)NumberFormatSpecifierImpl.create());
        xAxis.getTitle().getCaption().setValue(String.valueOf(abs.getLegend()) + " (" + abs.getUnit() + ")");
        xAxis.getTitle().setVisible(true);
        ArrayList<org.eclipse.birt.chart.computation.Point> dataPoints = new ArrayList<org.eclipse.birt.chart.computation.Point>();
        SeriesDefinition ySeriesDefinition = SeriesDefinitionImpl.create();
        Comparator<org.eclipse.birt.chart.computation.Point> comparator = new Comparator<org.eclipse.birt.chart.computation.Point>(){

            @Override
            public int compare(org.eclipse.birt.chart.computation.Point point1, org.eclipse.birt.chart.computation.Point point2) {
                if (point1.x == point2.x) {
                    return 0;
                }
                if (point1.x < point2.x) {
                    return -1;
                }
                return 1;
            }
        };
        for (Serie serie : birtChart.getSeries()) {
            dataPoints.clear();
            for (Point point : serie.getPoints()) {
                double xCoord = 0.0;
                double yCoord = 0.0;
                for (Coordinate coord : point.getCoordinates()) {
                    if (coord.getAxe().equals(abs)) {
                        xCoord = coord.getValue();
                    }
                    if (!coord.getAxe().equals(ord)) continue;
                    yCoord = coord.getValue();
                }
                org.eclipse.birt.chart.computation.Point birtPoint = new org.eclipse.birt.chart.computation.Point(xCoord, yCoord);
                dataPoints.add(birtPoint);
            }
            Collections.sort(dataPoints, comparator);
            ColorDefinition serieColor = this.getColorForSerie(birtChart.getSeries().indexOf((Object)serie));
            LineSeries lineSeries = (LineSeries)LineSeriesImpl.create();
            lineSeries.setSeriesIdentifier((Object)serie.getName());
            lineSeries.setCurve(false);
            ArrayList<Double> yAxisValues = new ArrayList<Double>();
            for (org.eclipse.birt.chart.computation.Point dataPoint : dataPoints) {
                yAxisValues.add(dataPoint.y);
            }
            NumberDataSet dataSet = NumberDataSetImpl.create(yAxisValues);
            lineSeries.setDataSet((DataSet)dataSet);
            lineSeries.getMarkers().clear();
            LineAttributes lineAttr = LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1);
            lineAttr.setVisible(true);
            lineAttr.setColor(serieColor);
            lineSeries.setLineAttributes(lineAttr);
            org.eclipse.birt.chart.computation.Point[] linearRegression = BirtGraphHelper.computeLinearRegression(dataPoints);
            LineSeries linearRegSeries = (LineSeries)LineSeriesImpl.create();
            ArrayList<Double> regressionYAxisValues = new ArrayList<Double>();
            org.eclipse.birt.chart.computation.Point[] pointArray = linearRegression;
            int n = linearRegression.length;
            int n2 = 0;
            while (n2 < n) {
                org.eclipse.birt.chart.computation.Point point = pointArray[n2];
                regressionYAxisValues.add(point.y);
                ++n2;
            }
            NumberDataSet linearRegDataSet = NumberDataSetImpl.create(regressionYAxisValues);
            linearRegSeries.setDataSet((DataSet)linearRegDataSet);
            linearRegSeries.getMarkers().clear();
            LineAttributes lineAttr2 = LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK(), (LineStyle)LineStyle.DASHED_LITERAL, (int)1);
            lineAttr2.setVisible(true);
            lineAttr2.setColor(serieColor);
            linearRegSeries.setLineAttributes(lineAttr2);
            ySeriesDefinition.getSeries().add((Object)lineSeries);
            ySeriesDefinition.getSeries().add((Object)linearRegSeries);
        }
        ArrayList<Double> xAxisValues = new ArrayList<Double>();
        for (org.eclipse.birt.chart.computation.Point dataPoint : dataPoints) {
            xAxisValues.add(dataPoint.x);
        }
        NumberDataSet xAxisDataSet = NumberDataSetImpl.create(xAxisValues);
        Series xAxisSeries = SeriesImpl.create();
        xAxisSeries.setDataSet((DataSet)xAxisDataSet);
        SeriesDefinition xSeriesDefinition = SeriesDefinitionImpl.create();
        xSeriesDefinition.getSeries().add((Object)xAxisSeries);
        xAxis.getSeriesDefinitions().add((Object)xSeriesDefinition);
        Axis yAxis = chart.getPrimaryOrthogonalAxis(xAxis);
        yAxis.setType(AxisType.LINEAR_LITERAL);
        yAxis.setFormatSpecifier((FormatSpecifier)NumberFormatSpecifierImpl.create());
        yAxis.getTitle().setVisible(true);
        yAxis.getTitle().getCaption().setValue(String.valueOf(ord.getLegend()) + " (" + ord.getUnit() + ")");
        yAxis.getSeriesDefinitions().add((Object)ySeriesDefinition);
        PluginSettings pSettings = PluginSettings.instance();
        IDeviceRenderer render = pSettings.getDevice("dv.PNG");
        render.setProperty("device.file.identifier", (Object)new File(targetFolder, String.valueOf(fileName) + ".png"));
        Bounds bounds = BoundsImpl.create((double)0.0, (double)0.0, (double)800.0, (double)400.0);
        Generator generator = Generator.instance();
        GeneratedChartState state = generator.build(render.getDisplayServer(), (Chart)chart, bounds, null, null, null);
        generator.render(render, state);
    }

    private ColorDefinition getColorForSerie(int indexOf) {
        return this.colors.get(indexOf % this.colors.size());
    }

    private static org.eclipse.birt.chart.computation.Point[] computeLinearRegression(List<org.eclipse.birt.chart.computation.Point> dataPoints) {
        double size = dataPoints.size();
        if ((int)size == 0) {
            return new org.eclipse.birt.chart.computation.Point[0];
        }
        if ((int)size == 1) {
            org.eclipse.birt.chart.computation.Point point = dataPoints.get(0);
            return new org.eclipse.birt.chart.computation.Point[]{new org.eclipse.birt.chart.computation.Point(point.x, point.y)};
        }
        double sumXY = 0.0;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        for (org.eclipse.birt.chart.computation.Point point : dataPoints) {
            sumX += point.x;
            sumXX += point.x * point.x;
            sumY += point.y;
            sumXY += point.x * point.y;
        }
        double a = (size * sumXY - sumX * sumY) / (size * sumXX - sumX * sumX);
        double b = (sumY - a * sumX) / size;
        ArrayList<org.eclipse.birt.chart.computation.Point> resultPoints = new ArrayList<org.eclipse.birt.chart.computation.Point>();
        for (org.eclipse.birt.chart.computation.Point point : dataPoints) {
            resultPoints.add(new org.eclipse.birt.chart.computation.Point(point.x, a * point.x + b));
        }
        return resultPoints.toArray(new org.eclipse.birt.chart.computation.Point[resultPoints.size()]);
    }
}

