/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.infra.common.core.internal.utils.FolderUtils;
import org.osgi.framework.Bundle;

public final class FileUtils {
    private FileUtils() {
    }

    public static String getContents(File file) throws IOException {
        StringBuilder contents = new StringBuilder(1024);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        char[] buffer = new char[1024];
        int read = 0;
        while ((read = reader.read(buffer)) != -1) {
            contents.append(buffer, 0, read);
        }
        reader.close();
        return contents.toString();
    }

    public static IFile copyFileFromBundle(String sourcePath, IProject project, String destinationPath, Bundle bundleContainingResources) throws IOException, CoreException {
        InputStream source;
        URL url;
        try {
            url = bundleContainingResources.getResource(sourcePath);
            source = url.openStream();
        }
        catch (NullPointerException nullPointerException) {
            url = bundleContainingResources.getEntry(sourcePath);
            try {
                source = url.openStream();
            }
            catch (NullPointerException nullPointerException2) {
                throw new IOException(String.valueOf(sourcePath) + " not found.");
            }
        }
        IFile javaFile = project.getFile(destinationPath);
        if (javaFile.exists()) {
            javaFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!javaFile.getParent().exists()) {
            FolderUtils.createFolder((IFolder)javaFile.getParent());
        }
        javaFile.create(source, true, (IProgressMonitor)new NullProgressMonitor());
        return javaFile;
    }

    public static void checkEMFResource(URI uri, int nbRoot) throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uri, true);
        resource.load(Collections.EMPTY_MAP);
        EcoreUtil.resolveAll((Resource)resource);
        if (nbRoot != resource.getContents().size()) {
            throw new Exception("Wrong number of root element: " + nbRoot + " expected, " + resource.getContents().size() + " found.");
        }
        if (resource.getErrors().size() != 0) {
            throw new Exception("The resource contains errors.");
        }
    }

    public static IFile getWorkspaceFile(Resource resource) {
        URI uri = resource.getURI();
        if (uri != null && uri.isPlatformResource() && uri.segmentCount() >= 2) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(uri.segment(1));
            Path path = new Path("/");
            int i = 2;
            while (i < uri.segmentCount()) {
                path = path.append(uri.segment(i));
                ++i;
            }
            IFile file = project.getFile((IPath)path);
            if (file.exists()) {
                return file;
            }
        }
        return null;
    }

    public static String getFileContents(Bundle bundle, String path) throws IOException {
        URL url = bundle.getResource(path);
        if (url == null) {
            return null;
        }
        InputStream source = url.openStream();
        return FileUtils.readInputStream(source);
    }

    public static String readInputStream(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        StringBuilder builder = new StringBuilder();
        String line = null;
        while ((line = reader.readLine()) != null) {
            builder.append(line).append("\n");
        }
        reader.close();
        return builder.toString();
    }

    public static void checkNoMarkerOn(IFile file) throws CoreException {
        IMarker[] markers = null;
        markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        if (markers.length != 0) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.gmt.modisco.infra.common.core", 0, "Markers found on: " + file, (Throwable)new Exception());
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String message = (String)marker.getAttribute("message");
                Status status = new Status(4, "org.eclipse.gmt.modisco.infra.common.core", message);
                multiStatus.add((IStatus)status);
                ++n2;
            }
            throw new CoreException((IStatus)multiStatus);
        }
    }
}

