/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.utils;

import org.eclipse.gmt.modisco.infra.common.core.internal.Messages;

public final class StringUtils {
    public static final String ELLIPSIS = Messages.StringUtils_ellipsis;
    private static final int TRUNCATE_AFTER = 100;

    private StringUtils() {
    }

    public static String firstLetterToLowerCase(String source) {
        String result = source.length() == 0 ? source : (source.length() == 1 ? source.toLowerCase() : String.valueOf(source.substring(0, 1).toLowerCase()) + source.substring(1));
        return result;
    }

    public static String firstLetterToUpperCase(String source) {
        String result = source.length() == 0 ? source : (source.length() == 1 ? source.toUpperCase() : String.valueOf(source.substring(0, 1).toUpperCase()) + source.substring(1));
        return result;
    }

    public static String truncateBeforeNewline(String str) {
        int index = str.indexOf(13);
        if (index == -1) {
            index = str.indexOf(10);
        }
        if (index != -1 && index > 100 || index == -1 && str.length() > 100) {
            index = 100;
        }
        if (index != -1) {
            return String.valueOf(str.substring(0, index)) + ELLIPSIS;
        }
        return str;
    }

    public static String inferJavaClassName(String name) {
        String upperName = StringUtils.firstLetterToUpperCase(name.trim());
        StringBuilder javaName = new StringBuilder();
        boolean space = false;
        int i = 0;
        while (i < upperName.length()) {
            char c = upperName.charAt(i);
            if (c == ' ') {
                space = true;
            } else if (space) {
                javaName.append(Character.toUpperCase(c));
                space = false;
            } else {
                javaName.append(c);
            }
            ++i;
        }
        return javaName.toString();
    }
}

