/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.common.core.internal.utils;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gmt.modisco.infra.common.core.internal.CommonModiscoActivator;

public final class Tools {
    private static final String ENCODING_PROPERTY = "file.encoding";

    private Tools() {
    }

    public static boolean saveModel(Resource resource, String outputLocation) {
        URI outputURI = URI.createFileURI((String)outputLocation);
        return Tools.saveModel(resource, outputURI);
    }

    public static boolean saveModel(Resource resource, URI outputURI) {
        boolean success = true;
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        resource.setURI(outputURI);
        try {
            resource.save(options);
        }
        catch (IOException e) {
            success = false;
            Status status = new Status(4, "org.eclipse.gmt.modisco.infra.common.core", "Error happened while saving a resource: " + resource.getURI(), (Throwable)e);
            CommonModiscoActivator.getDefault().getLog().log((IStatus)status);
        }
        return success;
    }

    public static void save(EObject root, String outputLocation) throws IOException {
        URI modelURI = URI.createFileURI((String)outputLocation);
        Tools.save(root, modelURI);
    }

    public static void save(EObject root, URI modelURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource newModelResource = resourceSet.createResource(modelURI);
        newModelResource.getContents().add((Object)root);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", System.getProperty(ENCODING_PROPERTY));
        newModelResource.save(options);
    }
}

