/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.discoverymanager;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.handlers.DiscovererHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryManager
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.gmt.modisco.infra.discoverymanager";
    private static DiscoveryManager plugin;
    private List<DiscovererHandler> discoverers;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        context.getBundle();
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static DiscoveryManager getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public List<? extends Discoverer> getDiscoverers() {
        return this.getDiscovererHandlers();
    }

    public List<DiscovererHandler> getDiscovererHandlers() {
        if (this.discoverers == null) {
            this.discoverers = new ArrayList<DiscovererHandler>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("org.eclipse.gmt.modisco.discoverers");
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    String discovererClass = element.getAttribute("class");
                    if (discovererClass != null) {
                        try {
                            String iconPath;
                            Discoverer discoverer = (Discoverer)element.createExecutableExtension("class");
                            DiscovererHandler handler = new DiscovererHandler(discoverer);
                            String discovererName = element.getAttribute("name");
                            if (discovererName == null) {
                                handler.setName(discoverer.toString());
                            } else {
                                handler.setName(discovererName);
                            }
                            String discovererPath = element.getAttribute("path");
                            if (discovererPath != null) {
                                String[] paths = discovererPath.split("/");
                                handler.setPaths(paths);
                            }
                            if ((iconPath = element.getAttribute("icon")) != null) {
                                Bundle b = Platform.getBundle((String)extension.getNamespaceIdentifier());
                                URL url = b.getResource(iconPath);
                                handler.setImageIcon(ImageDescriptor.createFromURL((URL)url).createImage());
                            }
                            this.discoverers.add(handler);
                        }
                        catch (CoreException e) {
                            String message = "A problem occured when instantiating discoverer configuration: " + element.getValue();
                            MoDiscoLogger.logWarning((Throwable)e, (String)message, (Plugin)DiscoveryManager.getDefault());
                        }
                    } else {
                        String message = "A problem occured when retrieving discoverer configuration: " + element.getValue();
                        MoDiscoLogger.logWarning((String)message, (Plugin)DiscoveryManager.getDefault());
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return this.discoverers;
    }

    public Discoverer getDiscoverer(String discovererName) {
        DiscovererHandler result = null;
        for (DiscovererHandler handler : this.getDiscovererHandlers()) {
            if (!handler.getName().equals(discovererName)) continue;
            result = handler;
        }
        return result;
    }
}

