/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark.emfstat;

import java.io.File;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.actions.DefaultDiscoverer;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emfstat.JavaReaderEMFStat;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emfstat.Statistics;
import org.eclipse.gmt.modisco.java.internal.actions.DiscoverSimpleJavaModelFromJavaProject;
import org.eclipse.gmt.modisco.java.io.java.JavaReader;
import org.eclipse.jdt.core.IJavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverJavaModelFromJavaProjectEMFStat
extends DiscoverSimpleJavaModelFromJavaProject {
    private static final int MEGA_BYTES = 1024;
    private static final int BUFFER_SIZE = 10000;
    public static final String STORAGE_KIND = "STORAGE_KIND";
    public static final String JAVA_PROJECT_NAME = "JAVA_PROJECT_NAME";
    public static final String DISCOVERER_CLASS_NAME = "DISCOVERER_CLASS_NAME";
    public static final String DISCOVERY_DATE = "DISCOVERY_DATE";
    public static final String XMX = "XMX";
    public static final String MM_VARIANTE = "MM_VARIANTE";
    public static final String ALGO_VARIANTE = "ALGO_VARIANTE";
    private Statistics statistics;
    private IProject statProject;

    protected boolean getEnableValidation() {
        return true;
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        HashMap<DiscoveryParameter, Object> localParameters = new HashMap<DiscoveryParameter, Object>();
        localParameters.putAll(parameters);
        localParameters.put(DefaultDiscoverer.PARAMETER_BROWSE_RESULT, new Boolean(false));
        localParameters.put(DefaultDiscoverer.PARAMETER_SILENT_MODE, new Boolean(true));
        IJavaProject javaProject = (IJavaProject)source;
        this.setStatistics(this.getStatistics(javaProject));
        if (this.getStatistics() != null) {
            this.getStatistics().getProperties().put(JAVA_PROJECT_NAME, javaProject.getElementName());
            this.getStatistics().getProperties().put(DISCOVERER_CLASS_NAME, ((Object)((Object)this)).getClass().getName());
            this.getStatistics().getProperties().put(DISCOVERY_DATE, new Date().toString());
            this.getStatistics().getProperties().putAll((Map<?, ?>)this.getProperties());
            this.getStatistics().begin();
        }
        super.discoverElement(source, localParameters);
        if (this.getStatistics() != null) {
            this.getStatistics().end();
        }
    }

    protected Statistics getStatistics(IJavaProject javaProject) {
        Statistics statisticsResult;
        if (this.statProject != null) {
            File projectFile = this.statProject.getLocation().toFile();
            statisticsResult = Statistics.getStatistics(String.valueOf(javaProject.getElementName()) + "_" + System.currentTimeMillis(), projectFile);
        } else {
            File projectFile = this.getDefaultStatProject(javaProject).getLocation().toFile();
            statisticsResult = Statistics.getStatistics(String.valueOf(javaProject.getElementName()) + "_" + System.currentTimeMillis(), projectFile);
        }
        return statisticsResult;
    }

    private IProject getDefaultStatProject(IJavaProject sourceProject) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject localStatProject = ws.getRoot().getProject("statistics_" + System.currentTimeMillis() + "_" + sourceProject.getElementName());
        try {
            localStatProject.create((IProgressMonitor)new NullProgressMonitor());
            localStatProject.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer", e.getMessage(), (Throwable)e);
            JavaActivator.getDefault().getLog().log((IStatus)status);
            localStatProject = null;
        }
        return localStatProject;
    }

    public void saveResource(URI target, IPath path, Resource resource, IProgressMonitor monitor) throws IOException {
        if (this.getStatistics() != null) {
            this.getStatistics().beginSave();
        }
        HashMap<String, Constable> optionMap = new HashMap<String, Constable>();
        optionMap.put("FLUSH_THRESHOLD", Integer.valueOf(10000));
        optionMap.put("USE_FILE_BUFFER", Boolean.valueOf(true));
        monitor.subTask("Saving model");
        if (target != null) {
            resource.setURI(target);
        } else {
            URI uri = URI.createFileURI((String)path.toString());
            resource.setURI(uri);
        }
        resource.save(optionMap);
        if (this.getStatistics() != null) {
            this.getStatistics().endSave();
        }
    }

    public Resource getResource(String resourceName, IJavaProject javaProject) {
        Status status = new Status(1, "org.eclipse.gmt.modisco.java.discoverer.benchmark", "Resource name=" + javaProject.getElementName() + "_" + System.currentTimeMillis());
        Activator.getDefault().getLog().log((IStatus)status);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)("file:///" + javaProject.getProject().getLocation().toString() + "/" + resourceName + ".javaxmi")));
        return resource;
    }

    protected Properties getProperties() {
        Properties properties = new Properties();
        properties.put(STORAGE_KIND, "XMI");
        properties.put(XMX, String.valueOf(Runtime.getRuntime().maxMemory() / 1024L / 1024L) + "Mo");
        return properties;
    }

    protected JavaReader getJavaReader(boolean isIncremental) {
        JavaReaderEMFStat javaReader = new JavaReaderEMFStat(this.getEFactory(), false);
        javaReader.setStatistics(this.getStatistics());
        return javaReader;
    }

    public void setStatProject(IProject statProject) {
        this.statProject = statProject;
    }

    public void setStatistics(Statistics aStatistics) {
        this.statistics = aStatistics;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }
}

