/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.actions;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.CompilationUnit;
import org.eclipse.gmt.modisco.java.FieldDeclaration;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.VariableDeclaration;
import org.eclipse.gmt.modisco.java.actions.Messages;
import org.eclipse.gmt.modisco.java.internal.core.JavaJdtBridge;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseJavaCode
extends AbstractDiscovererImpl {
    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        ASTNode node = (ASTNode)source;
        this.browseJavaCode(node);
    }

    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof ASTNode) {
            result = true;
        }
        return result;
    }

    public void browseJavaCode(ASTNode node) {
        CompilationUnit compilationUnit = node.getOriginalCompilationUnit();
        if (node instanceof CompilationUnit) {
            compilationUnit = (CompilationUnit)node;
        }
        if (compilationUnit != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path filePath = new Path(compilationUnit.getOriginalFilePath());
            final IFile ifile = root.getFileForLocation((IPath)filePath);
            final IJavaElement jdtElement = this.findCorrespondingJdtElement(node, compilationUnit);
            if (ifile != null && ifile.exists()) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            if (jdtElement != null) {
                                JavaUI.openInEditor((IJavaElement)jdtElement);
                            } else {
                                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                IDE.openEditor((IWorkbenchPage)page, (IFile)ifile);
                            }
                        }
                        catch (PartInitException e) {
                            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
                        }
                        catch (JavaModelException e) {
                            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
                        }
                    }
                });
            } else {
                MoDiscoLogger.logInfo((String)(String.valueOf(Messages.BrowseJavaCode_noFileFound) + filePath), (Plugin)JavaActivator.getDefault());
            }
        } else {
            MoDiscoLogger.logInfo((String)Messages.BrowseJavaCode_notHandledJavaElement, (Plugin)JavaActivator.getDefault());
        }
    }

    private IJavaElement findCorrespondingJdtElement(ASTNode node, CompilationUnit compilationUnit) {
        IMethod result = null;
        EObject eobject = compilationUnit.eContainer();
        if (eobject instanceof Model) {
            String projectName;
            Model model = (Model)eobject;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(projectName = model.getName());
            if (project != null) {
                IJavaProject tempProject = null;
                if (project instanceof IJavaProject) {
                    tempProject = (IJavaProject)project;
                } else {
                    try {
                        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                            tempProject = JavaCore.create((IProject)project);
                        }
                    }
                    catch (CoreException e) {
                        MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
                    }
                }
                IJavaProject javaProject = tempProject;
                if (node instanceof AbstractMethodDeclaration) {
                    AbstractMethodDeclaration operation = (AbstractMethodDeclaration)node;
                    JavaJdtBridge bridge = new JavaJdtBridge();
                    result = bridge.getJdtOperation(javaProject, operation);
                } else if (node instanceof VariableDeclaration) {
                    VariableDeclaration field = (VariableDeclaration)node;
                    JavaJdtBridge bridge = new JavaJdtBridge();
                    result = bridge.getJdtField(javaProject, field);
                } else if (node instanceof FieldDeclaration) {
                    FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
                    VariableDeclaration field = (VariableDeclaration)fieldDeclaration.getFragments().get(0);
                    JavaJdtBridge bridge = new JavaJdtBridge();
                    result = bridge.getJdtField(javaProject, field);
                }
            } else {
                MoDiscoLogger.logInfo((String)(String.valueOf(Messages.BrowseJavaCode_projectNotFound) + projectName), (Plugin)JavaActivator.getDefault());
            }
        }
        return result;
    }
}

