/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterImpl;
import org.eclipse.gmt.modisco.java.IModelReader;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.actions.DefaultDiscoverer;
import org.eclipse.gmt.modisco.java.actions.DiscoveryParametersBean;
import org.eclipse.gmt.modisco.java.actions.Messages;
import org.eclipse.gmt.modisco.java.actions.ui.JavaWizard;
import org.eclipse.gmt.modisco.java.io.java.JavaReader;
import org.eclipse.gmt.modisco.java.io.java.binding.BindingManager;
import org.eclipse.gmt.modisco.java.io.library.LibraryReader;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverJavaModelFromJavaProject
extends DefaultDiscoverer {
    private static List<DiscoveryParameter> parametersKeys = null;
    public static final DiscoveryParameter PARAMETERS_BEAN = new DiscoveryParameterImpl("PARAMETERS_BEAN", DiscoveryParameterDirectionKind.in, DiscoveryParameter.class, false);
    private boolean isCancelled = false;
    private static Map<String, DiscoveryParametersBean> projectToDiscoParametersCache = new HashMap<String, DiscoveryParametersBean>();
    private DiscoveryParametersBean currentProjectParameters = null;

    public DiscoveryParametersBean getCurrentProjectParameters() {
        return this.currentProjectParameters;
    }

    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IJavaProject) {
            result = ((IJavaProject)source).getProject().isAccessible();
        } else if (source instanceof IProject) {
            IProject project = (IProject)source;
            try {
                if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                    result = true;
                }
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            }
        }
        return result;
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        IJavaProject project;
        boolean isSilent = false;
        boolean browseResult = true;
        if (parameters != null) {
            isSilent = Boolean.TRUE.equals(parameters.get(DefaultDiscoverer.PARAMETER_SILENT_MODE));
            browseResult = !Boolean.FALSE.equals(parameters.get(DefaultDiscoverer.PARAMETER_BROWSE_RESULT));
        }
        this.setResourceResult(null);
        IJavaProject tempProject = null;
        if (source instanceof IJavaProject) {
            tempProject = (IJavaProject)source;
        } else if (source instanceof IProject) {
            project = (IProject)source;
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    tempProject = JavaCore.create((IProject)project);
                }
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            }
        }
        project = tempProject;
        final IPath path = project.getProject().getLocation().addTrailingSeparator().append(project.getElementName()).addFileExtension("javaxmi");
        final List<Object> discoverableElements = this.retrieveDiscoveryParameters(parameters, project);
        if (!isSilent) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    JavaWizard wizard;
                    Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)(wizard = new JavaWizard(project, discoverableElements, DiscoverJavaModelFromJavaProject.this.getCurrentProjectParameters())));
                    int res = dialog.open();
                    if (res == 1) {
                        DiscoverJavaModelFromJavaProject.this.setCancelled(true);
                    }
                }
            });
            if (this.isCancelled()) {
                this.resetDiscoverer();
                return;
            }
        }
        Job job = new Job(Messages.DiscoverJavaModelFromJavaProject_jobLabel){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = null;
                monitor.beginTask("", -1);
                try {
                    URI sourceURI = URI.createFileURI((String)path.toString());
                    Resource resource = DiscoverJavaModelFromJavaProject.this.getResource("", project);
                    Model model = DiscoverJavaModelFromJavaProject.this.getEFactory().createModel();
                    BindingManager globalBindings = DiscoverJavaModelFromJavaProject.this.getBindingManager();
                    resource.getContents().add((Object)model);
                    IModelReader reader = null;
                    for (Map.Entry<IModelReader, Object> element : DiscoverJavaModelFromJavaProject.this.getReaders().entrySet()) {
                        reader = element.getKey();
                        Object source1 = element.getValue();
                        reader.readModel(source1, model, globalBindings, monitor);
                        if (!monitor.isCanceled()) continue;
                        IStatus iStatus = result = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (reader != null) {
                        reader.terminate(monitor);
                    }
                    model.setName(project.getElementName());
                    DiscoverJavaModelFromJavaProject.this.saveResource(sourceURI, path, resource, monitor);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = result = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        result = Status.OK_STATUS;
                        DiscoverJavaModelFromJavaProject.this.setResourceResult(resource);
                    }
                    catch (Exception e) {
                        result = Status.CANCEL_STATUS;
                        Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer", "Unkown error.", (Throwable)e);
                        JavaActivator.getDefault().getLog().log((IStatus)status);
                    }
                }
                finally {
                    monitor.done();
                    DiscoverJavaModelFromJavaProject.this.resetDiscoverer();
                    try {
                        IWorkspaceRoot root;
                        IFile ifile;
                        project.getCorrespondingResource().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                        if (monitor.isCanceled() && (ifile = (root = ResourcesPlugin.getWorkspace().getRoot()).getFileForLocation(path)).exists()) {
                            ifile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (Exception e1) {
                        Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer", e1.getMessage(), (Throwable)e1);
                        JavaActivator.getDefault().getLog().log((IStatus)status);
                    }
                }
                return result;
            }
        };
        if (!isSilent && browseResult) {
            this.scheduleEditorOpening(ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path), job, parameters);
        }
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer", e.getMessage(), (Throwable)e);
            JavaActivator.getDefault().getLog().log((IStatus)status);
        }
        if (parameters != null) {
            parameters.put(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE, this.getResourceResult());
        }
    }

    private List<Object> retrieveDiscoveryParameters(Map<DiscoveryParameter, Object> parameters, IJavaProject project) {
        Set<IJavaProject> projects = null;
        Set<IPackageFragmentRoot> libraries = null;
        try {
            projects = this.computeRequiredProjects(project);
            libraries = this.computeRequiredLibraries(projects);
        }
        catch (JavaModelException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
        }
        ArrayList<Object> discoverableElements = new ArrayList<Object>();
        discoverableElements.addAll(projects);
        discoverableElements.addAll(libraries);
        this.currentProjectParameters = parameters != null && parameters.get(PARAMETERS_BEAN) != null ? (DiscoveryParametersBean)parameters.get(PARAMETERS_BEAN) : this.getParameters(project);
        ArrayList<Object> elementsToRemove = new ArrayList<Object>();
        for (Object oldParameter : this.currentProjectParameters.getElementsToDiscover()) {
            if (oldParameter.equals(project) || discoverableElements.contains(oldParameter)) continue;
            elementsToRemove.add(oldParameter);
        }
        for (Object oldParameterToRemove : elementsToRemove) {
            this.currentProjectParameters.removeElementToDiscover(oldParameterToRemove);
        }
        return discoverableElements;
    }

    public String toString() {
        return Messages.DiscoverJavaModelFromJavaProject_title;
    }

    protected Set<IJavaProject> computeRequiredProjects(IJavaProject project) throws JavaModelException {
        LinkedHashSet<IJavaProject> projects = new LinkedHashSet<IJavaProject>();
        projects.add(project);
        String[] stringArray = project.getRequiredProjectNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            IJavaProject requiredProject = project.getJavaModel().getJavaProject(projectName);
            if (requiredProject.getProject().isAccessible()) {
                projects.add(requiredProject);
            }
            ++n2;
        }
        return projects;
    }

    protected Set<IPackageFragmentRoot> computeRequiredLibraries(Collection<IJavaProject> projects) throws JavaModelException {
        LinkedHashSet<IPackageFragmentRoot> libraries = new LinkedHashSet<IPackageFragmentRoot>();
        for (IJavaProject project : projects) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot lib = iPackageFragmentRootArray[n2];
                if (lib.exists() && lib.getKind() == 2) {
                    libraries.add(lib);
                }
                ++n2;
            }
        }
        return libraries;
    }

    protected Map<IModelReader, Object> getReaders() {
        HashMap<IModelReader, Object> readers = new HashMap<IModelReader, Object>();
        for (Object element : this.currentProjectParameters.getElementsToDiscover()) {
            Map<String, Object> elementOptions = this.currentProjectParameters.getDiscoveryOptions(element);
            if (element instanceof IJavaProject) {
                readers.put(new JavaReader(this.getEFactory(), elementOptions, this.currentProjectParameters.isIncrementalMode(), this.currentProjectParameters.isFullJavaLevel(), this.currentProjectParameters.getExcludedElements()), element);
                continue;
            }
            if (!(element instanceof IPackageFragmentRoot)) continue;
            readers.put(new LibraryReader(this.getEFactory(), elementOptions), element);
        }
        return readers;
    }

    protected void resetDiscoverer() {
        this.setCancelled(false);
    }

    protected BindingManager getBindingManager() {
        return new BindingManager(this.getEFactory());
    }

    protected DiscoveryParametersBean getParameters(IJavaProject project) {
        String projectPath = project.getProject().getLocation().toString();
        DiscoveryParametersBean parameters = projectToDiscoParametersCache.get(projectPath);
        if (parameters == null) {
            parameters = new DiscoveryParametersBean();
            parameters.addElementToDiscover(project);
            projectToDiscoParametersCache.put(projectPath, parameters);
        }
        return parameters;
    }

    public List<DiscoveryParameter> getDiscovererParameters() {
        if (parametersKeys == null) {
            parametersKeys = new ArrayList<DiscoveryParameter>();
            parametersKeys.add(DefaultDiscoverer.PARAMETER_SILENT_MODE);
            parametersKeys.add(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE);
            parametersKeys.add(PARAMETERS_BEAN);
            parametersKeys.add(DefaultDiscoverer.PARAMETER_BROWSE_RESULT);
        }
        return parametersKeys;
    }

    public void setCancelled(boolean cancel) {
        this.isCancelled = cancel;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }
}

